/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.exist.dom.QName;
import org.exist.util.Occurrences;
import org.exist.xmldb.IndexQueryService;
import org.exist.xmldb.RemoteCollection;
import org.exist.xmldb.XmldbURI;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

public class RemoteIndexQueryService
implements IndexQueryService {
    protected XmlRpcClient rpcClient = null;
    protected RemoteCollection parent;

    public RemoteIndexQueryService(XmlRpcClient client, RemoteCollection parent) {
        this.rpcClient = client;
        this.parent = parent;
    }

    public void reindexCollection() throws XMLDBException {
        this.reindexCollection(this.parent.getPath());
    }

    public void reindexCollection(String collectionPath) throws XMLDBException {
        try {
            this.reindexCollection(XmldbURI.xmldbUriFor(collectionPath));
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
    }

    public void reindexCollection(XmldbURI collectionPath) throws XMLDBException {
        if (this.parent != null) {
            collectionPath = this.parent.getPathURI().resolveCollectionPath(collectionPath);
        }
        Vector<String> params = new Vector<String>();
        params.addElement(collectionPath.toString());
        try {
            this.rpcClient.execute("reindexCollection", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(0, "xmlrpc error while doing reindexCollection: ", (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(0, "xmlrpc error while doing reindexCollection: ", (Throwable)e);
        }
    }

    public Occurrences[] getIndexedElements(boolean inclusive) throws XMLDBException {
        try {
            Vector<Object> params = new Vector<Object>();
            params.addElement(this.parent.getPath());
            params.addElement(inclusive);
            Vector result = (Vector)this.rpcClient.execute("getIndexedElements", params);
            Occurrences[] occurrences = new Occurrences[result.size()];
            for (int i = 0; i < occurrences.length; ++i) {
                Vector row = (Vector)result.elementAt(i);
                QName qname = new QName((String)row.elementAt(0), (String)row.elementAt(1), (String)row.elementAt(2));
                occurrences[i] = new Occurrences(qname);
                occurrences[i].addOccurrences((Integer)row.elementAt(3));
            }
            return occurrences;
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(0, "xmlrpc error while retrieving indexed elements", (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(0, "io error while retrieving indexed elements", (Throwable)e);
        }
    }

    public Occurrences[] scanIndexTerms(String start, String end, boolean inclusive) throws XMLDBException {
        try {
            Vector<Object> params = new Vector<Object>();
            params.addElement(this.parent.getPath());
            params.addElement(start);
            params.addElement(end);
            params.addElement(inclusive);
            Vector result = (Vector)this.rpcClient.execute("scanIndexTerms", params);
            Occurrences[] occurrences = new Occurrences[result.size()];
            for (int i = 0; i < occurrences.length; ++i) {
                Vector row = (Vector)result.elementAt(i);
                occurrences[i] = new Occurrences((Comparable)((Object)((String)row.elementAt(0))));
                occurrences[i].addOccurrences((Integer)row.elementAt(1));
            }
            return occurrences;
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(0, "xmlrpc error while retrieving indexed elements", (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(0, "io error while retrieving indexed elements", (Throwable)e);
        }
    }

    public Occurrences[] scanIndexTerms(String xpath, String start, String end) throws XMLDBException {
        try {
            Vector<String> params = new Vector<String>();
            params.addElement(xpath);
            params.addElement(start);
            params.addElement(end);
            Vector result = (Vector)this.rpcClient.execute("scanIndexTerms", params);
            Occurrences[] occurrences = new Occurrences[result.size()];
            for (int i = 0; i < occurrences.length; ++i) {
                Vector row = (Vector)result.elementAt(i);
                occurrences[i] = new Occurrences((Comparable)((Object)((String)row.elementAt(0))));
                occurrences[i].addOccurrences((Integer)row.elementAt(1));
            }
            return occurrences;
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(0, "xmlrpc error while retrieving indexed elements", (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(0, "io error while retrieving indexed elements", (Throwable)e);
        }
    }

    public String getName() throws XMLDBException {
        return "IndexQueryService";
    }

    public String getVersion() throws XMLDBException {
        return "1.0";
    }

    public void setCollection(Collection col) throws XMLDBException {
        this.parent = (RemoteCollection)col;
    }

    public String getProperty(String name) throws XMLDBException {
        return null;
    }

    public void setProperty(String name, String value) throws XMLDBException {
    }

    public void configureCollection(String configData) throws XMLDBException {
        String path = this.parent.getPath();
        Vector<String> params = new Vector<String>();
        params.addElement(path);
        params.addElement(configData);
        try {
            this.rpcClient.execute("configureCollection", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(0, "xmlrpc error while doing reindexCollection: ", (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(0, "xmlrpc error while doing reindexCollection: ", (Throwable)e);
        }
    }
}

