/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.exist.dom.DocumentSet;
import org.exist.dom.VirtualNodeSet;
import org.exist.security.xacml.XACMLSource;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Cardinality;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.Dependency;
import org.exist.xquery.EnclosedExpr;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.LetExpr;
import org.exist.xquery.LiteralValue;
import org.exist.xquery.LogicalOp;
import org.exist.xquery.Predicate;
import org.exist.xquery.Profiler;
import org.exist.xquery.Step;
import org.exist.xquery.TextConstructor;
import org.exist.xquery.Variable;
import org.exist.xquery.VariableReference;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.parser.XQueryAST;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;
import org.xmldb.api.base.CompiledExpression;

public class PathExpr
extends AbstractExpression
implements CompiledXQuery,
CompiledExpression {
    protected static final Logger LOG = Logger.getLogger((Class)PathExpr.class);
    protected boolean keepVirtual = false;
    protected List steps = new ArrayList();
    protected boolean inPredicate = false;
    protected XACMLSource source;
    protected Expression parent;

    public PathExpr(XQueryContext context) {
        super(context);
    }

    public void setSource(XACMLSource source) {
        this.source = source;
    }

    public XACMLSource getSource() {
        return this.source;
    }

    public void add(Expression s) {
        this.steps.add(s);
    }

    public void add(PathExpr path) {
        Iterator i = path.steps.iterator();
        while (i.hasNext()) {
            Expression expr = (Expression)i.next();
            this.add(expr);
        }
    }

    public void addPath(PathExpr path) {
        this.steps.add(path);
    }

    public void addPredicate(Predicate pred) {
        Expression e = (Expression)this.steps.get(this.steps.size() - 1);
        if (e instanceof Step) {
            ((Step)e).addPredicate(pred);
        }
    }

    public void replaceExpression(Expression oldExpr, Expression newExpr) {
        int idx = this.steps.indexOf(oldExpr);
        if (idx < 0) {
            LOG.warn((Object)("Expression not found: " + ExpressionDumper.dump(oldExpr) + "; in: " + ExpressionDumper.dump(this)));
            return;
        }
        this.steps.set(idx, newExpr);
    }

    public Expression getParent() {
        return this.parent;
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        this.parent = contextInfo.getParent();
        this.inPredicate = (contextInfo.getFlags() & 2) > 0;
        this.contextId = contextInfo.getContextId();
        for (int i = 0; i < this.steps.size(); ++i) {
            Expression expr = (Expression)this.steps.get(i);
            if ((contextInfo.getFlags() & 2) > 0 && i == 1) {
                contextInfo.setFlags(contextInfo.getFlags() & 0xFFFFFFFD);
                if ((contextInfo.getFlags() & 4) == 0) {
                    contextInfo.setContextId(-1);
                }
            }
            if (i > 1) {
                contextInfo.setContextStep((Expression)this.steps.get(i - 1));
            }
            contextInfo.setParent(this);
            expr.analyze(contextInfo);
        }
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        Sequence result = null;
        if (this.steps.size() == 0) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            Variable var;
            result = contextSequence;
            DocumentSet contextDocs = null;
            Expression expr = (Expression)this.steps.get(0);
            if (expr instanceof VariableReference && (var = ((VariableReference)expr).getVariable()) != null) {
                contextDocs = var.getContextDocs();
            }
            this.setContextDocSet(contextDocs);
            boolean gotAtomicResult = false;
            Iterator iter = this.steps.iterator();
            while (iter.hasNext()) {
                expr = (Expression)iter.next();
                if (gotAtomicResult && !Type.subTypeOf(expr.returnsType(), -1) && !(expr instanceof EnclosedExpr)) {
                    throw new XPathException("XPTY0019: left operand of '/' must be a node. Got '" + Type.getTypeName(result.getItemType()) + Cardinality.toString(result.getCardinality()) + "'");
                }
                expr.setContextDocSet(contextDocs);
                int exprDeps = expr.getDependencies();
                if (!(!Dependency.dependsOn(exprDeps, 2) && !Dependency.dependsOn(exprDeps, 16) || this.inPredicate && Type.subTypeOf(this.returnsType(), 30) || result == null || result.isEmpty())) {
                    Sequence exprResult = new ValueSequence();
                    int p = this.context.getContextPosition();
                    SequenceIterator iterInner = result.iterate();
                    while (iterInner.hasNext()) {
                        this.context.setContextPosition(p);
                        Item current = iterInner.nextItem();
                        if (!result.hasMany()) {
                            exprResult = expr.eval(result, current);
                        } else {
                            exprResult.addAll(expr.eval(result, current));
                        }
                        ++p;
                    }
                    result = exprResult;
                } else {
                    result = expr.eval(result);
                }
                if (!(this.steps.size() <= 1 || result instanceof VirtualNodeSet || result.isEmpty() || Type.subTypeOf(result.getItemType(), -1))) {
                    gotAtomicResult = true;
                }
                if (this.steps.size() <= 1) continue;
                result.removeDuplicates();
            }
            if (!(!gotAtomicResult || expr instanceof TextConstructor || expr instanceof VariableReference || expr instanceof LetExpr || expr instanceof EnclosedExpr || Type.subTypeOf(result.getItemType(), 20))) {
                throw new XPathException("XPTY0018: Cannot mix nodes and atomic values in the result of a path expression.");
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    public XQueryContext getContext() {
        return this.context;
    }

    public DocumentSet getDocumentSet() {
        return null;
    }

    public Expression getExpression(int pos) {
        return (Expression)this.steps.get(pos);
    }

    public Expression getLastExpression() {
        if (this.steps.size() == 0) {
            return null;
        }
        return (Expression)this.steps.get(this.steps.size() - 1);
    }

    public int getLength() {
        return this.steps.size();
    }

    public void accept(ExpressionVisitor visitor) {
        visitor.visitPathExpr(this);
    }

    public void dump(ExpressionDumper dumper) {
        Expression next = null;
        int count = 0;
        Iterator iter = this.steps.iterator();
        while (iter.hasNext()) {
            next = (Expression)iter.next();
            if (next instanceof LogicalOp) {
                dumper.display('(');
            }
            if (count > 0) {
                if (next instanceof Step) {
                    dumper.display("/");
                } else {
                    dumper.nl();
                }
            }
            next.dump(dumper);
            ++count;
        }
        if (next instanceof LogicalOp) {
            dumper.display(')');
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        Expression next = null;
        if (this.steps.size() == 0) {
            result.append("()");
        } else {
            int count = 0;
            Iterator iter = this.steps.iterator();
            while (iter.hasNext()) {
                next = (Expression)iter.next();
                if (next instanceof LogicalOp) {
                    result.append('(');
                }
                if (count > 0) {
                    if (next instanceof Step) {
                        result.append("/");
                    } else {
                        result.append(' ');
                    }
                }
                result.append(next.toString());
                ++count;
            }
            if (next instanceof LogicalOp) {
                result.append(')');
            }
        }
        return result.toString();
    }

    public int returnsType() {
        if (this.steps.size() == 0) {
            return -1;
        }
        return ((Expression)this.steps.get(this.steps.size() - 1)).returnsType();
    }

    public int getCardinality() {
        if (this.steps.size() == 0) {
            return 1;
        }
        return ((Expression)this.steps.get(this.steps.size() - 1)).getCardinality();
    }

    public int getDependencies() {
        int deps = 0;
        Iterator i = this.steps.iterator();
        while (i.hasNext()) {
            Expression next = (Expression)i.next();
            deps |= next.getDependencies();
        }
        return deps;
    }

    public void replaceLastExpression(Expression s) {
        if (this.steps.size() == 0) {
            return;
        }
        this.steps.set(this.steps.size() - 1, s);
    }

    public String getLiteralValue() {
        if (this.steps.size() == 0) {
            return "";
        }
        Expression next = (Expression)this.steps.get(0);
        if (next instanceof LiteralValue) {
            try {
                return ((LiteralValue)next).getValue().getStringValue();
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
        if (next instanceof PathExpr) {
            return ((PathExpr)next).getLiteralValue();
        }
        return "";
    }

    public XQueryAST getASTNode() {
        XQueryAST ast = super.getASTNode();
        if (ast == null && this.steps.size() == 1) {
            return ((Expression)this.steps.get(0)).getASTNode();
        }
        return ast;
    }

    public void setPrimaryAxis(int axis) {
        if (this.steps.size() > 0) {
            ((Expression)this.steps.get(0)).setPrimaryAxis(axis);
        }
    }

    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        for (int i = 0; i < this.steps.size(); ++i) {
            ((Expression)this.steps.get(i)).resetState(postOptimization);
        }
    }

    public void reset() {
        this.resetState(false);
    }

    public boolean isValid() {
        return this.context.checkModulesValid();
    }

    public void dump(Writer writer) {
        ExpressionDumper dumper = new ExpressionDumper(writer);
        this.dump(dumper);
    }

    public void setContext(XQueryContext context) {
        this.context = context;
    }
}

