/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.system;

import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class GetMemory
extends BasicFunction {
    public static final FunctionSignature getMemoryMax = new FunctionSignature(new QName("get-memory-max", "http://exist-db.org/xquery/system", "system"), "Returns the maximum amount of memory eXist may use.", FunctionSignature.NO_ARGS, new SequenceType(37, 2));
    public static final FunctionSignature getMemoryTotal = new FunctionSignature(new QName("get-memory-total", "http://exist-db.org/xquery/system", "system"), "Returns the total amount of memory in use by eXist.", FunctionSignature.NO_ARGS, new SequenceType(37, 2));
    public static final FunctionSignature getMemoryFree = new FunctionSignature(new QName("get-memory-free", "http://exist-db.org/xquery/system", "system"), "Returns the amount of free memory available to eXist.", FunctionSignature.NO_ARGS, new SequenceType(37, 2));

    public GetMemory(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Runtime rt = Runtime.getRuntime();
        long memory = 0L;
        if (this.isCalledAs("get-memory-max")) {
            memory = rt.maxMemory();
        } else if (this.isCalledAs("get-memory-total")) {
            memory = rt.totalMemory();
        } else if (this.isCalledAs("get-memory-free")) {
            memory = rt.freeMemory();
        }
        return new IntegerValue(memory, 37);
    }
}

