/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.math.BigDecimal;
import java.text.Collator;
import org.exist.util.FastStringBuffer;
import org.exist.util.FloatingPointConverter;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.DecimalValue;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.UntypedAtomicValue;

public class FloatValue
extends NumericValue {
    public static final FloatValue NaN = new FloatValue(Float.NaN);
    public static final FloatValue ZERO = new FloatValue(0.0f);
    protected float value;

    public FloatValue(float value) {
        this.value = value;
    }

    public FloatValue(String stringValue) throws XPathException {
        try {
            this.value = stringValue.equals("INF") ? Float.POSITIVE_INFINITY : (stringValue.equals("-INF") ? Float.NEGATIVE_INFINITY : (stringValue.equals("NaN") ? Float.NaN : Float.parseFloat(stringValue)));
        }
        catch (NumberFormatException e) {
            throw new XPathException("FORG0001: cannot construct " + Type.getTypeName(this.getItemType()) + " from \"" + this.getStringValue() + "\"");
        }
    }

    public float getValue() {
        return this.value;
    }

    public int getType() {
        return 33;
    }

    public String getStringValue() throws XPathException {
        FastStringBuffer sb = new FastStringBuffer(20);
        FloatingPointConverter.appendFloat(sb, this.value).getNormalizedString(0);
        return sb.toString();
    }

    public boolean isNaN() {
        return Float.isNaN(this.value);
    }

    public boolean isInfinite() {
        return Float.isInfinite(this.value);
    }

    public boolean isZero() {
        return Float.compare(this.value, 0.0f) == 0;
    }

    public boolean hasFractionalPart() {
        if (this.isNaN()) {
            return false;
        }
        if (this.isInfinite()) {
            return false;
        }
        return new DecimalValue(new BigDecimal(this.value)).hasFractionalPart();
    }

    public AtomicValue convertTo(int requiredType) throws XPathException {
        switch (requiredType) {
            case 11: 
            case 20: 
            case 30: 
            case 33: {
                return this;
            }
            case 34: {
                return new DoubleValue(this.value);
            }
            case 22: {
                return new StringValue(this.getStringValue());
            }
            case 32: {
                return new DecimalValue(this.value);
            }
            case 31: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                if (!Float.isInfinite(this.value) && !Float.isNaN(this.value)) {
                    return new IntegerValue((long)this.value, requiredType);
                }
                throw new XPathException("FOCA0002: cannot convert ' xs:float(\"" + this.getStringValue() + "\")' to " + Type.getTypeName(requiredType));
            }
            case 23: {
                return this.value == 0.0f || Float.isNaN(this.value) ? BooleanValue.FALSE : BooleanValue.TRUE;
            }
            case 21: {
                return new UntypedAtomicValue(this.getStringValue());
            }
        }
        throw new XPathException("FORG0001: cannot cast '" + Type.getTypeName(this.getItemType()) + "(\"" + this.getStringValue() + "\")' to " + Type.getTypeName(requiredType));
    }

    public NumericValue negate() throws XPathException {
        return new FloatValue(-this.value);
    }

    public NumericValue ceiling() throws XPathException {
        return new FloatValue((float)Math.ceil(this.value));
    }

    public NumericValue floor() throws XPathException {
        return new FloatValue((float)Math.floor(this.value));
    }

    public NumericValue round() throws XPathException {
        if (Float.isNaN(this.value)) {
            return this;
        }
        if (Float.isInfinite(this.value)) {
            return this;
        }
        if ((double)this.value == 0.0) {
            return this;
        }
        if ((double)this.value > -0.5 && (double)this.value < 0.0) {
            return new DoubleValue(-0.0);
        }
        if (this.value > -2.1474836E9f && this.value < 2.1474836E9f) {
            return new FloatValue(Math.round(this.value));
        }
        return this;
    }

    public NumericValue round(IntegerValue precision) throws XPathException {
        return (FloatValue)((DecimalValue)this.convertTo(32)).round(precision).convertTo(33);
    }

    public ComputableValue minus(ComputableValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 33)) {
            return new FloatValue(this.value - ((FloatValue)other).value);
        }
        return this.minus((ComputableValue)other.convertTo(this.getType()));
    }

    public ComputableValue plus(ComputableValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 33)) {
            return new FloatValue(this.value + ((FloatValue)other).value);
        }
        return this.plus((ComputableValue)other.convertTo(this.getType()));
    }

    public ComputableValue mult(ComputableValue other) throws XPathException {
        switch (other.getType()) {
            case 33: {
                return new FloatValue(this.value * ((FloatValue)other).value);
            }
            case 54: 
            case 55: {
                return other.mult(this);
            }
        }
        return this.mult((ComputableValue)other.convertTo(this.getType()));
    }

    public ComputableValue div(ComputableValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 30)) {
            if (this.isZero() && ((NumericValue)other).isZero()) {
                return NaN;
            }
            if (this.compareTo(ZERO) != 1 && ((NumericValue)other).isZero() && ((NumericValue)other).compareTo(ZERO) != -1) {
                return new FloatValue(Float.NEGATIVE_INFINITY);
            }
            if (((NumericValue)other).isZero() && ((NumericValue)other).compareTo(ZERO) != 1) {
                return new FloatValue(Float.NEGATIVE_INFINITY);
            }
            if (((NumericValue)other).isZero() && ((NumericValue)other).compareTo(ZERO) != -1) {
                return new FloatValue(Float.POSITIVE_INFINITY);
            }
            if (this.isInfinite() && ((NumericValue)other).isInfinite()) {
                return NaN;
            }
        }
        if (Type.subTypeOf(other.getType(), 33)) {
            return new FloatValue(this.value / ((FloatValue)other).value);
        }
        return this.div((ComputableValue)other.convertTo(this.getType()));
    }

    public IntegerValue idiv(NumericValue other) throws XPathException {
        ComputableValue result = this.div(other);
        return new IntegerValue(((IntegerValue)result.convertTo(31)).getLong());
    }

    public NumericValue mod(NumericValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 33)) {
            return new FloatValue(this.value % ((FloatValue)other).value);
        }
        return this.mod((NumericValue)other.convertTo(this.getType()));
    }

    public NumericValue abs() throws XPathException {
        return new FloatValue(Math.abs(this.value));
    }

    public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 33)) {
            return new FloatValue(Math.max(this.value, ((FloatValue)other).value));
        }
        return this.convertTo(other.getType()).max(collator, other);
    }

    public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 33)) {
            return new FloatValue(Math.min(this.value, ((FloatValue)other).value));
        }
        return this.convertTo(other.getType()).min(collator, other);
    }

    public int conversionPreference(Class javaClass) {
        if (javaClass.isAssignableFrom(FloatValue.class)) {
            return 0;
        }
        if (javaClass == Long.class || javaClass == Long.TYPE) {
            return 3;
        }
        if (javaClass == Integer.class || javaClass == Integer.TYPE) {
            return 4;
        }
        if (javaClass == Short.class || javaClass == Short.TYPE) {
            return 5;
        }
        if (javaClass == Byte.class || javaClass == Byte.TYPE) {
            return 6;
        }
        if (javaClass == Double.class || javaClass == Double.TYPE) {
            return 2;
        }
        if (javaClass == Float.class || javaClass == Float.TYPE) {
            return 1;
        }
        if (javaClass == String.class) {
            return 7;
        }
        if (javaClass == Boolean.class || javaClass == Boolean.TYPE) {
            return 8;
        }
        if (javaClass == Object.class) {
            return 20;
        }
        return Integer.MAX_VALUE;
    }

    public Object toJavaObject(Class target) throws XPathException {
        if (target.isAssignableFrom(FloatValue.class)) {
            return this;
        }
        if (target == Double.class || target == Double.TYPE) {
            return new Double(this.value);
        }
        if (target == Float.class || target == Float.TYPE) {
            return new Float(this.value);
        }
        if (target == Long.class || target == Long.TYPE) {
            return new Long(((IntegerValue)this.convertTo(37)).getValue());
        }
        if (target == Integer.class || target == Integer.TYPE) {
            IntegerValue v = (IntegerValue)this.convertTo(38);
            return new Integer((int)v.getValue());
        }
        if (target == Short.class || target == Short.TYPE) {
            IntegerValue v = (IntegerValue)this.convertTo(39);
            return new Short((short)v.getValue());
        }
        if (target == Byte.class || target == Byte.TYPE) {
            IntegerValue v = (IntegerValue)this.convertTo(40);
            return new Byte((byte)v.getValue());
        }
        if (target == String.class) {
            return this.getStringValue();
        }
        if (target == Boolean.class) {
            return this.effectiveBooleanValue();
        }
        throw new XPathException("cannot convert value of type " + Type.getTypeName(this.getType()) + " to Java object of type " + target.getName());
    }

    public int compareTo(Object o) {
        AtomicValue other = (AtomicValue)o;
        if (Type.subTypeOf(other.getType(), 33)) {
            return Float.compare(this.value, ((FloatValue)other).value);
        }
        return this.getType() < other.getType() ? -1 : 1;
    }
}

