/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.EmptyStackException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xmlrpc.ServerInputStream;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlWriter;

public class XmlRpcClientLite
extends XmlRpcClient {
    static String auth;

    public XmlRpcClientLite(URL url) {
        super(url);
    }

    public XmlRpcClientLite(String url) throws MalformedURLException {
        super(url);
    }

    public XmlRpcClientLite(String hostname, int port) throws MalformedURLException {
        super(hostname, port);
    }

    synchronized XmlRpcClient.Worker getWorker(boolean async) throws IOException {
        try {
            XmlRpcClient.Worker w = (XmlRpcClient.Worker)this.pool.pop();
            if (async) {
                ++this.asyncWorkers;
            } else {
                ++this.workers;
            }
            return w;
        }
        catch (EmptyStackException x) {
            if (this.workers < XmlRpc.getMaxThreads()) {
                if (async) {
                    ++this.asyncWorkers;
                } else {
                    ++this.workers;
                }
                return new LiteWorker();
            }
            throw new IOException("XML-RPC System overload");
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            String url = args[0];
            String method = args[1];
            XmlRpcClientLite client = new XmlRpcClientLite(url);
            Vector<Object> v = new Vector<Object>();
            for (int i = 2; i < args.length; ++i) {
                try {
                    v.addElement(new Integer(Integer.parseInt(args[i])));
                    continue;
                }
                catch (NumberFormatException nfx) {
                    v.addElement(args[i]);
                }
            }
            try {
                System.out.println(client.execute(method, v));
            }
            catch (Exception ex) {
                System.err.println("Error: " + ex.getMessage());
            }
        }
        catch (Exception x) {
            System.err.println(x);
            System.err.println("Usage: java org.apache.xmlrpc.XmlRpcClient <url> <method> <arg> ....");
            System.err.println("Arguments are sent as integers or strings.");
        }
    }

    class HttpClient {
        String hostname;
        String host;
        int port;
        String uri;
        Socket socket = null;
        BufferedOutputStream output;
        BufferedInputStream input;
        boolean keepalive;
        byte[] buffer;

        public HttpClient(URL url) throws IOException {
            this.hostname = url.getHost();
            this.port = url.getPort();
            if (this.port < 1) {
                this.port = 80;
            }
            this.uri = url.getFile();
            if (this.uri == null || "".equals(this.uri)) {
                this.uri = "/";
            }
            this.host = this.port == 80 ? this.hostname : this.hostname + ":" + this.port;
            this.initConnection();
        }

        protected void initConnection() throws IOException {
            this.socket = new Socket(this.hostname, this.port);
            this.output = new BufferedOutputStream(this.socket.getOutputStream());
            this.input = new BufferedInputStream(this.socket.getInputStream());
        }

        protected void closeConnection() {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public InputStream sendRequest(byte[] request) throws IOException {
            this.output.write(("POST " + this.uri + " HTTP/1.0\r\n").getBytes());
            this.output.write("User-Agent: Apache XML-RPC 1.2-a3-dev\r\n".getBytes());
            this.output.write(("Host: " + this.host + "\r\n").getBytes());
            if (XmlRpc.getKeepAlive()) {
                this.output.write("Connection: Keep-Alive\r\n".getBytes());
            }
            this.output.write("Content-Type: text/xml\r\n".getBytes());
            if (auth != null) {
                this.output.write(("Authorization: Basic " + auth + "\r\n").getBytes());
            }
            this.output.write(("Content-Length: " + request.length).getBytes());
            this.output.write("\r\n\r\n".getBytes());
            this.output.write(request);
            this.output.flush();
            String line = this.readLine();
            if (XmlRpc.debug) {
                System.out.println(line);
            }
            int contentLength = -1;
            try {
                StringTokenizer tokens = new StringTokenizer(line);
                String httpversion = tokens.nextToken();
                String statusCode = tokens.nextToken();
                String statusMsg = tokens.nextToken("\n\r");
                boolean bl = this.keepalive = XmlRpc.getKeepAlive() && "HTTP/1.1".equals(httpversion);
                if (!"200".equals(statusCode)) {
                    throw new IOException("Unexpected Response from Server: " + statusMsg);
                }
            }
            catch (IOException iox) {
                throw iox;
            }
            catch (Exception x) {
                throw new IOException("Server returned invalid Response.");
            }
            do {
                if ((line = this.readLine()) == null) continue;
                if (XmlRpc.debug) {
                    System.out.println(line);
                }
                if ((line = line.toLowerCase()).startsWith("content-length:")) {
                    contentLength = Integer.parseInt(line.substring(15).trim());
                }
                if (!line.startsWith("connection:")) continue;
                boolean bl = this.keepalive = XmlRpc.getKeepAlive() && line.indexOf("keep-alive") > -1;
            } while (line != null && !line.equals(""));
            return new ServerInputStream(this.input, contentLength);
        }

        private String readLine() throws IOException {
            int next;
            if (this.buffer == null) {
                this.buffer = new byte[2048];
            }
            int count = 0;
            while ((next = this.input.read()) >= 0 && next != 10) {
                if (next != 13) {
                    this.buffer[count++] = (byte)next;
                }
                if (count < this.buffer.length) continue;
                throw new IOException("HTTP Header too long");
            }
            return new String(this.buffer, 0, count);
        }

        protected void finalize() throws Throwable {
            this.closeConnection();
        }
    }

    class LiteWorker
    extends XmlRpcClient.Worker
    implements Runnable {
        HttpClient client = null;

        Object execute(String method, Vector params) throws XmlRpcException, IOException {
            long now = System.currentTimeMillis();
            this.fault = false;
            try {
                if (this.buffer == null) {
                    this.buffer = new ByteArrayOutputStream();
                } else {
                    this.buffer.reset();
                }
                XmlWriter writer = new XmlWriter((OutputStream)this.buffer, XmlRpc.encoding);
                this.writeRequest(writer, method, params);
                writer.flush();
                byte[] request = this.buffer.toByteArray();
                if (this.client == null) {
                    this.client = new HttpClient(XmlRpcClientLite.this.url);
                }
                InputStream in = null;
                try {
                    in = this.client.sendRequest(request);
                }
                catch (IOException iox) {
                    if (this.client.keepalive) {
                        this.client.closeConnection();
                        this.client.initConnection();
                        in = this.client.sendRequest(request);
                    }
                    throw iox;
                }
                this.parse(in);
                if (!this.client.keepalive) {
                    this.client.closeConnection();
                    this.client = null;
                }
                if (XmlRpc.debug) {
                    System.out.println("result = " + this.result);
                }
                if (this.errorLevel == 2) {
                    throw new Exception(this.errorMsg);
                }
            }
            catch (IOException iox) {
                throw iox;
            }
            catch (Exception x) {
                String msg;
                if (XmlRpc.debug) {
                    x.printStackTrace();
                }
                if ((msg = x.getMessage()) == null || msg.length() == 0) {
                    msg = x.toString();
                }
                throw new IOException(msg);
            }
            if (this.fault) {
                XmlRpcException exception = null;
                try {
                    Hashtable f = (Hashtable)this.result;
                    String faultString = (String)f.get("faultString");
                    int faultCode = Integer.parseInt(f.get("faultCode").toString());
                    exception = new XmlRpcException(faultCode, faultString.trim());
                }
                catch (Exception x) {
                    throw new XmlRpcException(0, "Server returned an invalid fault response.");
                }
                throw exception;
            }
            if (XmlRpc.debug) {
                System.out.println("Spent " + (System.currentTimeMillis() - now) + " millis in request");
            }
            return this.result;
        }
    }
}

