/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.bigram;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.apache.lucene.bigram.BigramStopFilter;
import org.apache.lucene.chunk.SpanChunkedNotQuery;
import org.apache.lucene.chunk.SpanDechunkingQuery;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryRewriter;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanNotNearQuery;
import org.apache.lucene.search.spans.SpanOrNearQuery;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;

public class BigramQueryRewriter
extends QueryRewriter {
    protected Set stopSet;
    protected int maxSlop;
    protected HashSet removedTerms = new HashSet();

    public BigramQueryRewriter(Set stopSet, int maxSlop) {
        this.stopSet = stopSet;
        this.maxSlop = maxSlop;
    }

    public static Set makeStopSet(String stopWords) {
        return BigramStopFilter.makeStopSet(stopWords);
    }

    public static boolean isBigram(Set stopWords, String str) {
        int pos = str.indexOf(126);
        if (pos < 0) {
            return false;
        }
        if (pos < 0 || pos >= str.length() - 1) {
            return false;
        }
        String before = str.substring(0, pos);
        String after = str.substring(pos + 1);
        return stopWords.contains(before) || stopWords.contains(after);
    }

    protected Query rewrite(BooleanQuery bq) {
        Vector<Query> required = new Vector<Query>();
        Vector<Query> prohibited = new Vector<Query>();
        Vector<Query> allowed = new Vector<Query>();
        BooleanClause[] clauses = bq.getClauses();
        boolean anyChange = false;
        int i = 0;
        while (i < clauses.length) {
            if (this.stopSet.contains(this.extractTermText(clauses[i].getQuery()))) {
                this.removedTerms.add(this.extractTermText(clauses[i].getQuery()));
                anyChange = true;
            } else {
                Query rewrittenQuery = this.rewriteQuery(clauses[i].getQuery());
                if (rewrittenQuery != clauses[i].getQuery()) {
                    anyChange = true;
                }
                if (rewrittenQuery != null) {
                    if (clauses[i].getOccur() == BooleanClause.Occur.MUST_NOT) {
                        prohibited.add(rewrittenQuery);
                    } else if (clauses[i].getOccur() == BooleanClause.Occur.MUST) {
                        required.add(rewrittenQuery);
                    } else {
                        allowed.add(rewrittenQuery);
                    }
                }
            }
            ++i;
        }
        if (!anyChange) {
            return bq;
        }
        if (required.isEmpty() && prohibited.isEmpty() && allowed.isEmpty()) {
            return null;
        }
        if (required.size() == 1 && prohibited.isEmpty() && allowed.isEmpty()) {
            return this.combineBoost(bq, (Query)required.elementAt(0));
        }
        bq = (BooleanQuery)this.copyBoost(bq, new BooleanQuery(bq.isCoordDisabled()));
        Iterator iter = required.iterator();
        while (iter.hasNext()) {
            bq.add((Query)iter.next(), BooleanClause.Occur.MUST);
        }
        iter = prohibited.iterator();
        while (iter.hasNext()) {
            bq.add((Query)iter.next(), BooleanClause.Occur.MUST_NOT);
        }
        iter = allowed.iterator();
        while (iter.hasNext()) {
            bq.add((Query)iter.next(), BooleanClause.Occur.SHOULD);
        }
        return bq;
    }

    protected Query rewrite(final SpanNearQuery q) {
        return this.rewriteClauses(q, q.getClauses(), true, true, q.getSlop(), new QueryRewriter.SpanClauseJoiner(){

            public SpanQuery join(SpanQuery[] clauses) {
                return new SpanNearQuery(clauses, q.getSlop(), false);
            }
        });
    }

    protected Query rewrite(final SpanOrNearQuery q) {
        return this.rewriteClauses(q, q.getClauses(), true, true, q.getSlop(), new QueryRewriter.SpanClauseJoiner(){

            public SpanQuery join(SpanQuery[] clauses) {
                return new SpanOrNearQuery(clauses, q.getSlop(), false);
            }
        });
    }

    protected Query rewrite(SpanOrQuery q) {
        return this.rewriteClauses(q, q.getClauses(), true, false, 0, new QueryRewriter.SpanClauseJoiner(){

            public SpanQuery join(SpanQuery[] clauses) {
                return new SpanOrQuery(clauses);
            }
        });
    }

    protected Query rewriteClauses(Query oldQuery, SpanQuery[] oldClauses, boolean shuntSingle, boolean bigram, int slop, QueryRewriter.SpanClauseJoiner joiner) {
        SpanQuery[] bigrammedClauses;
        Vector<SpanQuery> newClauseVec = new Vector<SpanQuery>();
        boolean anyChanges = false;
        int i = 0;
        while (i < oldClauses.length) {
            SpanQuery clause = (SpanQuery)this.rewriteQuery(oldClauses[i]);
            if (clause != oldClauses[i]) {
                anyChanges = true;
            }
            if (clause != null) {
                if (!bigram && this.stopSet.contains(this.extractTermText(clause))) {
                    this.removedTerms.add(this.extractTermText(clause));
                    anyChanges = true;
                } else {
                    newClauseVec.add(clause);
                }
            }
            ++i;
        }
        SpanQuery[] newClauses = newClauseVec.toArray(new SpanQuery[newClauseVec.size()]);
        boolean alreadyJoined = false;
        if (bigram && (bigrammedClauses = this.bigramQueries(newClauses, slop, joiner)) != newClauses) {
            assert (bigrammedClauses.length <= 1) : "bigramQueries should result in one clause if any bigramming performed";
            newClauses = bigrammedClauses;
            anyChanges = true;
            alreadyJoined = true;
        }
        boolean force = this.forceRewrite(oldQuery);
        if (!anyChanges && !force) {
            return oldQuery;
        }
        if (newClauses.length == 0) {
            return null;
        }
        if (newClauses.length == 1 && (alreadyJoined || shuntSingle && !force)) {
            return this.combineBoost(oldQuery, newClauses[0]);
        }
        SpanQuery newQuery = joiner.join(newClauses);
        return this.copyBoost(oldQuery, newQuery);
    }

    protected SpanQuery[] bigramQueries(SpanQuery[] clauses, int slop, QueryRewriter.SpanClauseJoiner joiner) {
        SpanQuery ret;
        assert (clauses.length > 0) : "cannot bigram empty list";
        String[] terms = new String[clauses.length];
        int i = 0;
        while (i < clauses.length) {
            terms[i] = this.extractTermText(clauses[i]);
            ++i;
        }
        if (clauses.length == 1 && !this.stopSet.contains(terms[0])) {
            return clauses;
        }
        int nStopWords = 0;
        int consecStopWords = 0;
        int maxConsecStopWords = 0;
        int i2 = 0;
        while (i2 < clauses.length) {
            if (!this.stopSet.contains(terms[i2])) {
                consecStopWords = 0;
            } else {
                this.removedTerms.add(terms[i2]);
                ++nStopWords;
                if (++consecStopWords > maxConsecStopWords) {
                    maxConsecStopWords = consecStopWords;
                }
            }
            ++i2;
        }
        if (nStopWords == 0) {
            return clauses;
        }
        if (nStopWords == clauses.length) {
            return new SpanQuery[0];
        }
        if (slop == 0) {
            ret = this.bigramTermsExact(clauses, terms, joiner);
        } else if (maxConsecStopWords <= 2) {
            ret = this.bigramTermsInexact(clauses, terms, joiner);
        } else {
            SpanQuery[] both = new SpanQuery[]{this.bigramTermsExact(clauses, terms, joiner), this.bigramTermsInexact(clauses, terms, joiner)};
            this.reduceBoost(both[1]);
            ret = new SpanOrQuery(both);
        }
        SpanQuery[] retArray = new SpanQuery[]{ret};
        return retArray;
    }

    protected SpanQuery bigramTermsInexact(Query[] queries, String[] terms, QueryRewriter.SpanClauseJoiner joiner) {
        SpanQuery[] clauses = new SpanQuery[terms.length * 2];
        int nClauses = 0;
        int i = 0;
        while (i < terms.length) {
            SpanQuery[] both;
            if (!this.stopSet.contains(terms[i])) {
                if (i <= 0 || !this.stopSet.contains(terms[i - 1])) {
                    if (i == terms.length - 1 || !this.stopSet.contains(terms[i + 1])) {
                        clauses[nClauses++] = this.convertToSpanQuery(queries[i]);
                    } else {
                        both = new SpanQuery[]{this.convertToSpanQuery(queries[i]), this.convertToSpanQuery(this.glomQueries(queries[i], queries[i + 1]))};
                        this.reduceBoost(both[0]);
                        clauses[nClauses++] = new SpanOrQuery(both);
                    }
                }
            } else if (i != terms.length - 1 && !this.stopSet.contains(terms[i + 1])) {
                both = new SpanQuery[]{this.convertToSpanQuery(this.glomQueries(queries[i], queries[i + 1])), this.convertToSpanQuery(queries[i + 1])};
                this.reduceBoost(both[1]);
                clauses[nClauses++] = new SpanOrQuery(both);
            }
            ++i;
        }
        if (nClauses == 1) {
            return clauses[0];
        }
        SpanQuery[] resized = new SpanQuery[nClauses];
        System.arraycopy(clauses, 0, resized, 0, nClauses);
        return joiner.join(resized);
    }

    protected SpanQuery convertToSpanQuery(Query q) {
        if (q instanceof SpanQuery) {
            return (SpanQuery)q;
        }
        if (q instanceof TermQuery) {
            Term t = ((TermQuery)q).getTerm();
            int termLength = BigramQueryRewriter.isBigram(this.stopSet, t.text()) ? 2 : 1;
            return (SpanQuery)this.copyBoost(q, new SpanTermQuery(t, termLength));
        }
        assert (false) : "case not handled";
        return null;
    }

    protected Term newTerm(String field, String text) {
        assert (!this.stopSet.contains(text)) : "cannot directly query a stop-word";
        return new Term(field, text);
    }

    protected SpanQuery bigramTermsExact(Query[] queries, String[] terms, QueryRewriter.SpanClauseJoiner joiner) {
        Vector<Query> newQueries = new Vector<Query>(queries.length * 2);
        int i = 0;
        while (i < terms.length) {
            if (!this.stopSet.contains(terms[i])) {
                if (i == terms.length - 1 || !this.stopSet.contains(terms[i + 1])) {
                    if (i <= 0 || !this.stopSet.contains(terms[i - 1])) {
                        newQueries.add(queries[i]);
                    }
                } else {
                    newQueries.add(this.glomQueries(queries[i], queries[i + 1]));
                }
            } else if (i != terms.length - 1) {
                newQueries.add(this.glomQueries(queries[i], queries[i + 1]));
            }
            ++i;
        }
        SpanQuery[] newArray = new SpanQuery[newQueries.size()];
        newQueries.toArray(newArray);
        return joiner.join(newArray);
    }

    protected Query glomQueries(Query q1, Query q2) {
        if (q1 instanceof SpanTermQuery && q2 instanceof SpanTermQuery) {
            SpanTermQuery st1 = (SpanTermQuery)q1;
            SpanTermQuery st2 = (SpanTermQuery)q2;
            Term t = this.newTerm(st1.getField(), String.valueOf(st1.getTerm().text()) + "~" + st2.getTerm().text());
            int termLength = BigramQueryRewriter.isBigram(this.stopSet, t.text()) ? 2 : 1;
            return this.copyBoost(st1, st2, new SpanTermQuery(t, termLength));
        }
        if (q1 instanceof TermQuery && q2 instanceof TermQuery) {
            TermQuery t1 = (TermQuery)q1;
            TermQuery t2 = (TermQuery)q2;
            Term t = this.newTerm(t1.getTerm().field(), String.valueOf(t1.getTerm().text()) + "~" + t2.getTerm().text());
            return this.copyBoost(t1, t2, new TermQuery(t));
        }
        if (q1 instanceof SpanTermQuery && q2 instanceof SpanOrQuery) {
            return this.glomInside((SpanOrQuery)q2, (SpanTermQuery)q1, true);
        }
        if (q1 instanceof SpanOrQuery && q2 instanceof SpanTermQuery) {
            return this.glomInside((SpanOrQuery)q1, (SpanTermQuery)q2, false);
        }
        if (q1 instanceof SpanTermQuery && q2 instanceof SpanChunkedNotQuery) {
            return this.glomInside((SpanChunkedNotQuery)q2, (SpanTermQuery)q1, true);
        }
        if (q1 instanceof SpanChunkedNotQuery && q2 instanceof SpanTermQuery) {
            return this.glomInside((SpanChunkedNotQuery)q1, (SpanTermQuery)q2, false);
        }
        if (q1 instanceof SpanTermQuery && q2 instanceof SpanNotNearQuery) {
            return this.glomInside((SpanNotNearQuery)q2, (SpanTermQuery)q1, true);
        }
        if (q1 instanceof SpanNotNearQuery && q2 instanceof SpanTermQuery) {
            return this.glomInside((SpanNotNearQuery)q1, (SpanTermQuery)q2, false);
        }
        if (q1 instanceof SpanTermQuery && q2 instanceof SpanNearQuery) {
            return q2;
        }
        if (q1 instanceof SpanNearQuery && q2 instanceof SpanTermQuery) {
            return q1;
        }
        assert (false) : "case not handled yet";
        return null;
    }

    protected SpanQuery glomInside(SpanOrQuery oq, SpanTermQuery term, boolean before) {
        SpanQuery[] clauses = oq.getClauses();
        boolean anyChanges = false;
        int i = 0;
        while (i < clauses.length) {
            if (clauses[i] instanceof SpanTermQuery) {
                String ctText = this.extractTermText(clauses[i]);
                String newText = before ? String.valueOf(this.extractTermText(term)) + "~" + ctText : String.valueOf(ctText) + "~" + this.extractTermText(term);
                SpanQuery oldClause = clauses[i];
                int termLength = BigramQueryRewriter.isBigram(this.stopSet, newText) ? 2 : 1;
                clauses[i] = new SpanTermQuery(this.newTerm(term.getTerm().field(), newText), termLength);
                this.copyBoost(oldClause, term, clauses[i]);
                anyChanges = true;
            } else if (clauses[i] instanceof SpanOrQuery) {
                SpanQuery newq = this.glomInside((SpanOrQuery)clauses[i], term, before);
                if (newq != oq) {
                    clauses[i] = newq;
                    anyChanges = true;
                }
            } else assert (false) : "case not handled";
            ++i;
        }
        if (!anyChanges) {
            return oq;
        }
        return (SpanQuery)this.copyBoost(oq, new SpanOrQuery(clauses));
    }

    protected SpanQuery glomInside(SpanChunkedNotQuery nq, SpanTermQuery term, boolean before) {
        SpanQuery newInclude = before ? (SpanQuery)this.glomQueries(term, nq.getInclude()) : (SpanQuery)this.glomQueries(nq.getInclude(), term);
        if (newInclude == nq.getInclude()) {
            return nq;
        }
        return (SpanQuery)this.copyBoost(nq, new SpanChunkedNotQuery(newInclude, nq.getExclude(), nq.getSlop()));
    }

    protected SpanQuery glomInside(SpanNotNearQuery nq, SpanTermQuery term, boolean before) {
        SpanQuery newInclude = before ? (SpanQuery)this.glomQueries(term, nq.getInclude()) : (SpanQuery)this.glomQueries(nq.getInclude(), term);
        if (newInclude == nq.getInclude()) {
            return nq;
        }
        return (SpanQuery)this.copyBoost(nq, new SpanNotNearQuery(newInclude, nq.getExclude(), nq.getSlop()));
    }

    protected String extractTermText(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        Term t = this.extractTerm(obj);
        if (t == null) {
            return "";
        }
        return t.text();
    }

    protected Term extractTerm(Object obj) {
        if (obj instanceof Term) {
            return (Term)obj;
        }
        if (obj instanceof TermQuery) {
            return ((TermQuery)obj).getTerm();
        }
        if (obj instanceof SpanTermQuery) {
            return ((SpanTermQuery)obj).getTerm();
        }
        if (obj instanceof SpanDechunkingQuery) {
            return this.extractTerm(((SpanDechunkingQuery)obj).getWrapped());
        }
        return null;
    }

    protected void reduceBoost(Query query) {
        query.setBoost(query.getBoost() * 0.8f);
    }
}

