/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.chunk;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.chunk.DocNumMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;

public class SpanDechunkingQuery
extends SpanQuery {
    private SpanQuery wrapped;
    private DocNumMap docNumMap;

    public SpanDechunkingQuery(SpanQuery wrap) {
        this.wrapped = wrap;
    }

    public void setDocNumMap(DocNumMap docNumMap) {
        this.docNumMap = docNumMap;
    }

    public SpanQuery getWrapped() {
        return this.wrapped;
    }

    public String getField() {
        return this.wrapped.getField();
    }

    public Collection getTerms() {
        return this.wrapped.getTerms();
    }

    public Query[] getSubQueries() {
        Query[] result = new Query[]{this.wrapped};
        return result;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        SpanQuery rewrittenWrapped = (SpanQuery)this.wrapped.rewrite(reader);
        if (rewrittenWrapped == this.wrapped) {
            return this;
        }
        SpanDechunkingQuery clone = (SpanDechunkingQuery)this.clone();
        clone.wrapped = rewrittenWrapped;
        return clone;
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("spanDechunk(");
        buffer.append(this.wrapped.toString(field));
        buffer.append(", spanRecording=");
        buffer.append(this.getSpanRecording());
        buffer.append(")");
        return buffer.toString();
    }

    public Spans getSpans(IndexReader reader, Searcher searcher) throws IOException {
        final int chunkSize = this.docNumMap.getChunkSize();
        final int chunkBump = chunkSize - this.docNumMap.getChunkOverlap();
        final Similarity similarity = this.wrapped.getSimilarity(searcher);
        return new Spans(reader, searcher){
            private Spans spans;
            private int firstChunk;
            private int lastChunk;
            private int mainDoc;
            private float lengthNorm;
            private int chunkOffset;
            {
                this.spans = SpanDechunkingQuery.this.wrapped.getSpans(indexReader, searcher);
                this.firstChunk = -1;
                this.lastChunk = -1;
                this.mainDoc = -1;
                this.lengthNorm = 0.0f;
            }

            public boolean next() throws IOException {
                if (!this.spans.next()) {
                    return false;
                }
                this.update();
                return true;
            }

            private void update() {
                int chunk = this.spans.doc();
                if (chunk > this.lastChunk) {
                    this.mainDoc = SpanDechunkingQuery.this.docNumMap.getDocNum(chunk);
                    if (this.mainDoc >= 0) {
                        this.firstChunk = SpanDechunkingQuery.this.docNumMap.getFirstChunk(this.mainDoc);
                        this.lastChunk = SpanDechunkingQuery.this.docNumMap.getLastChunk(this.mainDoc);
                        this.lengthNorm = similarity.lengthNorm(SpanDechunkingQuery.this.wrapped.getField(), this.lastChunk + 1 - this.firstChunk);
                    } else {
                        this.lengthNorm = 0.0f;
                        this.lastChunk = -1;
                        this.firstChunk = -1;
                    }
                }
                this.chunkOffset = (chunk - this.firstChunk) * chunkBump;
            }

            public boolean skipTo(int target) throws IOException {
                int first = SpanDechunkingQuery.this.docNumMap.getFirstChunk(target);
                if (first < 0 || target < first) {
                    first = target;
                }
                if (!this.spans.skipTo(first)) {
                    return false;
                }
                this.update();
                return true;
            }

            public int doc() {
                return this.mainDoc;
            }

            public int start() {
                int start = this.spans.start();
                if (!($assertionsDisabled || start >= 0 && start < chunkSize)) {
                    throw new AssertionError();
                }
                return start + this.chunkOffset;
            }

            public int end() {
                int end = this.spans.end();
                if (!($assertionsDisabled || end > 0 && end <= chunkSize)) {
                    throw new AssertionError();
                }
                return end + this.chunkOffset;
            }

            public float score() {
                return this.spans.score() * this.lengthNorm * SpanDechunkingQuery.this.getBoost();
            }

            public String toString() {
                return "spans(" + SpanDechunkingQuery.this.toString() + ")";
            }

            public Explanation explain() throws IOException {
                Explanation result = new Explanation(0.0f, "weight(" + this.toString() + "), product of:");
                Explanation boostExpl = new Explanation(SpanDechunkingQuery.this.getBoost(), "boost");
                if (boostExpl.getValue() != 1.0f) {
                    result.addDetail(boostExpl);
                }
                Explanation lengthExpl = new Explanation(this.lengthNorm, "lengthNorm");
                result.addDetail(lengthExpl);
                Explanation inclExpl = this.spans.explain();
                result.addDetail(inclExpl);
                result.setValue(boostExpl.getValue() * lengthExpl.getValue() * inclExpl.getValue());
                return result;
            }
        };
    }
}

