/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.saxonExt.exec;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.ExtensionInstruction;
import net.sf.saxon.trans.XPathException;
import org.cdlib.xtf.saxonExt.exec.ArgElement;
import org.cdlib.xtf.saxonExt.exec.InputElement;
import org.cdlib.xtf.saxonExt.exec.RunInstruction;

public class RunElement
extends ExtensionInstruction {
    protected Expression command;
    protected int timeoutMsec;

    public void prepareAttributes() throws XPathException {
        this.command = this.makeAttributeValueTemplate(this.getAttributeList().getValue("", "command"));
        if (this.command == null) {
            this.reportAbsence("command");
            return;
        }
        String timeoutStr = this.getAttributeList().getValue("", "timeout");
        if (timeoutStr == null) {
            this.timeoutMsec = 0;
        } else {
            try {
                this.timeoutMsec = (int)(Float.parseFloat(timeoutStr) * 1000.0f);
                this.timeoutMsec = Math.max(0, this.timeoutMsec);
            }
            catch (NumberFormatException e) {
                this.compileError("'timeout' must be a number");
            }
        }
    }

    public Expression compile(Executable exec) throws XPathException {
        return new RunInstruction(this.command, this.timeoutMsec, this.getArgInstructions(exec));
    }

    public List getArgInstructions(Executable exec) throws XPathException {
        NodeInfo child;
        ArrayList<Expression> list = new ArrayList<Expression>(10);
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)kids.next()) != null) {
            if (child instanceof ArgElement) {
                list.add(((ArgElement)child).compile(exec));
            }
            if (!(child instanceof InputElement)) continue;
            list.add(((InputElement)child).compile(exec));
        }
        return list;
    }
}

