/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine.facet;

import org.cdlib.xtf.textEngine.facet.GroupCounts;
import org.cdlib.xtf.textEngine.facet.GroupSelector;

public class UnionSelector
extends GroupSelector {
    GroupSelector[] selectors;

    public UnionSelector(GroupSelector[] selectors) {
        this.selectors = selectors;
    }

    public void setCounts(GroupCounts counts) {
        super.setCounts(counts);
        int i = 0;
        while (i < this.selectors.length) {
            this.selectors[i].setCounts(counts);
            ++i;
        }
    }

    public void reset(boolean conservative) {
        super.reset(conservative);
        int i = 0;
        while (i < this.selectors.length) {
            this.selectors[i].reset(conservative);
            ++i;
        }
    }

    public void process(int group) {
        assert (group == 0) : "UnionSelector should only be top-level";
        int i = 0;
        while (i < this.selectors.length) {
            this.selectors[i].process(group);
            this.selectors[i].flush();
            ++i;
        }
    }

    public void flush() {
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("union(");
        int i = 0;
        while (i < this.selectors.length) {
            buf.append(this.selectors[i].toString());
            if (i < this.selectors.length - 1) {
                buf.append("|");
            }
            ++i;
        }
        buf.append(")");
        return buf.toString();
    }
}

