/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import java.io.StringWriter;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.om.NodeInfo;
import org.cdlib.xtf.util.EasyNode;
import org.cdlib.xtf.util.Trace;
import org.cdlib.xtf.util.XTFSaxonErrorListener;

public class XMLWriter {
    public static void debug(EasyNode node) {
        Trace.debug(XMLWriter.toString(node, true));
    }

    public static void debug(EasyNode node, boolean includeXMLDecl) {
        Trace.debug(XMLWriter.toString(node, includeXMLDecl));
    }

    public static void debug(Source node) {
        Trace.debug(XMLWriter.toString(node, true));
    }

    public static void debug(Source node, boolean includeXMLDecl) {
        Trace.debug(XMLWriter.toString(node, includeXMLDecl));
    }

    public static String toString(EasyNode node) {
        return XMLWriter.toString(node.getWrappedNode(), true);
    }

    public static String toString(EasyNode node, boolean includeXMLDecl) {
        return XMLWriter.toString(node.getWrappedNode(), includeXMLDecl);
    }

    public static String toString(Source node) {
        return XMLWriter.toString(node, true);
    }

    public static String toString(Source node, boolean includeXMLDecl) {
        try {
            StringWriter writer = new StringWriter();
            StreamResult tmp = new StreamResult(writer);
            TransformerFactoryImpl factory = new TransformerFactoryImpl();
            if (node instanceof NodeInfo) {
                ((TransformerFactory)factory).setAttribute("http://saxon.sf.net/feature/namePool", ((NodeInfo)node).getNamePool());
            }
            Transformer trans = ((TransformerFactory)factory).newTransformer();
            Properties props = trans.getOutputProperties();
            props.put("indent", "yes");
            props.put("method", "xml");
            if (!includeXMLDecl) {
                props.put("omit-xml-declaration", "yes");
            }
            trans.setOutputProperties(props);
            if (!(trans.getErrorListener() instanceof XTFSaxonErrorListener)) {
                trans.setErrorListener(new XTFSaxonErrorListener());
            }
            trans.transform(node, tmp);
            return writer.toString();
        }
        catch (Exception e) {
            return "Error writing XML: " + e;
        }
    }
}

