/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.dtdparser.node;

import com.japisoft.dtdparser.node.AttributeDTDNode;
import com.japisoft.dtdparser.node.DTDNode;
import com.japisoft.dtdparser.node.DocumentWritable;
import com.japisoft.dtdparser.node.ElementSetDTDNode;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class ElementDTDNode
extends DTDNode
implements DocumentWritable {
    private Hashtable htAttribute;
    private String name;
    private String attComment = null;
    private boolean empty = false;
    private int op = 0;
    private boolean pcdata = false;
    private boolean any = false;

    public ElementDTDNode() {
        this.setNodeType(2);
    }

    public ElementDTDNode(String string) {
        this();
        this.setName(string);
    }

    public void addAttComment(String string) {
        this.attComment = this.attComment == null ? string : this.attComment + "\n" + string;
    }

    public void addDTDNode(DTDNode dTDNode) {
        if (dTDNode.isAttribute()) {
            if (this.htAttribute == null) {
                this.htAttribute = new Hashtable();
            }
            AttributeDTDNode attributeDTDNode = (AttributeDTDNode)dTDNode;
            if (this.attComment != null) {
                attributeDTDNode.addNodeComment(this.attComment);
            }
            if (attributeDTDNode.getName() != null) {
                this.htAttribute.put(attributeDTDNode.getName(), attributeDTDNode);
            }
        }
        super.addDTDNode(dTDNode);
    }

    public AttributeDTDNode getAttributeDeclaration(String string) {
        if (this.htAttribute == null) {
            return null;
        }
        return (AttributeDTDNode)this.htAttribute.get(string);
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setEmptyElement(boolean bl) {
        this.empty = bl;
    }

    public boolean isEmptyElement() {
        return this.empty;
    }

    public void setOperator(int n) {
        this.op = n;
    }

    public String getOperatorString() {
        switch (this.op) {
            case 2: {
                return "*";
            }
            case 3: {
                return "+";
            }
            case 1: {
                return "?";
            }
        }
        return "";
    }

    public int getOperator() {
        return this.op;
    }

    public void setPCDATA(boolean bl) {
        this.pcdata = bl;
    }

    public boolean hasPCDATA() {
        return this.pcdata;
    }

    public void setANY(boolean bl) {
        this.any = bl;
    }

    public boolean hasANY() {
        return this.any;
    }

    public boolean isNodeChildSupported(String string, String string2, int n) {
        if (this.isEmptyElement()) {
            return false;
        }
        if (this.hasANY()) {
            return true;
        }
        if (this.hasPCDATA()) {
            return false;
        }
        for (int i = 0; i < this.getDTDNodeCount(); ++i) {
            if (!(this.getDTDNodeAt(i) instanceof ElementSetDTDNode)) continue;
            ElementSetDTDNode elementSetDTDNode = (ElementSetDTDNode)this.getDTDNodeAt(i);
            return elementSetDTDNode.isNodeChildSupported(string, string2, n);
        }
        return false;
    }

    public void writeDocument(PrintWriter printWriter) throws IOException {
        DTDNode dTDNode;
        printWriter.write("<" + this.getName());
        Enumeration enumeration = this.getDTDNodeForType(3);
        while (enumeration.hasMoreElements()) {
            dTDNode = (AttributeDTDNode)enumeration.nextElement();
            if (((AttributeDTDNode)dTDNode).getUsage() != 0) continue;
            printWriter.write(" ");
            printWriter.write(((AttributeDTDNode)dTDNode).getName());
            printWriter.write("=\"");
            printWriter.write(((AttributeDTDNode)dTDNode).getDefaultValue());
            printWriter.write("\"");
        }
        if (this.isEmptyElement()) {
            printWriter.write("/>\n");
        } else {
            printWriter.write(">\n");
            enumeration = this.getDTDNodeForType(5);
            if (enumeration.hasMoreElements()) {
                dTDNode = (ElementSetDTDNode)enumeration.nextElement();
                ((ElementSetDTDNode)dTDNode).writeDocument(printWriter);
            }
            printWriter.write("</" + this.getName() + ">\n");
        }
    }

    public String toString() {
        Enumeration enumeration;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getDTDComment());
        stringBuffer.append("<!ELEMENT ").append(this.getName()).append(" ");
        if (this.isEmptyElement()) {
            stringBuffer.append("EMPTY>");
        } else if (this.hasANY()) {
            stringBuffer.append("ANY>");
        } else if (this.hasPCDATA()) {
            stringBuffer.append("(#PCDATA)>");
        } else {
            enumeration = this.getDTDNodeForType(5);
            if (enumeration.hasMoreElements()) {
                stringBuffer.append("" + enumeration.nextElement());
            }
            stringBuffer.append(">");
        }
        enumeration = this.getDTDNodeForType(3);
        if (enumeration.hasMoreElements()) {
            stringBuffer.append("\n");
            stringBuffer.append(this.getDTDComment(this.attComment));
            stringBuffer.append("<!ATTLIST " + this.getName());
            stringBuffer.append(" \n");
            while (enumeration.hasMoreElements()) {
                AttributeDTDNode attributeDTDNode = (AttributeDTDNode)enumeration.nextElement();
                stringBuffer.append(attributeDTDNode.toString());
                stringBuffer.append("\n");
            }
            stringBuffer.append(">");
        }
        return stringBuffer.toString();
    }
}

