/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix;

import com.japisoft.editix.EditixDTDMapper;
import com.japisoft.editix.action.xml.XMLCatalogAction;
import com.japisoft.xmlpad.DTDMapperUsage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.xml.sax.InputSource;

public class EditixEntityResolver
extends CatalogResolver {
    CatalogManager manager;
    static EditixEntityResolver RESOLVER = null;

    public EditixEntityResolver(CatalogManager catalogManager) {
        super(catalogManager);
        this.manager = catalogManager;
        this.loadCatalogs();
    }

    public static EditixEntityResolver getInstance() {
        if (RESOLVER == null) {
            System.setProperty("xml.catalog.ignoreMissing", "true");
            CatalogManager catalogManager = new CatalogManager();
            RESOLVER = new EditixEntityResolver(catalogManager);
        }
        return RESOLVER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCatalogs() {
        File file = XMLCatalogAction.getCatalogLstPath();
        if (file.exists()) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                try {
                    String string = null;
                    StringBuffer stringBuffer = new StringBuffer();
                    while ((string = bufferedReader.readLine()) != null) {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(";");
                        }
                        stringBuffer.append(string);
                    }
                    this.manager.setCatalogFiles(stringBuffer.toString());
                    this.manager.setUseStaticCatalog(true);
                    System.setProperty("xml.catalog.files", stringBuffer.toString());
                    this.manager.getCatalog().loadSystemCatalogs();
                }
                finally {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Catalog getCatalog() {
        Catalog catalog = super.getCatalog();
        File file = XMLCatalogAction.getCatalogLstPath();
        if (file.exists()) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                try {
                    String string = null;
                    while ((string = bufferedReader.readLine()) != null) {
                        if (string.contains("://")) {
                            try {
                                catalog.parseCatalog(new URL(string));
                            }
                            catch (Exception exception) {
                                System.out.println("Can't load " + string + " => " + exception.getMessage());
                            }
                            continue;
                        }
                        catalog.parseCatalog(string);
                    }
                }
                finally {
                    bufferedReader.close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return catalog;
    }

    public String resolveCatalog(String string, String string2) throws IOException {
        if (this.manager == null) {
            return null;
        }
        if (string == null) {
            string = "";
        }
        return this.manager.getCatalog().resolvePublic(string, string2);
    }

    public InputSource resolveEntity(String string, String string2) {
        InputSource inputSource = super.resolveEntity(string, string2);
        String string3 = null;
        try {
            string3 = string != null ? this.manager.getCatalog().resolvePublic(string, string2) : this.manager.getCatalog().resolveSystem(string2);
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (string3 != null) {
            try {
                string2 = URLDecoder.decode(string3, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string2 = string3;
            }
        }
        try {
            InputStream inputStream = EditixDTDMapper.getInstance().getStream(string2);
            if (inputStream != null) {
                return new CustomInputSource(string2, inputStream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return inputSource;
    }

    public Source resolve(String string, String string2) throws TransformerException {
        Source source = super.resolve(string, string2);
        if (source != null) {
            return source;
        }
        try {
            InputStream inputStream;
            if (string != null && (inputStream = EditixDTDMapper.getInstance().getStream(string)) != null) {
                return new SAXSource(new InputSource(inputStream));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return source;
    }

    class CustomInputSource
    extends InputSource
    implements DTDMapperUsage {
        public CustomInputSource(String string, InputStream inputStream) {
            super(inputStream);
            if (string != null) {
                this.setSystemId(string);
            }
        }
    }
}

