/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.file;

import com.japisoft.editix.action.file.NextSelectionAction;
import com.japisoft.editix.ui.EditixContainerListener;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.editix.ui.PanelStateListener;
import com.japisoft.editix.ui.PanelStateManager;
import com.japisoft.framework.application.descriptor.ActionModel;
import com.japisoft.framework.preferences.Preferences;
import com.japisoft.xmlpad.XMLContainer;
import java.awt.event.ActionEvent;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class PreviousSelectionAction
extends AbstractAction
implements PanelStateListener,
EditixContainerListener {
    static Stack STACK_PREVIOUS = null;
    private static Action ref;

    public PreviousSelectionAction() {
        ref = this;
        PanelStateManager.addPanelStateListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        StackItem stackItem;
        XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedContainer();
        StackItem stackItem2 = stackItem = (StackItem)STACK_PREVIOUS.pop();
        if (xMLContainer != null && xMLContainer.getCurrentDocumentLocation() != null && xMLContainer.getCurrentDocumentLocation().equals(stackItem.path)) {
            stackItem = (StackItem)STACK_PREVIOUS.pop();
        }
        if (!PreviousSelectionAction.selectOrOpen(stackItem)) {
            NextSelectionAction.addNextPath(stackItem2);
        }
        PreviousSelectionAction.resetToolTip(STACK_PREVIOUS, this);
    }

    static boolean selectOrOpen(StackItem stackItem) {
        if (!EditixFrame.ACCESSOR.activeXMLContainer(stackItem.path)) {
            ActionModel.activeActionById("open", null, stackItem.path, stackItem.type, stackItem.encoding);
            return true;
        }
        return false;
    }

    public void newPath(String string, String string2) {
        if (STACK_PREVIOUS != null) {
            for (int i = 0; i < STACK_PREVIOUS.size(); ++i) {
                StackItem stackItem = (StackItem)STACK_PREVIOUS.get(i);
                if (!stackItem.path.equals(string)) continue;
                stackItem.path = string2;
            }
        }
    }

    static void resetToolTip(Stack stack, Action action) {
        StackItem stackItem = null;
        int n = 0;
        if (!stack.isEmpty()) {
            stackItem = (StackItem)stack.peek();
            if (EditixFrame.ACCESSOR.getSelectedContainer() != null && stackItem.path.equals(EditixFrame.ACCESSOR.getSelectedContainer().getCurrentDocumentLocation())) {
                n = 1;
            }
        }
        StringBuffer stringBuffer = new StringBuffer("<html><body><b>");
        stringBuffer.append(stack.size() - n).append(" File").append(stack.size() - n > 1 ? "s" : "").append("</b><br>");
        for (int i = stack.size() - 1 - n; i >= 0; --i) {
            StackItem stackItem2 = (StackItem)stack.get(i);
            stringBuffer.append(stackItem2.path).append("<br>");
        }
        stringBuffer.append("</body></html>");
        action.putValue("ShortDescription", stringBuffer.toString());
    }

    public void setCurrentXMLContainer(XMLContainer xMLContainer) {
        if (xMLContainer != null) {
            if (xMLContainer.getCurrentDocumentLocation() != null) {
                PreviousSelectionAction.addPreviousPath(xMLContainer.getCurrentDocumentLocation(), xMLContainer.getDocumentInfo().getType(), xMLContainer.getDocumentInfo().getEncoding(), xMLContainer.hasProperty("save.delegate"));
            }
        } else if (!ref.isEnabled() && STACK_PREVIOUS != null && STACK_PREVIOUS.size() > 0) {
            ref.setEnabled(true);
        }
    }

    public void close(XMLContainer xMLContainer) {
        if (xMLContainer.hasProperty("save.delegate")) {
            StackItem stackItem = new StackItem();
            stackItem.path = xMLContainer.getCurrentDocumentLocation();
            if (STACK_PREVIOUS != null) {
                STACK_PREVIOUS.remove(stackItem);
                ref.setEnabled(STACK_PREVIOUS.size() > 1);
                PreviousSelectionAction.resetToolTip(STACK_PREVIOUS, ref);
            }
            if (NextSelectionAction.STACK_NEXT != null) {
                NextSelectionAction.STACK_NEXT.remove(stackItem);
                NextSelectionAction.ref.setEnabled(STACK_PREVIOUS.size() > 1);
                PreviousSelectionAction.resetToolTip(NextSelectionAction.STACK_NEXT, NextSelectionAction.ref);
            }
        }
    }

    static void checkForSize(Stack stack) {
        if (stack.size() > Preferences.getPreference("interface", "fileHistoryStack", 10)) {
            stack.remove(0);
        }
    }

    static void addPreviousPath(String string, String string2, String string3, boolean bl) {
        if (STACK_PREVIOUS == null) {
            STACK_PREVIOUS = new Stack();
        }
        StackItem stackItem = new StackItem();
        stackItem.path = string;
        stackItem.type = string2;
        stackItem.encoding = string3;
        stackItem.special = bl;
        STACK_PREVIOUS.remove(stackItem);
        STACK_PREVIOUS.push(stackItem);
        ref.setEnabled(STACK_PREVIOUS.size() > 1);
        PreviousSelectionAction.resetToolTip(STACK_PREVIOUS, ref);
        PreviousSelectionAction.checkForSize(STACK_PREVIOUS);
    }

    static class StackItem {
        public String path;
        public String type;
        public String encoding;
        public boolean special;

        StackItem() {
        }

        public boolean equals(Object object) {
            if (object instanceof StackItem) {
                StackItem stackItem = (StackItem)object;
                return stackItem.path.equals(this.path);
            }
            return super.equals(object);
        }
    }
}

