/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.db;

import com.japisoft.editix.EditixApplicationModel;
import com.japisoft.editix.db.Driver;
import com.japisoft.editix.db.xmldb.XmlDbDriver;
import com.japisoft.fastparser.Parser;
import com.japisoft.fastparser.document.Document;
import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.framework.ApplicationModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class DriverDbManager {
    private static ArrayList drivers = null;
    private static boolean isInstalled = false;

    public static int getDriverCount() {
        DriverDbManager.install();
        if (drivers == null) {
            return 0;
        }
        return drivers.size();
    }

    public static Driver getDriver(int n) {
        if (drivers == null) {
            return null;
        }
        return (Driver)drivers.get(n);
    }

    public static void removeDriver(Driver driver) {
        if (drivers != null) {
            drivers.remove(driver);
        }
    }

    public static void addDriver(Driver driver) {
        if (drivers != null) {
            drivers.add(driver);
        }
    }

    public static Driver getDriverByName(String string) {
        DriverDbManager.install();
        for (int i = 0; i < DriverDbManager.getDriverCount(); ++i) {
            if (!DriverDbManager.getDriver(i).toString().equalsIgnoreCase(string)) continue;
            return DriverDbManager.getDriver(i);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save() {
        File file = new File(EditixApplicationModel.getAppUserPath(), "dbdrivers.xml");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<drivers>");
        for (int i = 0; i < DriverDbManager.getDriverCount(); ++i) {
            stringBuffer.append(DriverDbManager.getDriver(i).toXml());
        }
        stringBuffer.append("</drivers>");
        try {
            FileWriter fileWriter = new FileWriter(file);
            try {
                fileWriter.write(stringBuffer.toString());
            }
            finally {
                fileWriter.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void install() {
        if (isInstalled) {
            return;
        }
        isInstalled = true;
        try {
            InputStream inputStream = null;
            File file = new File(EditixApplicationModel.getAppUserPath(), "dbdrivers.xml");
            if (!file.exists()) {
                inputStream = ClassLoader.getSystemClassLoader().getResourceAsStream("dbdrivers/drivers.xml");
                if (inputStream == null) {
                    inputStream = ClassLoader.getSystemClassLoader().getResourceAsStream("drivers.xml");
                }
            } else {
                inputStream = new FileInputStream(file);
            }
            if (inputStream == null) {
                System.out.println("Can't find drivers.xml");
                return;
            }
            Parser parser = new Parser();
            parser.setInputStream(inputStream);
            parser.parse();
            Document document = parser.getDocument();
            SimpleNode simpleNode = (SimpleNode)document.getRoot();
            for (int i = 0; i < simpleNode.childCount(); ++i) {
                SimpleNode simpleNode2 = simpleNode.childAt(i);
                if (!simpleNode2.matchContent("driver")) continue;
                Driver driver = null;
                String string = simpleNode2.getAttribute("class");
                if (string != null) {
                    try {
                        ApplicationModel.debug("Loading " + string);
                        driver = "com.japisoft.editix.db.xmldb.XmlDbDriver".equals(string) ? new XmlDbDriver(simpleNode2) : (Driver)Class.forName(string).getConstructors()[0].newInstance(simpleNode2);
                        if (drivers == null) {
                            drivers = new ArrayList();
                        }
                        drivers.add(driver);
                    }
                    catch (Exception exception) {
                        ApplicationModel.debug(exception);
                    }
                    continue;
                }
                System.out.println("Can't find driver class ???");
            }
        }
        catch (Exception exception) {
            ApplicationModel.debug(exception);
        }
    }
}

