/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.db.ui;

import com.japisoft.editix.db.ContainerNodeDb;
import com.japisoft.editix.db.FileNodeDb;
import com.japisoft.editix.db.RootNodeDb;
import com.japisoft.editix.document.DocumentModel;
import com.japisoft.framework.app.toolkit.Toolkit;
import com.japisoft.framework.ui.FastLabel;
import com.japisoft.xmlpad.XMLDocumentInfo;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class DbBrowserTreeRenderer
implements TreeCellRenderer {
    Icon connection = null;
    Icon collection = null;
    FastLabel label = new FastLabel();

    public DbBrowserTreeRenderer() {
        this.connection = Toolkit.getImageIcon("images/data.png");
        this.collection = Toolkit.getImageIcon("images/data_table.png");
        this.label.setOpaque(true);
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (object instanceof DefaultMutableTreeNode) {
            this.label.setText(object.toString());
            this.label.setIcon(this.connection);
        } else if (object instanceof RootNodeDb) {
            this.label.setText(object.toString());
            this.label.setIcon(this.connection);
        } else if (object instanceof ContainerNodeDb) {
            this.label.setText(object.toString());
            this.label.setIcon(this.collection);
        } else if (object instanceof FileNodeDb) {
            String string = object.toString();
            this.label.setText(string);
            XMLDocumentInfo xMLDocumentInfo = DocumentModel.getDocumentByFileName(string);
            if (xMLDocumentInfo == null) {
                this.label.setIcon(null);
            } else {
                this.label.setIcon(xMLDocumentInfo.getDocumentIcon());
            }
        }
        if (bl) {
            this.label.setForeground(UIManager.getColor("List.selectionForeground"));
            this.label.setBackground(UIManager.getColor("List.selectionBackground"));
        } else {
            this.label.setForeground(jTree.getForeground());
            this.label.setBackground(jTree.getBackground());
        }
        return this.label;
    }
}

