/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.db.ui;

import com.japisoft.editix.EditixApplicationModel;
import com.japisoft.editix.db.NodeDb;
import com.japisoft.editix.db.RootNodeDb;
import com.japisoft.editix.db.ui.DbBrowser;
import com.japisoft.editix.db.ui.DbRequestResultPanel;
import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xquery.XQueryEditor;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jdesktop.layout.GroupLayout;

public class DbRequestPanel
extends JPanel
implements ActionListener {
    private DbBrowser browser;
    private JButton btRun;
    private JButton btRunCurrentDoc;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JPanel pnlXPath;
    private DbRequestResultPanel spResult;
    private JTabbedPane tp;
    private XQueryEditor txtRequest;

    public DbRequestPanel(DbBrowser dbBrowser) {
        this.initComponents();
        this.browser = dbBrowser;
        this.txtRequest.setDisplayRowHeader(false);
        this.btRun.setToolTipText("Run an XPath request on the current database connection");
        this.btRunCurrentDoc.setToolTipText("Run an XPath request using the edited one (from the main editor)");
    }

    public void addNotify() {
        super.addNotify();
        this.btRun.addActionListener(this);
        this.btRunCurrentDoc.addActionListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.btRun.removeActionListener(this);
        this.btRunCurrentDoc.removeActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btRun) {
            this.runRequest(this.txtRequest.getText());
        } else {
            XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedContainer();
            if (xMLContainer == null) {
                EditixFactory.buildAndShowWarningDialog("You must open an XQuery document");
            } else {
                String string = xMLContainer.getDocumentInfo().getType();
                if (!"XQR".equals(string)) {
                    EditixFactory.buildAndShowWarningDialog("The current document is not an xquery document");
                } else {
                    this.runRequest(xMLContainer.getText());
                }
            }
        }
    }

    private void runRequest(String string) {
        RootNodeDb rootNodeDb = this.browser.getCurrentConnection();
        if (rootNodeDb == null) {
            EditixFactory.buildAndShowWarningDialog("Please select a database");
        } else {
            try {
                DefaultMutableTreeNode defaultMutableTreeNode = this.spResult.getRoot();
                defaultMutableTreeNode.removeAllChildren();
                NodeDb[] nodeDbArray = rootNodeDb.request(string);
                if (nodeDbArray != null) {
                    TreeNode treeNode = null;
                    for (int i = 0; i < nodeDbArray.length; ++i) {
                        if (nodeDbArray[i].getParent() == null) {
                            defaultMutableTreeNode.add(nodeDbArray[i]);
                        } else if (nodeDbArray[i].getParent() != treeNode) {
                            defaultMutableTreeNode.add((MutableTreeNode)nodeDbArray[i].getParent());
                        }
                        treeNode = nodeDbArray[i].getParent();
                    }
                }
                this.spResult.refreshRoot();
                if (nodeDbArray != null && nodeDbArray.length > 0) {
                    this.tp.setSelectedIndex(1);
                }
            }
            catch (Exception exception) {
                EditixApplicationModel.debug(exception);
                EditixFactory.buildAndShowErrorDialog("Can't execute : " + exception.getMessage());
            }
        }
    }

    public void setEnabledRequest(boolean bl) {
        this.btRun.setEnabled(bl);
    }

    private void initComponents() {
        this.tp = new JTabbedPane();
        this.pnlXPath = new JPanel();
        this.btRun = new JButton();
        this.btRunCurrentDoc = new JButton();
        this.txtRequest = new XQueryEditor();
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.spResult = new DbRequestResultPanel();
        this.setBorder(BorderFactory.createTitledBorder("Request"));
        this.tp.setTabPlacement(3);
        this.btRun.setText("Run");
        this.btRunCurrentDoc.setText("Run XQuery document");
        GroupLayout groupLayout = new GroupLayout((Container)this.pnlXPath);
        this.pnlXPath.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.btRun).addPreferredGap(0).add((Component)this.btRunCurrentDoc).add(75, 75, 75)).add((Component)this.txtRequest.getView(), -1, 223, Short.MAX_VALUE).add((Component)this.jSeparator1, -1, 223, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.txtRequest.getView(), -2, 221, -2).addPreferredGap(0).add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.btRunCurrentDoc).add((Component)this.btRun)).addContainerGap()));
        this.tp.addTab("XPath", this.pnlXPath);
        GroupLayout groupLayout2 = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.spResult, -1, 223, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.spResult, -1, 266, Short.MAX_VALUE));
        this.tp.addTab("Result", this.jPanel1);
        GroupLayout groupLayout3 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.tp, -1, 228, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.tp, -1, 294, Short.MAX_VALUE));
    }
}

