/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui;

import com.japisoft.editix.EditixApplicationModel;
import com.japisoft.editix.Main;
import com.japisoft.editix.action.file.OpenAction;
import com.japisoft.editix.action.file.OpenProjectAction;
import com.japisoft.editix.document.DocumentModel;
import com.japisoft.editix.project.ProjectManager;
import com.japisoft.editix.toolkit.AddSystemFilesTransferHandler;
import com.japisoft.editix.ui.EditixContainerListener;
import com.japisoft.editix.ui.EditixEditorFrame;
import com.japisoft.editix.ui.EditixEditorFrameModel;
import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.EditixStatusBar;
import com.japisoft.editix.ui.FileChangeChecker;
import com.japisoft.editix.ui.PanelStateManager;
import com.japisoft.editix.ui.RegisteredAction;
import com.japisoft.editix.ui.panels.EditixDocking;
import com.japisoft.editix.ui.xslt.XSLTEditor;
import com.japisoft.framework.application.descriptor.InterfaceBuilder;
import com.japisoft.framework.job.JobManager;
import com.japisoft.framework.preferences.Preferences;
import com.japisoft.p2.Manager;
import com.japisoft.xmlpad.IView;
import com.japisoft.xmlpad.IXMLPanel;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.XMLDocumentInfo;
import com.japisoft.xmlpad.action.ActionModel;
import com.japisoft.xmlpad.helper.model.AbstractHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabbedContainer;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;

public class EditixFrame
extends JFrame
implements ChangeListener,
ActionListener {
    private InterfaceBuilder builder;
    public static EditixFrame ACCESSOR = null;
    static ArrayList editixContainerListeners = null;
    private int lastTabbedPaneSelection = -1;
    private String[] customActionId = new String[]{"copy", "cut", "paste", "parse"};
    private JToolBar mainToolBar = null;
    private TabbedContainer mainTabbedPane = null;
    private EditixStatusBar mainStatusBar = null;
    public static EditixDocking dockingSpace;
    private boolean autoNewDocument = false;

    public EditixFrame(InterfaceBuilder interfaceBuilder) {
        super("EditiX " + EditixApplicationModel.getAppYear());
        this.builder = interfaceBuilder;
        this.setDefaultCloseOperation(0);
        if (interfaceBuilder.getAppIcon() != null) {
            this.setIconImage(((ImageIcon)interfaceBuilder.getAppIcon()).getImage());
        }
        if (interfaceBuilder.getMenuBar() != null) {
            this.setJMenuBar(interfaceBuilder.getMenuBar());
        }
        this.initUI();
        ACCESSOR = this;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Action action = com.japisoft.framework.application.descriptor.ActionModel.restoreAction("quit");
                action.actionPerformed(null);
            }

            public void windowOpened(WindowEvent windowEvent) {
                if (Main.startingFile != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            OpenAction.openFile(null, false, Main.startingFile, null);
                            Main.startingFile = null;
                        }
                    });
                } else if (Main.startingProject != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            OpenProjectAction.openProject(false, Main.startingProject.toString());
                            Main.startingProject = null;
                        }
                    });
                }
            }
        });
        AddSystemFilesTransferHandler addSystemFilesTransferHandler = new AddSystemFilesTransferHandler();
        this.getRootPane().setTransferHandler(addSystemFilesTransferHandler);
        this.mainTabbedPane.setTransferHandler(addSystemFilesTransferHandler);
        this.mainTabbedPane.getSelectionModel().addChangeListener(this);
        this.mainTabbedPane.setActive(true);
        this.mainTabbedPane.addActionListener(this);
        if (!Manager.isFree()) {
            if (!Manager.hasValidRegisteredFile()) {
                if (Manager.lastRegisteredDay() <= 0) {
                    RegisteredAction registeredAction = new RegisteredAction();
                    registeredAction.actionPerformed(null);
                    System.exit(0);
                }
                this.setTitle(this.getTitle() + " - 30 Day evaluation version");
            } else {
                String string = "";
                if (Manager.isForPersonal()) {
                    string = " For Home usage (enterprise usage is illegal)";
                } else if (Manager.isForProfessional()) {
                    string = " For Small business usage";
                } else if (Manager.isForStudent()) {
                    string = " For Student usage (enterprise usage is illegal)";
                } else if (Manager.isForEnterprise()) {
                    string = " For Enterprise usage";
                }
                this.setTitle(this.getTitle() + " - Registered version by " + Manager.getUser() + string);
            }
        } else {
            this.setTitle(this.getTitle() + " - Free Edition for non commercial usage");
        }
    }

    public void addNotify() {
        super.addNotify();
        if (Preferences.getPreference("interface", "checkFileChange", true)) {
            FileChangeChecker.start();
        }
    }

    public void removeNotify() {
        super.removeNotify();
        FileChangeChecker.stop();
    }

    public static void addEditixContainerListener(EditixContainerListener editixContainerListener) {
        if (editixContainerListeners == null) {
            editixContainerListeners = new ArrayList();
        }
        editixContainerListeners.add(editixContainerListener);
    }

    static void fireContainerClosed(XMLContainer xMLContainer) {
        if (editixContainerListeners != null) {
            for (int i = 0; i < editixContainerListeners.size(); ++i) {
                EditixContainerListener editixContainerListener = (EditixContainerListener)editixContainerListeners.get(i);
                editixContainerListener.close(xMLContainer);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if ("close".equals(actionEvent.getActionCommand())) {
            ProjectManager.synchronizeProjectContent();
            TabActionEvent tabActionEvent = (TabActionEvent)actionEvent;
            tabActionEvent.consume();
            int n = tabActionEvent.getTabIndex();
            if (((IXMLPanel)((Object)this.mainTabbedPane.getModel().getTab(n).getComponent())).getMainContainer() == null) {
                this.closeContainer(this.mainTabbedPane.getModel().getTab(n).getComponent());
                return;
            }
            actionEvent.setSource(((IXMLPanel)((Object)this.mainTabbedPane.getModel().getTab(n).getComponent())).getView());
            com.japisoft.framework.application.descriptor.ActionModel.activeActionById("close", actionEvent);
            if (this.mainTabbedPane.getTabCount() == 0 && this.autoNewDocument) {
                this.checkOneContainer();
                this.autoNewDocument = false;
            }
            if (this.mainTabbedPane.getTabCount() == 0) {
                this.noContainer();
            }
        } else if ("popup".equals(actionEvent.getActionCommand())) {
            TabActionEvent tabActionEvent = (TabActionEvent)actionEvent;
            if (this.builder.hasPopup("TABBEDPANE")) {
                JPopupMenu jPopupMenu = this.builder.getPopup("TABBEDPANE");
                jPopupMenu.show(this.mainTabbedPane, tabActionEvent.getMouseEvent().getX(), tabActionEvent.getMouseEvent().getY());
            }
        }
    }

    public void extract() {
        IXMLPanel iXMLPanel = (IXMLPanel)((Object)this.mainTabbedPane.getSelectedComponent());
        if (iXMLPanel != null) {
            if (iXMLPanel.getMainContainer() == null) {
                return;
            }
            iXMLPanel.setAutoDisposeMode(false);
            this.removeContainer(this.mainTabbedPane.getSelectedComponent());
            EditixEditorFrame editixEditorFrame = new EditixEditorFrame(iXMLPanel);
            editixEditorFrame.setVisible(true);
            EditixEditorFrameModel.addEditixEditorFrame(editixEditorFrame);
        }
    }

    public void refreshCurrentTabName() {
        String string = this.getSelectedContainer().getDocumentInfo().getDocumentName();
        int n = this.getMainTabbedPane().getSelectedIndex();
        this.getMainTabbedPane().setTitleAt(n, string);
        this.getMainTabbedPane().setToolTipTextAt(n, this.getSelectedContainer().getCurrentDocumentLocation());
    }

    private int getTabIndex(XMLContainer xMLContainer) {
        for (int i = 0; i < this.getMainTabbedPane().getTabCount(); ++i) {
            if (((IXMLPanel)((Object)this.getMainTabbedPane().getComponentAt(i))).getMainContainer() != xMLContainer) continue;
            return i;
        }
        return -1;
    }

    public void documentModified(XMLContainer xMLContainer) {
        TabData tabData;
        String string;
        int n = this.getTabIndex(xMLContainer);
        if (n != -1 && !(string = (tabData = this.getMainTabbedPane().getModel().getTab(n)).getText()).startsWith("*")) {
            this.getMainTabbedPane().setTitleAt(n, "*" + string);
        }
    }

    public void documentUnModified(XMLContainer xMLContainer) {
        TabData tabData;
        String string;
        int n = this.getTabIndex(xMLContainer);
        if (n != -1 && (string = (tabData = this.getMainTabbedPane().getModel().getTab(n)).getText()).startsWith("*")) {
            this.getMainTabbedPane().setTitleAt(n, string.substring(1));
        }
    }

    public int getXMLContainerCount() {
        return this.mainTabbedPane.getTabCount() + EditixEditorFrameModel.getXMLContainerCount();
    }

    public XMLContainer getXMLContainer(int n) {
        if (n < this.mainTabbedPane.getTabCount()) {
            return ((IXMLPanel)((Object)this.mainTabbedPane.getComponentAt(n))).getMainContainer();
        }
        return EditixEditorFrameModel.getXMLContainer(n - this.mainTabbedPane.getTabCount());
    }

    public IXMLPanel getIXMLPanel(int n) {
        if (n < this.mainTabbedPane.getTabCount()) {
            return (IXMLPanel)((Object)this.mainTabbedPane.getComponentAt(n));
        }
        return EditixEditorFrameModel.getIXMLPanel(n - this.mainTabbedPane.getTabCount());
    }

    public void activeXMLContainer(int n) {
        if (n < this.mainTabbedPane.getTabCount()) {
            this.mainTabbedPane.setSelectedIndex(n);
        } else {
            EditixEditorFrameModel.active(n - this.mainTabbedPane.getTabCount());
        }
    }

    public boolean activeXMLContainer(String string) {
        IXMLPanel iXMLPanel;
        int n;
        for (n = 0; n < EditixEditorFrameModel.getXMLContainerCount(); ++n) {
            iXMLPanel = EditixEditorFrameModel.getXMLContainer(n);
            if (!string.equalsIgnoreCase(((XMLContainer)iXMLPanel).getCurrentDocumentLocation())) continue;
            EditixEditorFrameModel.active(n);
            return true;
        }
        for (n = 0; n < this.mainTabbedPane.getTabCount(); ++n) {
            iXMLPanel = (IXMLPanel)((Object)this.mainTabbedPane.getComponentAt(n));
            XMLContainer xMLContainer = iXMLPanel.getMainContainer();
            if (xMLContainer == null || !string.equalsIgnoreCase(xMLContainer.getCurrentDocumentLocation())) continue;
            this.mainTabbedPane.setSelectedIndex(n);
            return true;
        }
        return false;
    }

    public boolean activeXMLContainerOrOpenIt(String string) {
        if (!this.activeXMLContainer(string)) {
            String string2 = DocumentModel.getTypeForFileName(string);
            boolean bl = OpenAction.openFile(string2, false, new File(string), null);
            if (bl) {
                this.activeXMLContainer(string);
            }
            return bl;
        }
        return true;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        XMLContainer xMLContainer;
        IXMLPanel iXMLPanel = null;
        if (this.mainTabbedPane.getSelectedComponent() != null) {
            iXMLPanel = (IXMLPanel)((Object)this.mainTabbedPane.getSelectedComponent());
        } else {
            this.builder.setEnabledActionForGroup("*", false);
        }
        if (AbstractHelper.WIN != null) {
            AbstractHelper.WIN.setVisible(false);
        }
        if (this.lastTabbedPaneSelection != -1 && this.lastTabbedPaneSelection < this.mainTabbedPane.getTabCount() && (xMLContainer = ((IXMLPanel)((Object)this.mainTabbedPane.getComponentAt(this.lastTabbedPaneSelection))).getMainContainer()) != null) {
            this.updateMenuActionForGroup(xMLContainer.getDocumentInfo().getType(), false);
        }
        this.lastTabbedPaneSelection = this.mainTabbedPane.getSelectedIndex();
        if (iXMLPanel != null) {
            this.updateCurrentXMLContainer(iXMLPanel);
        }
    }

    public void updateCurrentXMLContainer(IXMLPanel iXMLPanel) {
        XMLContainer xMLContainer = iXMLPanel.getMainContainer();
        if (xMLContainer == null) {
            return;
        }
        PanelStateManager.fireCurrentXMLContainer(xMLContainer);
        XMLDocumentInfo xMLDocumentInfo = xMLContainer.getDocumentInfo();
        String string = xMLDocumentInfo.getType();
        if (xMLDocumentInfo.getParentType() != null) {
            string = xMLDocumentInfo.getParentType();
        }
        this.updateToolBarAndMenuForType(string);
        ActionModel.resetActionState(xMLContainer);
        com.japisoft.framework.application.descriptor.ActionModel.synchronizeState(xMLContainer);
        for (int i = 0; i < this.customActionId.length; ++i) {
            Action action = iXMLPanel.getAction(this.customActionId[i]);
            if (action != null) {
                this.builder.pushAction(action, this.customActionId[i]);
                continue;
            }
            this.builder.popAction(this.customActionId[i]);
        }
    }

    public void updateToolBarAndMenuForType(String string) {
        this.updateToolBarForDocumentType(string);
        this.updateMenuActionForGroup(string, true);
        XMLDocumentInfo xMLDocumentInfo = DocumentModel.getDocumentForType(string);
        XMLContainer xMLContainer = this.getSelectedContainer();
        if (xMLContainer != null && xMLDocumentInfo != null && !xMLContainer.getDocumentInfo().getType().equals(string)) {
            this.mainTabbedPane.setIconAt(this.mainTabbedPane.getSelectedIndex(), xMLDocumentInfo.getDocumentIcon());
        }
    }

    public void updateMenuActionForGroup(String string, boolean bl) {
        this.builder.setEnabledActionForGroup(string, bl);
        String string2 = DocumentModel.getParentType(string);
        if (string2 != null) {
            this.builder.setEnabledActionForGroup(string2, bl);
        }
    }

    private void updateToolBarForDocumentType(String string) {
        JToolBar jToolBar = this.builder.getToolBarByGroup(string);
        if (jToolBar == null) {
            jToolBar = this.builder.getToolBarByGroup("*");
        }
        if (this.mainToolBar != jToolBar) {
            this.remove(this.mainToolBar);
            this.mainToolBar = jToolBar;
            this.getContentPane().add((Component)this.mainToolBar, "North");
            this.getContentPane().invalidate();
            this.getContentPane().validate();
            this.getContentPane().repaint();
        }
    }

    public InterfaceBuilder getBuilder() {
        return this.builder;
    }

    private void initUI() {
        this.getContentPane().setLayout(new BorderLayout());
        this.mainToolBar = this.builder.getToolBarByGroup("*");
        if (this.mainToolBar == null) {
            this.mainToolBar = new JToolBar();
        }
        this.getContentPane().add((Component)this.mainToolBar, "North");
        this.mainTabbedPane = new TabbedContainer(1);
        if (this.builder.hasPopup("TABBEDPANE")) {
            this.mainTabbedPane.addMouseListener(new TabbedPaneMouseAdapter());
        }
        dockingSpace = new EditixDocking();
        dockingSpace.add(this.mainTabbedPane, "Center");
        this.getContentPane().add((Component)dockingSpace.getView(), "Center");
        this.mainStatusBar = new EditixStatusBar();
        dockingSpace.add(this.mainStatusBar, "South");
    }

    public JToolBar getMainToolBar() {
        return this.mainToolBar;
    }

    public TabbedContainer getMainTabbedPane() {
        return this.mainTabbedPane;
    }

    public void updateToolTip() {
        XMLContainer xMLContainer = this.getSelectedContainer();
        if (xMLContainer != null && xMLContainer.getCurrentDocumentLocation() != null) {
            this.mainTabbedPane.updateToolTip(xMLContainer.getView(), xMLContainer.getCurrentDocumentLocation());
        }
    }

    public XMLContainer getSelectedContainer() {
        if (EditixEditorFrameModel.getSelectedXMLContainer() != null) {
            return EditixEditorFrameModel.getSelectedXMLContainer();
        }
        IXMLPanel iXMLPanel = (IXMLPanel)((Object)this.mainTabbedPane.getSelectedComponent());
        if (iXMLPanel == null) {
            if (EditixEditorFrameModel.getXMLContainerCount() > 0) {
                EditixEditorFrameModel.active(0);
                XMLContainer xMLContainer = EditixEditorFrameModel.getXMLContainer(0);
                if (xMLContainer.getSelectedContainer() != null) {
                    xMLContainer = xMLContainer.getSelectedContainer();
                }
                return xMLContainer;
            }
            return null;
        }
        if (iXMLPanel.getSelectedContainer() != null) {
            return iXMLPanel.getSelectedContainer();
        }
        return iXMLPanel.getMainContainer();
    }

    public XMLContainer getSelectedSubContainer(String string) {
        IXMLPanel iXMLPanel = (IXMLPanel)((Object)this.mainTabbedPane.getSelectedComponent());
        if (iXMLPanel == null) {
            return null;
        }
        return iXMLPanel.getSubContainer(string);
    }

    public IXMLPanel getSelectedPanel() {
        return (IXMLPanel)((Object)this.mainTabbedPane.getSelectedComponent());
    }

    public XMLContainer getSelectedContainer(String string) {
        IXMLPanel iXMLPanel = (IXMLPanel)((Object)this.mainTabbedPane.getSelectedComponent());
        if (iXMLPanel == null) {
            return null;
        }
        return iXMLPanel.getSubContainer(string);
    }

    public IXMLPanel getContainerByFilePath(String string) {
        for (int i = 0; i < this.mainTabbedPane.getTabCount(); ++i) {
            String string2;
            IXMLPanel iXMLPanel = (IXMLPanel)((Object)this.mainTabbedPane.getComponentAt(i));
            XMLContainer xMLContainer = iXMLPanel.getMainContainer();
            if (xMLContainer == null || (string2 = xMLContainer.getCurrentDocumentLocation()) == null || !string.equals(string2)) continue;
            return iXMLPanel;
        }
        return null;
    }

    public boolean hasContainer() {
        return this.mainTabbedPane.getTabCount() > 0;
    }

    public void addContainer(IXMLPanel iXMLPanel) {
        Object object;
        IXMLPanel iXMLPanel2;
        if (this.mainTabbedPane.getTabCount() == 0) {
            this.builder.setEnabledActionForAllGroup(false);
        }
        if (iXMLPanel instanceof XSLTEditor) {
            iXMLPanel2 = (XSLTEditor)iXMLPanel;
            object = Preferences.getPreference("file", "defaultXSLTPath", "");
        }
        if ((iXMLPanel2 = iXMLPanel.getMainContainer()) != null) {
            iXMLPanel.setAutoDisposeMode(true);
            object = ((XMLContainer)iXMLPanel2).getDocumentInfo();
            this.mainTabbedPane.addTab(((XMLDocumentInfo)object).getDocumentName(), ((XMLDocumentInfo)object).getDocumentIcon(), iXMLPanel.getView(), ((XMLDocumentInfo)object).getCurrentDocumentLocation());
            this.mainTabbedPane.setSelectedComponent(iXMLPanel.getView());
            this.builder.setEnabledActionForGroup("*", true);
            ((XMLContainer)iXMLPanel2).requestFocus();
            if (this.getSelectedContainer() != iXMLPanel2) {
                this.updateCurrentXMLContainer(iXMLPanel2);
            }
        } else {
            this.mainTabbedPane.addTab(iXMLPanel.toString(), null, iXMLPanel.getView(), null);
        }
    }

    public void removeContainer(Component component) {
        IXMLPanel iXMLPanel;
        Object object;
        if (component instanceof IView) {
            for (int i = 0; i < this.mainTabbedPane.getTabCount(); ++i) {
                object = (IXMLPanel)((Object)this.mainTabbedPane.getModel().getTab(i).getComponent());
                if (object.getMainContainer() == null || object.getMainContainer().getView() != component) continue;
                component = object.getView();
                break;
            }
        }
        this.mainTabbedPane.removeComponent(component);
        if (component instanceof IXMLPanel && (iXMLPanel = (IXMLPanel)((Object)component)).getMainContainer() != null) {
            object = iXMLPanel.getMainContainer().getDocumentInfo().getType();
            this.updateMenuActionForGroup((String)object, false);
            EditixFrame.fireContainerClosed(iXMLPanel.getMainContainer());
            PanelStateManager.fireClose(iXMLPanel.getMainContainer());
        }
    }

    public void closeCurrentContainer() {
        try {
            for (int i = 0; JobManager.working && i < 2000; i += 10) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.removeContainer(this.mainTabbedPane.getSelectedComponent());
        if (this.mainTabbedPane.getTabCount() == 0) {
            this.mainTabbedPane.requestFocus();
        }
        if (this.mainTabbedPane.getTabCount() == 0) {
            this.noContainer();
        } else {
            this.stateChanged(null);
        }
    }

    public void closeContainer(Component component) {
        this.removeContainer(component);
        if (this.mainTabbedPane.getTabCount() == 0) {
            this.mainTabbedPane.requestFocus();
        }
        if (this.mainTabbedPane.getTabCount() == 0) {
            this.noContainer();
        } else {
            this.stateChanged(null);
        }
    }

    public void closeAllContainers() {
        this.closeAllContainers(false);
    }

    public void closeAllContainers(boolean bl) {
        this.stateChanged(null);
        int n = this.mainTabbedPane.getTabCount();
        if (n == 0) {
            return;
        }
        Component component = null;
        if (bl) {
            component = this.mainTabbedPane.getComponentAt(this.mainTabbedPane.getSelectedIndex());
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (this.mainTabbedPane.getComponentAt(n2) != component) {
                this.removeContainer(this.mainTabbedPane.getComponentAt(n2));
                continue;
            }
            n2 = 1;
        }
        this.mainTabbedPane.requestFocus();
        if (this.mainTabbedPane.getTabCount() == 0) {
            this.noContainer();
        }
    }

    public boolean isEmpty() {
        return this.mainTabbedPane.getTabCount() == 0 && EditixEditorFrameModel.getXMLContainerCount() == 0;
    }

    public void setAutoNewDocument(boolean bl) {
        this.autoNewDocument = bl;
    }

    public void checkOneContainer() {
        if (this.mainTabbedPane.getTabCount() == 0) {
            this.addContainer(EditixFactory.buildNewContainer(true));
        }
    }

    public void displaySelectedError(boolean bl, String string, String string2, int n) {
        if (bl) {
            XMLContainer xMLContainer = this.getSelectedContainer();
            if (xMLContainer != null) {
                xMLContainer.getEditor().highlightErrorLine(n, true);
            }
        } else if (string != null) {
            File file;
            if (string.startsWith("file")) {
                string = string.substring(5);
            }
            if ((file = new File(string)).exists()) {
                IXMLPanel iXMLPanel = this.getContainerByFilePath(file.toString());
                if (iXMLPanel == null) {
                    String string3 = null;
                    string3 = string.toLowerCase().endsWith("dtd") ? "DTD" : (string.toLowerCase().endsWith("xml") ? "XML" : "XSD");
                    com.japisoft.framework.application.descriptor.ActionModel.activeActionById("open", null, file.toString(), string3);
                    iXMLPanel = this.getSelectedContainer();
                } else {
                    this.mainTabbedPane.setSelectedComponent(iXMLPanel.getView());
                }
                if (iXMLPanel != null && iXMLPanel.getMainContainer() != null) {
                    iXMLPanel.getMainContainer().getErrorManager().initErrorProcessing();
                    iXMLPanel.getMainContainer().getErrorManager().notifyError(null, true, null, n, 0, 0, string2, false);
                    iXMLPanel.getMainContainer().getErrorManager().stopErrorProcessing();
                }
            }
        }
    }

    public void selectDefaultContainer() {
        this.mainTabbedPane.setSelectedIndex(0);
    }

    private void noContainer() {
        PanelStateManager.fireCurrentXMLContainer(null);
        this.mainStatusBar.clearState();
        this.lastTabbedPaneSelection = -1;
        this.builder.setEnabledActionForGroup("*", false);
    }

    class TabbedPaneMouseAdapter
    extends MouseAdapter {
        TabbedPaneMouseAdapter() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() && EditixFrame.this.builder.hasPopup("TABBEDPANE")) {
                EditixFrame.this.builder.getPopup("TABBEDPANE").show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.mousePressed(mouseEvent);
        }
    }
}

