/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui.panels.universalbrowser;

import com.japisoft.editix.ui.panels.universalbrowser.FTPConfig;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;

public class FTPChooserPanel
extends JPanel
implements ItemListener {
    private JComboBox cbHosts;
    private JCheckBox cbSave;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JSeparator jSeparator1;
    private JTextField txtDirectory;
    private JTextField txtHost;
    private JPasswordField txtPassword;
    private JTextField txtUser;

    public FTPChooserPanel() {
        this.initComponents();
    }

    public void restoreSaveHosts(List list) {
        this.cbHosts.removeAllItems();
        for (int i = 0; i < list.size(); ++i) {
            this.cbHosts.addItem(list.get(i));
        }
        if (list.size() > 0) {
            this.resetConfig((FTPConfig)list.get(0));
        }
    }

    public void addNotify() {
        super.addNotify();
        this.cbHosts.addItemListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.cbHosts.removeItemListener(this);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        FTPConfig fTPConfig = (FTPConfig)this.cbHosts.getSelectedItem();
        if (fTPConfig != null) {
            this.resetConfig(fTPConfig);
        }
    }

    private void resetConfig(FTPConfig fTPConfig) {
        this.txtHost.setText(fTPConfig.host);
        this.txtUser.setText(fTPConfig.user);
        this.txtPassword.setText(fTPConfig.password);
        this.txtDirectory.setText(fTPConfig.directory);
    }

    public FTPConfig getFTPConfig() {
        FTPConfig fTPConfig = new FTPConfig();
        fTPConfig.host = this.txtHost.getText();
        fTPConfig.user = this.txtUser.getText();
        fTPConfig.directory = this.txtDirectory.getText();
        fTPConfig.password = this.txtPassword.getText();
        fTPConfig.save = this.cbSave.isSelected();
        return fTPConfig;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.cbHosts = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.jLabel2 = new JLabel();
        this.txtHost = new JTextField();
        this.jLabel3 = new JLabel();
        this.txtUser = new JTextField();
        this.jLabel4 = new JLabel();
        this.txtPassword = new JPasswordField();
        this.jLabel5 = new JLabel();
        this.txtDirectory = new JTextField();
        this.cbSave = new JCheckBox();
        this.jLabel1.setText("Host history");
        this.jLabel2.setText("Host");
        this.jLabel3.setText("User");
        this.jLabel4.setText("Password");
        this.jLabel5.setText("Default directory (optional)");
        this.cbSave.setText("Save");
        this.cbSave.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbSave.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.cbHosts, 0, 200, Short.MAX_VALUE).add((Component)this.jLabel1).add((Component)this.jSeparator1, -1, 200, Short.MAX_VALUE).add((Component)this.jLabel2).add((Component)this.txtHost, -1, 200, Short.MAX_VALUE).add((Component)this.jLabel3).add((Component)this.txtUser, -1, 200, Short.MAX_VALUE).add((Component)this.jLabel4).add((Component)this.txtPassword, -1, 200, Short.MAX_VALUE).add((Component)this.jLabel5).add((Component)this.txtDirectory, -1, 200, Short.MAX_VALUE).add((Component)this.cbSave)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.cbHosts, -2, -1, -2).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.txtHost, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.txtUser, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.txtPassword, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel5).addPreferredGap(0).add((Component)this.txtDirectory, -2, -1, -2).addPreferredGap(0, 21, Short.MAX_VALUE).add((Component)this.cbSave).addContainerGap()));
    }
}

