/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui.xsd.view.element;

import com.japisoft.editix.ui.xsd.toolkit.SchemaHelper;
import com.japisoft.editix.ui.xsd.toolkit.XSDAttribute;
import com.japisoft.editix.ui.xsd.view.View;
import com.japisoft.editix.ui.xsd.view.element.PropertiesViewListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PropertiesViewImpl
extends JTable
implements View {
    protected Element initE;
    protected XSDAttribute[] contents;
    private PropertiesViewListener listener;
    private boolean designerMode = false;

    public PropertiesViewImpl() {
        this.setModel(new CustomAttributesModel());
        this.getSelectionModel().setSelectionMode(0);
        CustomAttributeRenderer customAttributeRenderer = new CustomAttributeRenderer();
        this.getColumnModel().getColumn(0).setCellRenderer(customAttributeRenderer);
        this.getColumnModel().getColumn(1).setCellEditor(new CustomValueEditor());
        this.getColumnModel().getColumn(1).setCellRenderer(new CustomValueRenderer());
    }

    public void setPropertiesViewListener(PropertiesViewListener propertiesViewListener) {
        this.listener = propertiesViewListener;
    }

    public void setDesignerMode(boolean bl) {
        this.designerMode = bl;
    }

    public void init(Element element) {
        this.stopEditing();
        this.removeEditor();
        this.initE = element;
        if (element != null) {
            int n;
            if (element.getLocalName() != null) {
                this.contents = SchemaHelper.getAttributesForElement(element.getLocalName(), this.designerMode);
            } else if (element.getNodeName() != null) {
                int n2 = element.getNodeName().lastIndexOf(58);
                this.contents = n2 > -1 ? SchemaHelper.getAttributesForElement(element.getNodeName().substring(0, n2), this.designerMode) : SchemaHelper.getAttributesForElement(element.getNodeName(), this.designerMode);
            }
            ArrayList arrayList = new ArrayList();
            if (this.contents != null) {
                Collections.addAll(arrayList, this.contents);
            }
            for (n = 0; n < arrayList.size(); ++n) {
                XSDAttribute xSDAttribute = (XSDAttribute)arrayList.get(n);
                if (this.designerMode || !"name".equals(xSDAttribute.name)) continue;
                arrayList.remove(xSDAttribute);
                break;
            }
            this.contents = new XSDAttribute[arrayList.size()];
            for (n = 0; n < arrayList.size(); ++n) {
                this.contents[n] = (XSDAttribute)arrayList.get(n);
            }
        } else {
            this.contents = new XSDAttribute[0];
        }
        this.reloadModel();
    }

    public void reloadModel() {
        ((CustomAttributesModel)this.getModel()).reload();
    }

    public JComponent getView() {
        return this;
    }

    public void dispose() {
        ((CustomValueEditor)this.getColumnModel().getColumn(1).getCellEditor()).dispose();
        this.initE = null;
        this.contents = null;
        this.listener = null;
    }

    public void stopEditing() {
        if (this.getCellEditor() != null) {
            CustomValueEditor customValueEditor;
            this.getCellEditor().stopCellEditing();
            if (this.getCellEditor() != null && (customValueEditor = (CustomValueEditor)this.getCellEditor()).storedStoppedValue != null) {
                try {
                    this.setValueAt(customValueEditor.storedStoppedValue, customValueEditor.currentRow, 1);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                customValueEditor.storedStoppedValue = null;
                customValueEditor.forceStop = false;
            }
        }
    }

    class CustomValueEditor
    implements TableCellEditor,
    ActionListener,
    ItemListener {
        private JComponent currentComponent = null;
        private JComboBox cbb = new JComboBox();
        private JTextField tf = new JTextField();
        private JCheckBox cb = new JCheckBox("Ok");
        private int currentRow;
        private EventListenerList listenerList = new EventListenerList();
        private boolean forceStop = false;
        private Object storedStoppedValue = null;
        private JComponent oldCurrentComponent = null;

        CustomValueEditor() {
            this.cbb.addActionListener(this);
            this.cb.addActionListener(this);
            this.tf.setDocument(new PlainDocument(){

                public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                    XSDAttribute xSDAttribute = PropertiesViewImpl.this.contents[CustomValueEditor.this.currentRow];
                    if ("name".equals(xSDAttribute.name)) {
                        boolean bl = true;
                        for (int i = 0; i < string.length(); ++i) {
                            if (Character.isWhitespace(string.charAt(i))) continue;
                            bl = false;
                            break;
                        }
                        if (bl) {
                            return;
                        }
                    }
                    super.insertString(n, string, attributeSet);
                    PropertiesViewImpl.this.initE.setAttribute(xSDAttribute.name, CustomValueEditor.this.tf.getText());
                }

                public void remove(int n, int n2) throws BadLocationException {
                    super.remove(n, n2);
                    XSDAttribute xSDAttribute = PropertiesViewImpl.this.contents[CustomValueEditor.this.currentRow];
                    if ("".equals(CustomValueEditor.this.tf.getText())) {
                        PropertiesViewImpl.this.initE.removeAttribute(xSDAttribute.name);
                    } else {
                        PropertiesViewImpl.this.initE.setAttribute(xSDAttribute.name, CustomValueEditor.this.tf.getText());
                    }
                }
            });
            this.tf.addActionListener(this);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.currentRow = n;
            this.oldCurrentComponent = this.currentComponent;
            this.currentComponent = null;
            XSDAttribute xSDAttribute = PropertiesViewImpl.this.contents[n];
            String[] stringArray = null;
            switch (xSDAttribute.type) {
                case 0: {
                    if (xSDAttribute.def == null) {
                        this.currentComponent = this.tf;
                        break;
                    }
                    stringArray = xSDAttribute.def;
                    break;
                }
                case 1: {
                    this.cb.setSelected("true".equals(object));
                    this.currentComponent = this.cb;
                    break;
                }
                case 2: {
                    if (xSDAttribute.def == null) {
                        this.currentComponent = this.tf;
                        break;
                    }
                    stringArray = xSDAttribute.def;
                    break;
                }
                case 3: {
                    stringArray = SchemaHelper.getElementRef(PropertiesViewImpl.this.initE.getOwnerDocument().getDocumentElement());
                    break;
                }
                case 9: {
                    stringArray = SchemaHelper.getType(PropertiesViewImpl.this.initE.getOwnerDocument().getDocumentElement(), true, true);
                    break;
                }
                case 4: {
                    stringArray = SchemaHelper.getType(PropertiesViewImpl.this.initE.getOwnerDocument().getDocumentElement(), true, false);
                    break;
                }
                case 8: {
                    stringArray = SchemaHelper.getType(PropertiesViewImpl.this.initE.getOwnerDocument().getDocumentElement(), false, true);
                    break;
                }
                case 5: {
                    stringArray = SchemaHelper.getAttributeRef(PropertiesViewImpl.this.initE.getOwnerDocument().getDocumentElement());
                    break;
                }
                case 10: {
                    stringArray = SchemaHelper.getAttributeGroupRef(PropertiesViewImpl.this.initE.getOwnerDocument().getDocumentElement());
                    break;
                }
                case 6: {
                    stringArray = SchemaHelper.getGroupRef(PropertiesViewImpl.this.initE.getOwnerDocument().getDocumentElement());
                    break;
                }
            }
            if (stringArray != null) {
                this.currentComponent = this.cbb;
                this.cbb.setModel(new DefaultComboBoxModel<String>(stringArray));
                if (xSDAttribute.anyString) {
                    ((JComboBox)this.currentComponent).setEditable(true);
                }
                if (object != null) {
                    ((JComboBox)this.currentComponent).setSelectedItem(object.toString());
                }
            } else if (this.currentComponent instanceof JTextField && object != null) {
                ((JTextField)this.currentComponent).setText(object.toString());
            }
            return this.currentComponent;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.fireEditingStopped(new ChangeEvent(this));
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.fireEditingStopped(new ChangeEvent(this));
        }

        private void fireEditingStopped(ChangeEvent changeEvent) {
            EventListener[] eventListenerArray = this.listenerList.getListeners(CellEditorListener.class);
            if (eventListenerArray != null) {
                for (int i = 0; i < eventListenerArray.length; ++i) {
                    ((CellEditorListener)eventListenerArray[i]).editingStopped(changeEvent);
                }
            }
        }

        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.listenerList.add(CellEditorListener.class, cellEditorListener);
        }

        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.listenerList.remove(CellEditorListener.class, cellEditorListener);
        }

        void dispose() {
            if (this.currentComponent instanceof AbstractButton) {
                ((AbstractButton)this.currentComponent).removeActionListener(this);
            } else if (this.currentComponent instanceof JComboBox) {
                ((JComboBox)this.currentComponent).removeActionListener(this);
            } else if (this.currentComponent instanceof JCheckBox) {
                ((JCheckBox)this.currentComponent).removeActionListener(this);
            }
            this.oldCurrentComponent = null;
            this.currentComponent = null;
        }

        public void cancelCellEditing() {
        }

        public boolean stopCellEditing() {
            if (this.currentComponent instanceof JCheckBox) {
                this.storedStoppedValue = "" + ((JCheckBox)this.currentComponent).isSelected();
            } else if (this.currentComponent instanceof JTextField) {
                this.storedStoppedValue = ((JTextField)this.currentComponent).getText();
            } else if (this.currentComponent instanceof JComboBox) {
                this.storedStoppedValue = ((JComboBox)this.currentComponent).isEditable() ? ((JComboBox)this.currentComponent).getEditor().getItem() : ((JComboBox)this.currentComponent).getSelectedItem();
            }
            this.forceStop = true;
            return true;
        }

        public Object getCellEditorValue() {
            if (this.forceStop) {
                this.forceStop = false;
                Object object = this.storedStoppedValue;
                this.storedStoppedValue = null;
                return object;
            }
            if (this.currentComponent instanceof JCheckBox) {
                return "" + ((JCheckBox)this.currentComponent).isSelected();
            }
            if (this.currentComponent instanceof JTextField) {
                return ((JTextField)this.currentComponent).getText();
            }
            if (this.currentComponent instanceof JComboBox) {
                if (((JComboBox)this.currentComponent).isEditable()) {
                    return ((JComboBox)this.currentComponent).getEditor().getItem();
                }
                return ((JComboBox)this.currentComponent).getSelectedItem();
            }
            return null;
        }

        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return false;
        }
    }

    class CustomValueRenderer
    implements TableCellRenderer {
        private JLabel lbl = new JLabel();
        private JComboBox cbb = new JComboBox();
        private JCheckBox cb = new JCheckBox("Ok");

        CustomValueRenderer() {
            this.cbb.setEditable(true);
            this.cbb.setOpaque(false);
            this.cb.setOpaque(false);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string;
            int n3;
            XSDAttribute xSDAttribute = PropertiesViewImpl.this.contents[n];
            JComponent jComponent = null;
            switch (xSDAttribute.type) {
                case 0: {
                    if (xSDAttribute.def == null) {
                        jComponent = this.lbl;
                        break;
                    }
                    jComponent = this.cbb;
                    break;
                }
                case 1: {
                    jComponent = this.cb;
                    break;
                }
                case 2: {
                    if (xSDAttribute.def == null) {
                        jComponent = this.lbl;
                        break;
                    }
                    jComponent = this.cbb;
                    break;
                }
                case 3: {
                    jComponent = this.cbb;
                    break;
                }
                case 4: 
                case 8: 
                case 9: {
                    jComponent = this.cbb;
                    break;
                }
                case 5: 
                case 10: {
                    jComponent = this.cbb;
                    break;
                }
                case 6: {
                    jComponent = this.cbb;
                    break;
                }
                case 7: {
                    jComponent = this.lbl;
                }
            }
            if (jComponent instanceof JLabel) {
                if (object != null) {
                    ((JLabel)jComponent).setText(object.toString());
                }
            } else if (jComponent instanceof JComboBox) {
                if (object != null) {
                    ((JComboBox)jComponent).setSelectedItem(object.toString());
                }
            } else if (jComponent instanceof JCheckBox) {
                ((AbstractButton)jComponent).setSelected("true".equals(object));
            }
            if ((n3 = (string = xSDAttribute.name).indexOf("(")) > -1) {
                string = string.substring(0, n3 - 1);
            }
            if (PropertiesViewImpl.this.initE.getAttribute(string) == null || "".equals(PropertiesViewImpl.this.initE.getAttribute(string))) {
                jComponent.setEnabled(false);
            } else {
                jComponent.setEnabled(true);
            }
            return jComponent;
        }
    }

    class CustomAttributesModel
    implements TableModel {
        private TableModelListener l;

        CustomAttributesModel() {
        }

        public void reload() {
            this.l.tableChanged(new TableModelEvent(this));
        }

        public void addTableModelListener(TableModelListener tableModelListener) {
            this.l = tableModelListener;
        }

        public void removeTableModelListener(TableModelListener tableModelListener) {
            this.l = null;
        }

        public Class getColumnClass(int n) {
            return String.class;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return "Name";
            }
            return "Value";
        }

        public int getRowCount() {
            if (PropertiesViewImpl.this.contents == null) {
                return 0;
            }
            return PropertiesViewImpl.this.contents.length;
        }

        public void setValueAt(Object object, int n, int n2) {
            String string = (String)this.getValueAt(n, 0);
            int n3 = string.indexOf("(");
            String string2 = null;
            if (n3 > -1) {
                int n4 = string.lastIndexOf(")");
                string2 = string.substring(n3 + 1, n4);
                string = string.substring(0, n3 - 1);
            }
            if (object == null || "".equals(object)) {
                PropertiesViewImpl.this.initE.removeAttribute(string);
            } else {
                Element element = PropertiesViewImpl.this.initE;
                boolean bl = true;
                if ("base".equals(string2)) {
                    Element element2 = SchemaHelper.searchForChildWithAttribute(PropertiesViewImpl.this.initE, "base");
                    if (element2 != null) {
                        element = element2;
                        string = "base";
                    }
                } else if ("list items".equals(string2)) {
                    bl = false;
                    boolean bl2 = SchemaHelper.updateListType(element, (String)object);
                    if (!bl2) {
                        SchemaHelper.removeChildren(element);
                        Element element3 = element;
                        if (!"simpleType".equals(element.getLocalName())) {
                            element3 = SchemaHelper.createTag(element, "simpleType");
                            element.appendChild(element3);
                        }
                        Element element4 = SchemaHelper.createTag(element, "list");
                        element3.appendChild(element4);
                        element4.setAttribute("itemType", (String)object);
                        element.removeAttribute("type");
                    }
                } else if ("type".equals(string)) {
                    NodeList nodeList = element.getChildNodes();
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Element element5;
                        if (!(nodeList.item(i) instanceof Element) || !"simpleType".equals((element5 = (Element)nodeList.item(i)).getLocalName()) && !"complexType".equals(element5.getLocalName())) continue;
                        element.removeChild(element5);
                    }
                }
                if ("ref".equals(string)) {
                    element.removeAttribute("name");
                }
                if (bl) {
                    element.setAttribute(string, (String)object);
                    PropertiesViewImpl.this.listener.resetAttribute(string, (String)object);
                }
            }
        }

        public Object getValueAt(int n, int n2) {
            if (PropertiesViewImpl.this.contents == null) {
                return null;
            }
            XSDAttribute xSDAttribute = PropertiesViewImpl.this.contents[n];
            String string = xSDAttribute.name;
            if (n2 == 0) {
                return string;
            }
            Element element = PropertiesViewImpl.this.initE;
            int n3 = string.indexOf("(");
            if (n3 > -1) {
                int n4 = string.lastIndexOf(")");
                String string2 = string.substring(n3 + 1, n4);
                string = string.substring(0, n3 - 1);
                if ("base".equals(string2)) {
                    Element element2 = SchemaHelper.searchForChildWithAttribute(PropertiesViewImpl.this.initE, "base");
                    if (element2 != null) {
                        element = element2;
                        string = "base";
                    }
                } else if ("list items".equals(string2)) {
                    return SchemaHelper.getListType(element);
                }
            }
            return element.getAttribute(string);
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }
    }

    class CustomAttributeRenderer
    extends DefaultTableCellRenderer {
        CustomAttributeRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            XSDAttribute xSDAttribute = PropertiesViewImpl.this.contents[n];
            if (PropertiesViewImpl.this.initE.getAttribute(xSDAttribute.name) == null || "".equals(PropertiesViewImpl.this.initE.getAttribute(xSDAttribute.name))) {
                component.setForeground(Color.GRAY);
            } else {
                component.setForeground(Color.BLACK);
            }
            return component;
        }
    }
}

