/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework;

import com.japisoft.framework.ApplicationException;
import com.japisoft.framework.ApplicationModel;
import com.japisoft.framework.ApplicationStep;
import com.japisoft.framework.ApplicationStepException;
import com.japisoft.framework.log.Logger;
import com.japisoft.framework.preferences.Preferences;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ApplicationMain {
    private static String[] initArgs;

    public static void start(String string, String[] stringArray) throws ApplicationException {
        ApplicationModel.init(string);
        ApplicationMain.start(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(String[] stringArray) throws ApplicationException {
        ApplicationStep applicationStep;
        int n;
        initArgs = stringArray;
        if (ApplicationModel.getApplicationStepCount() == 0) {
            throw new ApplicationException("No application step found");
        }
        boolean bl = false;
        try {
            for (n = 0; n < ApplicationModel.getApplicationStepCount(); ++n) {
                applicationStep = ApplicationModel.getApplicationStepAt(n);
                if (applicationStep.isFinal()) continue;
                ApplicationModel.debug("Start " + applicationStep.getClass());
                bl = true;
                try {
                    applicationStep.start(stringArray);
                    continue;
                }
                catch (ApplicationStepException applicationStepException) {
                    if (!applicationStepException.isCritical()) continue;
                    throw new ApplicationException(applicationStepException);
                }
            }
        }
        finally {
            for (n = 0; n < ApplicationModel.getApplicationStepCount(); ++n) {
                applicationStep = ApplicationModel.getApplicationStepAt(n);
                if (applicationStep.isFinal()) continue;
                try {
                    ApplicationModel.debug("Stop " + applicationStep.getClass());
                    applicationStep.stop();
                    continue;
                }
                catch (Throwable throwable) {
                    Logger.addException(throwable);
                }
            }
        }
        if (!bl) {
            throw new ApplicationException("No application step found. Only final application step available ?");
        }
    }

    public static void stop(int n) {
        for (int i = 0; i < ApplicationModel.getApplicationStepCount(); ++i) {
            ApplicationStep applicationStep = ApplicationModel.getApplicationStepAt(i);
            if (!applicationStep.isFinal()) continue;
            try {
                ApplicationModel.debug("Start and Stop " + applicationStep.getClass());
                applicationStep.start(initArgs);
                applicationStep.stop();
                continue;
            }
            catch (Throwable throwable) {
                Logger.addException(throwable);
            }
        }
        Preferences.savePreferences();
        System.exit(n);
    }

    public static void showException(Throwable throwable) {
        throwable.printStackTrace();
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        JFrame jFrame = new JFrame("Unknown error !");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ApplicationModel.LONG_APPNAME + " " + ApplicationModel.getAppVersion() + " - Build " + ApplicationModel.BUILD);
        stringBuffer.append("\nHas met an unknown error, please send it to : " + ApplicationModel.MAIN_SUPPORT_EMAIL + "\n");
        stringBuffer.append("specifying your operating system version and java version\n");
        stringBuffer.append("Java Version : ").append(System.getProperty("java.version")).append("\n");
        stringBuffer.append("Operating System : ").append(System.getProperty("os.name")).append("\n");
        stringBuffer.append("\n----------------------------------------------------------------\n\n");
        stringBuffer.append(stringWriter.toString());
        JTextArea jTextArea = new JTextArea(stringBuffer.toString());
        jFrame.getContentPane().add(new JScrollPane(jTextArea));
        jFrame.pack();
        jFrame.setDefaultCloseOperation(3);
        jFrame.setVisible(true);
    }
}

