/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.dialog.actions;

import com.japisoft.framework.dialog.DialogComponent;
import com.japisoft.framework.dialog.DialogFooter;
import com.japisoft.framework.dialog.actions.AbstractDialogAction;
import com.japisoft.framework.dialog.actions.DialogVisibilityObserver;
import com.japisoft.framework.dialog.actions.ToggleActionTransformer;
import com.japisoft.framework.preferences.Preferences;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;

public class StoringLocationAction
extends AbstractDialogAction
implements DialogVisibilityObserver,
ToggleActionTransformer {
    public static String preferenceCat = "dialog";

    public StoringLocationAction() {
        super(100, false);
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("lock2.png")));
        this.putValue("ShortDescription", "When selecting, it fixes the last dialog location");
        this.setSpecial(true);
    }

    public void dialogHidden(DialogComponent dialogComponent, DialogFooter dialogFooter) {
        if (dialogFooter.isDialogActionSelected(100)) {
            Preferences.setRawPreference(preferenceCat, this.getDialogName(dialogComponent), dialogComponent.getView().getBounds());
        }
    }

    public void dialogShown(DialogComponent dialogComponent, DialogFooter dialogFooter) {
        Rectangle rectangle = Preferences.getPreference(preferenceCat, this.getDialogName(dialogComponent), (Rectangle)null);
        if (rectangle != null) {
            dialogComponent.getView().setBounds(rectangle);
        }
    }

    private String getDialogName(DialogComponent dialogComponent) {
        String string = dialogComponent.getClass().getName();
        int n = string.lastIndexOf(".");
        if (n > -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }
}

