/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.xml;

import com.japisoft.framework.ApplicationModel;
import com.japisoft.framework.preferences.Preferences;
import com.japisoft.framework.xml.XMLToolkit;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;

public final class XSLTTransformer {
    public static String DEF_TRANS_NAME = "XALAN";
    public static String DEF_TRANS_CLASS = "com.icl.saxon.TransformerFactoryImpl";
    public static String DEF_LIBRARY_PATH = "xslt";
    private static Class DEF_TRANS = null;
    private static boolean ERROR_FOUND = false;
    private static TransformerFactory FACTORY = null;

    public static void resetDefaultTransformer() {
        String string;
        System.setProperty("javax.xml.parsers.SAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
        ApplicationModel.debug("Reset the default transformer");
        if (!(DEF_TRANS != null || ERROR_FOUND || XSLTTransformer.loadByConfigFile() || DEF_TRANS_NAME.equals(string = Preferences.getPreference("xmlconfig", "transformer", DEF_TRANS_NAME)))) {
            ArrayList arrayList = XMLToolkit.browseJars(DEF_LIBRARY_PATH);
            if (arrayList.size() == 0) {
                try {
                    DEF_TRANS = Class.forName(string);
                }
                catch (Throwable throwable) {
                    System.err.println("No library found inside the " + DEF_LIBRARY_PATH + " directory");
                    System.err.println("Can't use the " + string + " class");
                    ERROR_FOUND = true;
                }
            } else {
                URL[] uRLArray = new URL[arrayList.size()];
                for (int i = 0; i < arrayList.size(); ++i) {
                    uRLArray[i] = (URL)arrayList.get(i);
                }
                try {
                    URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
                    DEF_TRANS = uRLClassLoader.loadClass(string);
                }
                catch (Throwable throwable) {
                    ERROR_FOUND = true;
                    System.err.println("Can't use " + string + " : " + throwable.getMessage());
                }
            }
        }
    }

    static boolean loadByConfigFile() {
        try {
            ApplicationModel.debug("Load jaxp_transformer.dat");
            Class clazz = XMLToolkit.loadByConfigFile(new File(ApplicationModel.getAppUserPath(), "jaxp_transformer.dat"));
            if (clazz != null) {
                ApplicationModel.debug("Class found " + clazz);
                DEF_TRANS = clazz;
                return true;
            }
            ApplicationModel.debug("No class found");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static TransformerFactory getTransformerFactory() {
        XSLTTransformer.resetDefaultTransformer();
        TransformerFactory transformerFactory = null;
        if (DEF_TRANS != null) {
            try {
                transformerFactory = (TransformerFactory)DEF_TRANS.newInstance();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                System.err.println("Can't use " + DEF_TRANS + " : " + throwable.getMessage());
            }
        }
        if (DEF_TRANS == null) {
            try {
                DEF_TRANS = Class.forName(DEF_TRANS_CLASS);
                transformerFactory = (TransformerFactory)DEF_TRANS.newInstance();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw new RuntimeException("ERROR CAN'T FIND " + DEF_TRANS_CLASS + "???");
            }
        }
        ApplicationModel.debug("Use the factory " + transformerFactory);
        return transformerFactory;
    }

    public static Transformer getTransformer() throws Exception {
        if (FACTORY == null) {
            FACTORY = XSLTTransformer.getTransformerFactory();
        }
        Transformer transformer = FACTORY.newTransformer();
        ApplicationModel.debug("Use the transformer " + transformer);
        return transformer;
    }
}

