/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.xml.refactor.elements;

import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.framework.xml.refactor.elements.AbstractRefactor;
import com.japisoft.framework.xml.refactor.elements.RefactorAction;
import com.japisoft.framework.xml.refactor.ui.RefactorTable;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NamespaceRefactor
extends AbstractRefactor {
    public static String[] ACTIONS = new String[]{"(V1) RENAME TO (V2)", "DELETE (V1)"};

    public NamespaceRefactor() {
        super(ANY);
    }

    public String[] getActions() {
        return ACTIONS;
    }

    public String getName() {
        return "Namespace";
    }

    protected Node refactorIt(Node node, RefactorAction refactorAction) {
        if ("(V1) RENAME TO (V2)".equals(refactorAction.getAction())) {
            if (node.getNodeType() == 2 && (node.getNodeName().startsWith("xmlns:") || node.getNodeName().equals("xmlns")) && refactorAction.matchOldValue(node.getNodeValue()) && !refactorAction.isNewValueEmpty()) {
                node.setNodeValue(refactorAction.getNewValue());
            }
        } else if ("DELETE (V1)".equals(refactorAction.getAction())) {
            NamedNodeMap namedNodeMap;
            if (node.getNodeType() == 2 && node.getNodeName().equals("xmlns") && refactorAction.matchOldValue(node.getNodeValue())) {
                return null;
            }
            if (node.getNodeType() == 1 && (namedNodeMap = node.getAttributes()) != null) {
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    Node node2 = namedNodeMap.item(i);
                    if (!node2.getNodeName().startsWith("xmlns:") || !refactorAction.matchOldValue(node2.getNodeValue())) continue;
                    ((Element)node).setAttribute(node2.getNodeName(), null);
                    namedNodeMap.removeNamedItem(node2.getNodeName());
                    int n = node2.getNodeName().indexOf(":");
                    String string = node2.getNodeName().substring(n + 1);
                    if (string.equals(node.getPrefix())) {
                        node.setPrefix(null);
                    }
                    Element element = (Element)node;
                    NodeList nodeList = element.getElementsByTagName("*");
                    for (int j = 0; j < nodeList.getLength(); ++j) {
                        Node node3 = nodeList.item(j);
                        if (string.equals(node3.getPrefix())) {
                            node3.setPrefix(null);
                        }
                        this.cleanAttributesWithPrefix(node3, string);
                    }
                }
            }
        }
        return node;
    }

    private void cleanAttributesWithPrefix(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (!node2.getNodeName().startsWith(string + ":")) continue;
            String string2 = node2.getNodeValue();
            namedNodeMap.removeNamedItem(node2.getNodeName());
            ((Element)node).setAttribute(node2.getNodeName().substring(string.length() + 1), string2);
        }
    }

    public void initTable(RefactorTable refactorTable, SimpleNode simpleNode) {
        if (simpleNode.hasAttribute("xmlns")) {
            refactorTable.init(0, simpleNode.getAttribute("xmlns"));
        }
        if (simpleNode.getNameSpaceURI() != null) {
            refactorTable.init(0, simpleNode.getNameSpaceURI());
        }
    }
}

