/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.editor;

import com.japisoft.xmlpad.SharedProperties;
import com.japisoft.xmlpad.editor.XMLEditor;
import java.awt.Color;

final class LineElement {
    static final LineElement BLANKELEMENT = new LineElement(" ", 7);
    static final LineElement TAG_MARKER = new LineElement(5);
    public String content;
    public int type;
    public int previousType;
    public int nextType;
    public int majorLineElement = 0;

    public LineElement(String string, int n) {
        this.content = string;
        this.type = n;
    }

    public LineElement(int n) {
        this(null, n);
    }

    boolean hasContent() {
        return this.content != null;
    }

    public String toString() {
        return "{" + this.content + "," + this.type + "}";
    }

    static Color getColor(XMLEditor xMLEditor, boolean bl, boolean bl2, int n, int n2, int n3) {
        if (xMLEditor.getXMLContainer().getDocumentIntegrity().isProtectTag()) {
            if (n == 7) {
                return Color.BLUE;
            }
            if (n == 5) {
                return Color.DARK_GRAY;
            }
            return Color.GRAY;
        }
        switch (n) {
            case 7: {
                return xMLEditor.getColorForText();
            }
            case 2: {
                return xMLEditor.getColorForDeclaration();
            }
            case 3: {
                return xMLEditor.getColorForDocType();
            }
            case 30: {
                return xMLEditor.getColorForDocTypeStart();
            }
            case 31: {
                return xMLEditor.getColorForDocTypeEnd();
            }
            case 33: {
                return xMLEditor.getColorForDocTypeBackground();
            }
            case 4: {
                return xMLEditor.getColorForLiteral();
            }
            case 21: {
                if (n2 >= xMLEditor.getSelectionStart() && n3 <= xMLEditor.getSelectionEnd()) {
                    return xMLEditor.getSelectionColor();
                }
                return xMLEditor.getColorForTagBackground();
            }
            case 36: {
                return xMLEditor.getColorForDeclarationStart();
            }
            case 37: {
                return xMLEditor.getColorForDeclarationEnd();
            }
            case 22: {
                if (n2 >= xMLEditor.getSelectionStart() && n3 <= xMLEditor.getSelectionEnd()) {
                    return xMLEditor.getSelectionColor();
                }
                return xMLEditor.getColorForDeclarationBackground();
            }
            case 5: {
                return xMLEditor.getColorForTag();
            }
            case 11: {
                return xMLEditor.getColorForTagEnd();
            }
            case 8: {
                return xMLEditor.getColorForAttribute();
            }
            case 9: 
            case 20: {
                if (!SharedProperties.FULL_TEXT_VIEW) {
                    if (n2 >= xMLEditor.getSelectionStart() && n3 <= xMLEditor.getSelectionEnd()) {
                        return xMLEditor.getSelectedTextColor();
                    }
                    if (bl) {
                        if (xMLEditor.getColorForLineError() != null) {
                            return xMLEditor.getColorForLineError();
                        }
                    } else if (bl2 && xMLEditor.getColorForLineSelection() != null) {
                        return xMLEditor.getColorForLineSelection();
                    }
                }
                return xMLEditor.getColorForTagDelimiter();
            }
            case 10: {
                return xMLEditor.getColorForAttributeSeparator();
            }
            case 18: {
                return xMLEditor.getColorForLiteral();
            }
            case 1: 
            case 43: {
                return xMLEditor.getColorForComment();
            }
            case 26: {
                return xMLEditor.getColorForCommentEnd();
            }
            case 25: {
                return xMLEditor.getColorForCommentStart();
            }
            case 24: {
                return xMLEditor.getColorCommentBackground();
            }
            case 12: {
                return xMLEditor.getColorForNameSpace();
            }
            case 13: {
                return xMLEditor.getColorForTagUnderline();
            }
            case 0: {
                return xMLEditor.getColorForEntity();
            }
            case 23: {
                if (n2 >= xMLEditor.getSelectionStart() && n3 <= xMLEditor.getSelectionEnd()) {
                    return xMLEditor.getSelectionColor();
                }
                return xMLEditor.getColorForEntityBackground();
            }
            case 14: {
                return xMLEditor.getColorForCDATA();
            }
            case 27: {
                return xMLEditor.getColorForCDATAStart();
            }
            case 28: {
                return xMLEditor.getColorForCDATAEnd();
            }
            case 32: {
                return xMLEditor.getColorForCDATABackground();
            }
            case 6: {
                return xMLEditor.getColorForInvalid();
            }
            case 16: {
                return xMLEditor.getColorForDTDAttribute();
            }
            case 15: {
                return xMLEditor.getColorForDTDElement();
            }
            case 17: 
            case 42: {
                return xMLEditor.getColorForDTDEntity();
            }
            case 19: {
                return xMLEditor.getColorForDTDNotation();
            }
            case 34: {
                return xMLEditor.getColorForLineSelection();
            }
        }
        return xMLEditor.getColorForText();
    }
}

