/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.helper.handler.relaxng;

import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.fastparser.walker.TreeWalker;
import com.japisoft.xmlpad.helper.handler.relaxng.RelaxNGToSchemaNode;
import com.japisoft.xmlpad.helper.handler.schema.AbstractTagHandler;
import com.japisoft.xmlpad.helper.model.SchemaNodable;
import com.japisoft.xmlpad.helper.model.SchemaNode;
import com.japisoft.xmlpad.helper.model.TagDescriptor;
import java.util.Enumeration;

public class RelaxNGTagHelperHandler
extends AbstractTagHandler
implements SchemaNodable {
    private SimpleNode root;
    private SchemaNode schemaNode = null;

    public RelaxNGTagHelperHandler(SimpleNode simpleNode) {
        this.root = simpleNode;
    }

    public void dispose() {
        super.dispose();
        this.root = null;
    }

    public TagDescriptor getTag(SimpleNode simpleNode) {
        SimpleNode simpleNode2 = this.getXMLElementByName(simpleNode.getContent());
        if (simpleNode2 != null) {
            RelaxNGToSchemaNode relaxNGToSchemaNode = new RelaxNGToSchemaNode();
            TagDescriptor tagDescriptor = new TagDescriptor(simpleNode.getContent(), false);
            relaxNGToSchemaNode.processContentAndAttributes(tagDescriptor, simpleNode2);
            return tagDescriptor;
        }
        return null;
    }

    protected void notifyLocation() {
        this.schemaNode = null;
        if (this.currentDocumentNode == null) {
            this.schemaNode = new RelaxNGToSchemaNode().getSchemaNode(this.root);
        } else {
            SimpleNode simpleNode = this.getXMLElementByName(this.currentDocumentNode.getContent());
            if (simpleNode != null) {
                this.schemaNode = new RelaxNGToSchemaNode().getSchemaNode(simpleNode);
            }
        }
    }

    private SimpleNode getXMLElementByName(String string) {
        TreeWalker treeWalker = new TreeWalker(this.root);
        Enumeration enumeration = treeWalker.getTagNodeByName("element", true);
        while (enumeration.hasMoreElements()) {
            SimpleNode simpleNode = (SimpleNode)enumeration.nextElement();
            String string2 = RelaxNGToSchemaNode.getName(simpleNode);
            if (!string.equals(string2)) continue;
            return simpleNode;
        }
        return null;
    }

    public SchemaNode getSchemaNode() {
        return this.schemaNode;
    }

    public SchemaNode getSecondarySchemaNode() {
        return null;
    }
}

