/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.helper.model;

import com.japisoft.xmlpad.editor.XMLDocument;
import com.japisoft.xmlpad.helper.model.CommonPopup;
import com.japisoft.xmlpad.helper.model.TagDescriptor;
import javax.swing.JMenuItem;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class TagPopup
extends CommonPopup {
    protected TagDescriptor[] tags;
    private int offset;
    private Document doc;
    protected String defaultInsertion = "<";

    public TagPopup(TagDescriptor[] tagDescriptorArray, int n, Document document) {
        super("Elements");
        this.tags = tagDescriptorArray;
        this.offset = n;
        this.doc = document;
        this.buildit();
    }

    protected void buildit() {
        for (int i = 0; i < this.tags.length; ++i) {
            this.add(this.buildMenuItem(this.tags[i]));
        }
    }

    protected JMenuItem buildMenuItem(TagDescriptor tagDescriptor) {
        JMenuItem jMenuItem = this.getMenuItem();
        jMenuItem.setText(tagDescriptor.getName());
        return jMenuItem;
    }

    protected void notifySelection(int n) {
        if (n >= 1) {
            TagDescriptor tagDescriptor = this.tags[n];
            try {
                String string = tagDescriptor.getBuiltTag();
                this.doc.insertString(this.offset, string, null);
                if (!tagDescriptor.isRaw()) {
                    int n2 = string.indexOf("\"");
                    if (n2 > -1) {
                        ((XMLDocument)this.doc).getCurrentEditor().setCaretPosition(this.offset + n2 + 1);
                    } else {
                        n2 = string.indexOf("><");
                        if (n2 > -1) {
                            ((XMLDocument)this.doc).getCurrentEditor().setCaretPosition(this.offset + n2 + 1);
                        }
                    }
                } else {
                    int n3 = string.indexOf(" ");
                    if (n3 > -1) {
                        ((XMLDocument)this.doc).getCurrentEditor().setCaretPosition(this.offset + n3 + 1);
                    }
                }
            }
            catch (BadLocationException badLocationException) {}
        } else if (n == 0) {
            boolean bl = ((XMLDocument)this.doc).isSyntaxPopup();
            ((XMLDocument)this.doc).setSyntaxPopup(false);
            try {
                this.doc.insertString(this.offset, this.defaultInsertion, null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            ((XMLDocument)this.doc).setSyntaxPopup(bl);
        }
    }
}

