/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.tree;

import com.japisoft.fastparser.swing.SwingNode;
import com.japisoft.fastparser.tools.XMLToolkit;
import com.japisoft.xmlpad.Debug;
import com.japisoft.xmlpad.error.ErrorListener;
import java.util.ArrayList;
import javax.swing.JTree;

class TreeErrorListener
implements ErrorListener {
    private JTree tree;
    private ArrayList savedErrors = null;

    TreeErrorListener(JTree jTree) {
        if (jTree == null) {
            throw new RuntimeException("No tree found. Illegal usage for class TreeErrorListener");
        }
        this.tree = jTree;
    }

    public void initErrorProcessing() {
    }

    public void stopErrorProcessing() {
        if (this.tree.getModel() == null || this.tree.getModel().getRoot() == null) {
            this.savedErrors = null;
            return;
        }
        if (this.savedErrors != null) {
            for (int i = 0; i < this.savedErrors.size(); i += 2) {
                int n = (Integer)this.savedErrors.get(i);
                String string = (String)this.savedErrors.get(i + 1);
                this.addErrorOnTheTree(n, string);
            }
            this.savedErrors = null;
            this.tree.repaint();
        }
    }

    public void notifyError(Object object, boolean bl, String string, int n, int n2, int n3, String string2, boolean bl2) {
        if (bl) {
            if (this.savedErrors == null) {
                this.savedErrors = new ArrayList();
            }
            this.savedErrors.add(new Integer(n3));
            this.savedErrors.add(string2);
        }
    }

    public void notifyNoError(boolean bl) {
        this.savedErrors = null;
    }

    private void addErrorOnTheTree(int n, String string) {
        SwingNode swingNode = (SwingNode)this.tree.getModel().getRoot();
        if (swingNode != null) {
            try {
                for (SwingNode swingNode2 = (SwingNode)XMLToolkit.getNodeForOffset(swingNode.getDocument(), n); swingNode2 != null; swingNode2 = (SwingNode)swingNode2.getSimpleParent()) {
                    swingNode2.errorMessage = swingNode2.errorMessage == null ? string : "\n" + string;
                }
            }
            catch (RuntimeException runtimeException) {
                Debug.debug(runtimeException);
            }
        }
    }
}

