/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xquery;

import com.japisoft.editix.ui.xslt.Factory;
import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.framework.ui.text.FileTextField;
import com.japisoft.xmlpad.LocationEvent;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.look.LookManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class XMLDataSourcePanel
extends JPanel
implements TreeSelectionListener {
    JLabel lblPath = new JLabel();
    FileTextField file = null;
    XMLContainer xmlContainer = null;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    Factory factory = null;
    JTree tree = new JTree();
    JTabbedPane tp = new JTabbedPane(3);

    public XMLDataSourcePanel(Factory factory) {
        this.factory = factory;
        this.initUI();
    }

    private void initUI() {
        this.file = new FileTextField(null, null, new String[]{"xml"}, this.factory.getPathBuilder());
        this.lblPath.setText("Path :");
        this.setLayout(this.gridBagLayout1);
        this.file.setText("");
        this.xmlContainer = this.factory.buildNewContainer(null).getMainContainer();
        this.xmlContainer.setAutoResetAction(false);
        this.xmlContainer.setPopupAvailable(false);
        this.xmlContainer.setTreeAvailable(false);
        this.xmlContainer.setEditableDocumentMode(false);
        this.xmlContainer.getUIAccessibility().setEnableDragNDropForRoot(true);
        this.xmlContainer.getDocumentInfo().setTreeAvailable(false);
        this.xmlContainer.setAutoNewDocument(false);
        LookManager.getCurrentLook().install(this.xmlContainer, this.tree);
        this.xmlContainer.setTreeDelegate(this.tree);
        this.tp.addTab("Tree", new JScrollPane(this.tree));
        this.tp.addTab("Text", this.xmlContainer.getView());
        this.tp.setSelectedIndex(0);
        this.add((Component)this.lblPath, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 6, 0, 9), 0, 0));
        this.add((Component)this.file, new GridBagConstraints(1, 0, 5, 1, 1.0, 0.0, 17, 2, new Insets(4, 0, 0, 5), 0, 0));
        this.add((Component)this.tp, new GridBagConstraints(0, 2, 6, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        SimpleNode simpleNode = (SimpleNode)treeSelectionEvent.getPath().getLastPathComponent();
        this.xmlContainer.notifyLocationListener(new LocationEvent(this.xmlContainer, simpleNode));
    }

    public void dispose() {
        this.xmlContainer.dispose();
    }

    public void setAutoDisposeMode(boolean bl) {
        this.xmlContainer.setAutoDisposeMode(bl);
    }

    public void addNotify() {
        super.addNotify();
        this.tree.addTreeSelectionListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.tree.removeTreeSelectionListener(this);
    }

    public void showSourceLine(int n) {
        this.tp.setSelectedIndex(1);
        this.xmlContainer.getEditor().highlightLine(n);
    }
}

