/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.http;

import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.UserAuthenticationData;
import org.apache.commons.vfs.UserAuthenticator;
import org.apache.commons.vfs.provider.http.HttpFileSystemConfigBuilder;
import org.apache.commons.vfs.util.UserAuthenticatorUtils;

public class HttpClientFactory {
    public static HttpClient createConnection(String string, String string2, int n, String string3, String string4, FileSystemOptions fileSystemOptions) throws FileSystemException {
        HttpClient httpClient;
        try {
            String string5;
            httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
            HostConfiguration hostConfiguration = new HostConfiguration();
            hostConfiguration.setHost(string2, n, string);
            if (fileSystemOptions != null) {
                Object object;
                UserAuthenticator userAuthenticator;
                string5 = HttpFileSystemConfigBuilder.getInstance().getProxyHost(fileSystemOptions);
                int n2 = HttpFileSystemConfigBuilder.getInstance().getProxyPort(fileSystemOptions);
                if (string5 != null && n2 > 0) {
                    hostConfiguration.setProxy(string5, n2);
                }
                if ((userAuthenticator = HttpFileSystemConfigBuilder.getInstance().getProxyAuthenticator(fileSystemOptions)) != null && (object = UserAuthenticatorUtils.authenticate(userAuthenticator, new UserAuthenticationData.Type[]{UserAuthenticationData.USERNAME, UserAuthenticationData.PASSWORD})) != null) {
                    UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(UserAuthenticatorUtils.toString(UserAuthenticatorUtils.getData((UserAuthenticationData)object, UserAuthenticationData.USERNAME, null)), UserAuthenticatorUtils.toString(UserAuthenticatorUtils.getData((UserAuthenticationData)object, UserAuthenticationData.PASSWORD, null)));
                    httpClient.getState().setProxyCredentials(null, string5, (Credentials)usernamePasswordCredentials);
                }
                if ((object = HttpFileSystemConfigBuilder.getInstance().getCookies(fileSystemOptions)) != null) {
                    httpClient.getState().addCookies(object);
                }
            }
            httpClient.setHostConfiguration(hostConfiguration);
            if (string3 != null) {
                string5 = new UsernamePasswordCredentials(string3, string4);
                httpClient.getState().setCredentials(null, string2, (Credentials)string5);
            }
            httpClient.executeMethod((HttpMethod)new HeadMethod());
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider.http/connect.error", new Object[]{string2}, (Throwable)exception);
        }
        return httpClient;
    }
}

