/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.local;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.provider.AbstractRandomAccessContent;
import org.apache.commons.vfs.util.RandomAccessMode;

class LocalFileRandomAccessContent
extends AbstractRandomAccessContent {
    private final RandomAccessFile raf;
    private final InputStream rafis;

    LocalFileRandomAccessContent(File file, RandomAccessMode randomAccessMode) throws FileSystemException {
        super(randomAccessMode);
        StringBuffer stringBuffer = new StringBuffer(2);
        if (randomAccessMode.requestRead()) {
            stringBuffer.append('r');
        }
        if (randomAccessMode.requestWrite()) {
            stringBuffer.append('w');
        }
        try {
            this.raf = new RandomAccessFile(file, stringBuffer.toString());
            this.rafis = new InputStream(){

                public int read() throws IOException {
                    try {
                        return LocalFileRandomAccessContent.this.raf.readByte();
                    }
                    catch (EOFException eOFException) {
                        return -1;
                    }
                }

                public long skip(long l) throws IOException {
                    LocalFileRandomAccessContent.this.raf.seek(LocalFileRandomAccessContent.this.raf.getFilePointer() + l);
                    return l;
                }

                public void close() throws IOException {
                    LocalFileRandomAccessContent.this.raf.close();
                }

                public int read(byte[] byArray) throws IOException {
                    return LocalFileRandomAccessContent.this.raf.read(byArray);
                }

                public int read(byte[] byArray, int n, int n2) throws IOException {
                    return LocalFileRandomAccessContent.this.raf.read(byArray, n, n2);
                }

                public int available() throws IOException {
                    long l = LocalFileRandomAccessContent.this.raf.length() - LocalFileRandomAccessContent.this.raf.getFilePointer();
                    if (l > Integer.MAX_VALUE) {
                        return Integer.MAX_VALUE;
                    }
                    return (int)l;
                }
            };
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileSystemException("vfs.provider/random-access-open-failed.error", file);
        }
    }

    public long getFilePointer() throws IOException {
        return this.raf.getFilePointer();
    }

    public void seek(long l) throws IOException {
        this.raf.seek(l);
    }

    public long length() throws IOException {
        return this.raf.length();
    }

    public void close() throws IOException {
        this.raf.close();
    }

    public byte readByte() throws IOException {
        return this.raf.readByte();
    }

    public char readChar() throws IOException {
        return this.raf.readChar();
    }

    public double readDouble() throws IOException {
        return this.raf.readDouble();
    }

    public float readFloat() throws IOException {
        return this.raf.readFloat();
    }

    public int readInt() throws IOException {
        return this.raf.readInt();
    }

    public int readUnsignedByte() throws IOException {
        return this.raf.readUnsignedByte();
    }

    public int readUnsignedShort() throws IOException {
        return this.raf.readUnsignedShort();
    }

    public long readLong() throws IOException {
        return this.raf.readLong();
    }

    public short readShort() throws IOException {
        return this.raf.readShort();
    }

    public boolean readBoolean() throws IOException {
        return this.raf.readBoolean();
    }

    public int skipBytes(int n) throws IOException {
        return this.raf.skipBytes(n);
    }

    public void readFully(byte[] byArray) throws IOException {
        this.raf.readFully(byArray);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.raf.readFully(byArray, n, n2);
    }

    public String readUTF() throws IOException {
        return this.raf.readUTF();
    }

    public void writeDouble(double d) throws IOException {
        this.raf.writeDouble(d);
    }

    public void writeFloat(float f) throws IOException {
        this.raf.writeFloat(f);
    }

    public void write(int n) throws IOException {
        this.raf.write(n);
    }

    public void writeByte(int n) throws IOException {
        this.raf.writeByte(n);
    }

    public void writeChar(int n) throws IOException {
        this.raf.writeChar(n);
    }

    public void writeInt(int n) throws IOException {
        this.raf.writeInt(n);
    }

    public void writeShort(int n) throws IOException {
        this.raf.writeShort(n);
    }

    public void writeLong(long l) throws IOException {
        this.raf.writeLong(l);
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.raf.writeBoolean(bl);
    }

    public void write(byte[] byArray) throws IOException {
        this.raf.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.raf.write(byArray, n, n2);
    }

    public void writeBytes(String string) throws IOException {
        this.raf.writeBytes(string);
    }

    public void writeChars(String string) throws IOException {
        this.raf.writeChars(string);
    }

    public void writeUTF(String string) throws IOException {
        this.raf.writeUTF(string);
    }

    public InputStream getInputStream() throws IOException {
        return this.rafis;
    }
}

