/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.dom;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jaxen.DefaultNavigator;
import org.jaxen.FunctionCallException;
import org.jaxen.JaxenConstants;
import org.jaxen.Navigator;
import org.jaxen.XPath;
import org.jaxen.dom.DOMXPath;
import org.jaxen.dom.NamespaceNode;
import org.jaxen.saxpath.SAXPathException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.SAXException;

public class DocumentNavigator
extends DefaultNavigator {
    private static final DocumentNavigator SINGLETON = new DocumentNavigator();

    public static Navigator getInstance() {
        return SINGLETON;
    }

    public Iterator getChildAxisIterator(Object object) {
        return new NodeIterator((Node)object){

            protected Node getFirstNode(Node node) {
                return node.getFirstChild();
            }

            protected Node getNextNode(Node node) {
                return node.getNextSibling();
            }
        };
    }

    public Iterator getParentAxisIterator(Object object) {
        Node node = (Node)object;
        if (node.getNodeType() == 2) {
            return new NodeIterator(node){

                protected Node getFirstNode(Node node) {
                    return ((Attr)node).getOwnerElement();
                }

                protected Node getNextNode(Node node) {
                    return null;
                }
            };
        }
        return new NodeIterator(node){

            protected Node getFirstNode(Node node) {
                return node.getParentNode();
            }

            protected Node getNextNode(Node node) {
                return null;
            }
        };
    }

    public Object getParentNode(Object object) {
        Node node = (Node)object;
        if (node.getNodeType() == 2) {
            return ((Attr)node).getOwnerElement();
        }
        return node.getParentNode();
    }

    public Iterator getFollowingSiblingAxisIterator(Object object) {
        return new NodeIterator((Node)object){

            protected Node getFirstNode(Node node) {
                return this.getNextNode(node);
            }

            protected Node getNextNode(Node node) {
                return node.getNextSibling();
            }
        };
    }

    public Iterator getPrecedingSiblingAxisIterator(Object object) {
        return new NodeIterator((Node)object){

            protected Node getFirstNode(Node node) {
                return this.getNextNode(node);
            }

            protected Node getNextNode(Node node) {
                return node.getPreviousSibling();
            }
        };
    }

    public Iterator getFollowingAxisIterator(Object object) {
        return new NodeIterator((Node)object){

            protected Node getFirstNode(Node node) {
                if (node == null) {
                    return null;
                }
                Node node2 = node.getNextSibling();
                if (node2 == null) {
                    return this.getFirstNode(node.getParentNode());
                }
                return node2;
            }

            protected Node getNextNode(Node node) {
                if (node == null) {
                    return null;
                }
                Node node2 = node.getFirstChild();
                if (node2 == null) {
                    node2 = node.getNextSibling();
                }
                if (node2 == null) {
                    return this.getFirstNode(node.getParentNode());
                }
                return node2;
            }
        };
    }

    public Iterator getAttributeAxisIterator(Object object) {
        if (this.isElement(object)) {
            return new AttributeIterator((Node)object);
        }
        return JaxenConstants.EMPTY_ITERATOR;
    }

    public Iterator getNamespaceAxisIterator(Object object) {
        if (this.isElement(object)) {
            Node node;
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            for (node = (Node)object; node != null; node = node.getParentNode()) {
                String string;
                Object object2;
                if (node.hasAttributes()) {
                    object2 = node.getAttributes();
                    int n = object2.getLength();
                    for (int i = 0; i < n; ++i) {
                        Object object3;
                        Object object4;
                        Attr attr = (Attr)object2.item(i);
                        String string2 = attr.getNamespaceURI();
                        if ("http://www.w3.org/2000/xmlns/".equals(string2)) {
                            object4 = new NamespaceNode((Node)object, attr);
                            object3 = ((NamespaceNode)object4).getNodeName();
                            if (hashMap.containsKey(object3)) continue;
                            hashMap.put(object3, object4);
                            continue;
                        }
                        if (string2 == null) continue;
                        object4 = attr.getPrefix();
                        object3 = new NamespaceNode((Node)object, (String)object4, string2);
                        if (hashMap.containsKey(object4)) continue;
                        hashMap.put(object4, object3);
                    }
                }
                if ((object2 = node.getNamespaceURI()) == null || "".equals(object2) || hashMap.containsKey(string = node.getPrefix())) continue;
                NamespaceNode namespaceNode = new NamespaceNode((Node)object, string, (String)object2);
                hashMap.put(string, namespaceNode);
            }
            hashMap.put("xml", new NamespaceNode((Node)object, "xml", "http://www.w3.org/XML/1998/namespace"));
            node = (NamespaceNode)hashMap.get("");
            if (node != null && ((NamespaceNode)node).getNodeValue().length() == 0) {
                hashMap.remove("");
            }
            return hashMap.values().iterator();
        }
        return JaxenConstants.EMPTY_ITERATOR;
    }

    public XPath parseXPath(String string) throws SAXPathException {
        return new DOMXPath(string);
    }

    public Object getDocumentNode(Object object) {
        if (this.isDocument(object)) {
            return object;
        }
        return ((Node)object).getOwnerDocument();
    }

    public String getElementNamespaceUri(Object object) {
        try {
            Node node = (Node)object;
            if (node.getNodeType() == 1) {
                return node.getNamespaceURI();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    public String getElementName(Object object) {
        if (this.isElement(object)) {
            String string = ((Node)object).getLocalName();
            if (string == null) {
                string = ((Node)object).getNodeName();
            }
            return string;
        }
        return null;
    }

    public String getElementQName(Object object) {
        try {
            Node node = (Node)object;
            if (node.getNodeType() == 1) {
                return node.getNodeName();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    public String getAttributeNamespaceUri(Object object) {
        try {
            Node node = (Node)object;
            if (node.getNodeType() == 2) {
                return node.getNamespaceURI();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    public String getAttributeName(Object object) {
        if (this.isAttribute(object)) {
            String string = ((Node)object).getLocalName();
            if (string == null) {
                string = ((Node)object).getNodeName();
            }
            return string;
        }
        return null;
    }

    public String getAttributeQName(Object object) {
        try {
            Node node = (Node)object;
            if (node.getNodeType() == 2) {
                return node.getNodeName();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    public boolean isDocument(Object object) {
        return object instanceof Node && ((Node)object).getNodeType() == 9;
    }

    public boolean isNamespace(Object object) {
        return object instanceof NamespaceNode;
    }

    public boolean isElement(Object object) {
        return object instanceof Node && ((Node)object).getNodeType() == 1;
    }

    public boolean isAttribute(Object object) {
        return object instanceof Node && ((Node)object).getNodeType() == 2 && !"http://www.w3.org/2000/xmlns/".equals(((Node)object).getNamespaceURI());
    }

    public boolean isComment(Object object) {
        return object instanceof Node && ((Node)object).getNodeType() == 8;
    }

    public boolean isText(Object object) {
        if (object instanceof Node) {
            switch (((Node)object).getNodeType()) {
                case 3: 
                case 4: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean isProcessingInstruction(Object object) {
        return object instanceof Node && ((Node)object).getNodeType() == 7;
    }

    public String getElementStringValue(Object object) {
        if (this.isElement(object)) {
            return this.getStringValue((Node)object, new StringBuffer()).toString();
        }
        return null;
    }

    private StringBuffer getStringValue(Node node, StringBuffer stringBuffer) {
        if (this.isText(node)) {
            stringBuffer.append(node.getNodeValue());
        } else {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                this.getStringValue(nodeList.item(i), stringBuffer);
            }
        }
        return stringBuffer;
    }

    public String getAttributeStringValue(Object object) {
        if (this.isAttribute(object)) {
            return ((Node)object).getNodeValue();
        }
        return null;
    }

    public String getTextStringValue(Object object) {
        if (this.isText(object)) {
            return ((Node)object).getNodeValue();
        }
        return null;
    }

    public String getCommentStringValue(Object object) {
        if (this.isComment(object)) {
            return ((Node)object).getNodeValue();
        }
        return null;
    }

    public String getNamespaceStringValue(Object object) {
        if (this.isNamespace(object)) {
            return ((NamespaceNode)object).getNodeValue();
        }
        return null;
    }

    public String getNamespacePrefix(Object object) {
        if (this.isNamespace(object)) {
            return ((NamespaceNode)object).getLocalName();
        }
        return null;
    }

    public String translateNamespacePrefixToUri(String string, Object object) {
        Iterator iterator = this.getNamespaceAxisIterator(object);
        while (iterator.hasNext()) {
            NamespaceNode namespaceNode = (NamespaceNode)iterator.next();
            if (!string.equals(namespaceNode.getNodeName())) continue;
            return namespaceNode.getNodeValue();
        }
        return null;
    }

    public Object getDocument(String string) throws FunctionCallException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(string);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new FunctionCallException("JAXP setup error in document() function: " + parserConfigurationException.getMessage(), parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new FunctionCallException("XML error in document() function: " + sAXException.getMessage(), sAXException);
        }
        catch (IOException iOException) {
            throw new FunctionCallException("I/O error in document() function: " + iOException.getMessage(), iOException);
        }
    }

    public String getProcessingInstructionTarget(Object object) {
        if (this.isProcessingInstruction(object)) {
            ProcessingInstruction processingInstruction = (ProcessingInstruction)object;
            return processingInstruction.getTarget();
        }
        throw new ClassCastException(object + " is not a processing instruction");
    }

    public String getProcessingInstructionData(Object object) {
        if (this.isProcessingInstruction(object)) {
            ProcessingInstruction processingInstruction = (ProcessingInstruction)object;
            return processingInstruction.getData();
        }
        throw new ClassCastException(object + " is not a processing instruction");
    }

    public Object getElementById(Object object, String string) {
        Document document = (Document)this.getDocumentNode(object);
        if (document != null) {
            return document.getElementById(string);
        }
        return null;
    }

    private static class AttributeIterator
    implements Iterator {
        private NamedNodeMap map;
        private int pos;
        private int lastAttribute = -1;

        AttributeIterator(Node node) {
            this.map = node.getAttributes();
            this.pos = 0;
            for (int i = this.map.getLength() - 1; i >= 0; --i) {
                Node node2 = this.map.item(i);
                if ("http://www.w3.org/2000/xmlns/".equals(node2.getNamespaceURI())) continue;
                this.lastAttribute = i;
                break;
            }
        }

        public boolean hasNext() {
            return this.pos <= this.lastAttribute;
        }

        public Object next() {
            Node node;
            if ((node = this.map.item(this.pos++)) == null) {
                throw new NoSuchElementException();
            }
            if ("http://www.w3.org/2000/xmlns/".equals(node.getNamespaceURI())) {
                return this.next();
            }
            return node;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    abstract class NodeIterator
    implements Iterator {
        private Node node;

        public NodeIterator(Node node) {
            this.node = this.getFirstNode(node);
            while (!this.isXPathNode(this.node)) {
                this.node = this.getNextNode(this.node);
            }
        }

        public boolean hasNext() {
            return this.node != null;
        }

        public Object next() {
            if (this.node == null) {
                throw new NoSuchElementException();
            }
            Node node = this.node;
            this.node = this.getNextNode(this.node);
            while (!this.isXPathNode(this.node)) {
                this.node = this.getNextNode(this.node);
            }
            return node;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected abstract Node getFirstNode(Node var1);

        protected abstract Node getNextNode(Node var1);

        private boolean isXPathNode(Node node) {
            if (node == null) {
                return true;
            }
            switch (node.getNodeType()) {
                case 5: 
                case 6: 
                case 10: 
                case 11: 
                case 12: {
                    return false;
                }
            }
            return true;
        }
    }
}

