/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.core.filer;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.core.DBException;
import org.apache.xindice.core.data.Key;
import org.apache.xindice.core.data.Record;
import org.apache.xindice.core.data.RecordSet;
import org.apache.xindice.core.data.Value;
import org.apache.xindice.core.filer.BTree;
import org.apache.xindice.core.filer.BTreeCallback;
import org.apache.xindice.core.filer.BTreeNotFoundException;
import org.apache.xindice.core.filer.Filer;
import org.apache.xindice.core.filer.FilerException;
import org.apache.xindice.core.filer.Paged;

public class BTreeFiler
extends BTree
implements Filer {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xindice$core$filer$BTreeFiler == null ? (class$org$apache$xindice$core$filer$BTreeFiler = BTreeFiler.class$("org.apache.xindice.core.filer.BTreeFiler")) : class$org$apache$xindice$core$filer$BTreeFiler));
    protected static final byte RECORD = 20;
    private BTreeFilerHeader fileHeader = (BTreeFilerHeader)this.getFileHeader();
    static /* synthetic */ Class class$org$apache$xindice$core$filer$BTreeFiler;

    public void setLocation(File root, String location) {
        this.setFile(new File(root, location + ".tbl"));
    }

    public String getName() {
        return "BTreeFiler";
    }

    public Record readRecord(Key key) throws DBException {
        if (key == null || key.getLength() == 0) {
            return null;
        }
        this.checkOpened();
        try {
            long pos = this.findValue(key);
            Paged.Page startPage = this.getPage(pos);
            Value v = this.readValue(startPage);
            BTreeFilerPageHeader sph = (BTreeFilerPageHeader)startPage.getPageHeader();
            HashMap<String, Long> meta = new HashMap<String, Long>(2, 1.5f);
            meta.put("created", new Long(sph.getCreated()));
            meta.put("modified", new Long(sph.getModified()));
            return new Record(key, v, meta);
        }
        catch (BTreeNotFoundException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Record '" + key + "' not found: " + e));
            }
        }
        catch (IOException e) {
            throw new FilerException(572, "Can't read record '" + key + "': " + e.getMessage(), e);
        }
        return null;
    }

    public boolean writeRecord(Key key, Value value) throws DBException {
        if (key == null || key.getLength() == 0) {
            throw new FilerException(571, "Invalid key: null or empty");
        }
        if (value == null) {
            throw new FilerException(571, "Invalid value: null");
        }
        this.checkOpened();
        try {
            long pos = this.addKey(key);
            Paged.Page p = this.getPage(pos);
            BTreeFilerPageHeader ph = (BTreeFilerPageHeader)p.getPageHeader();
            long t = System.currentTimeMillis();
            if (ph.getStatus() == 0) {
                ph.setCreated(t);
            }
            ph.setModified(t);
            ph.setStatus((byte)20);
            this.writeValue(p, value);
            this.flush();
        }
        catch (IOException e) {
            throw new FilerException(571, "Can't write record '" + key + "': " + e.getMessage(), e);
        }
        return true;
    }

    public boolean deleteRecord(Key key) throws DBException {
        if (key == null || key.getLength() == 0) {
            return false;
        }
        this.checkOpened();
        try {
            long pos = this.removeValue(key);
            Paged.Page p = this.getPage(pos);
            this.unlinkPages(p);
            this.fileHeader.decRecordCount();
            this.flush();
            return true;
        }
        catch (BTreeNotFoundException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Record '" + key + "' not found (" + e + ")"));
            }
        }
        catch (IOException e) {
            throw new FilerException(570, "Can't delete record '" + key + "': " + e.getMessage(), e);
        }
        return false;
    }

    public long getRecordCount() throws DBException {
        this.checkOpened();
        return this.fileHeader.getRecordCount();
    }

    public RecordSet getRecordSet() throws DBException {
        this.checkOpened();
        return new BTreeFilerRecordSet();
    }

    protected Paged.FileHeader createFileHeader() {
        return new BTreeFilerHeader();
    }

    protected Paged.PageHeader createPageHeader() {
        return new BTreeFilerPageHeader();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class BTreeFilerPageHeader
    extends BTree.BTreePageHeader {
        private long created;
        private long modified;

        public BTreeFilerPageHeader() {
        }

        public BTreeFilerPageHeader(DataInput dis) throws IOException {
            super(dis);
        }

        public synchronized void read(DataInput dis) throws IOException {
            super.read(dis);
            if (this.getStatus() == 0) {
                return;
            }
            this.created = dis.readLong();
            this.modified = dis.readLong();
        }

        public synchronized void write(DataOutput dos) throws IOException {
            super.write(dos);
            dos.writeLong(this.created);
            dos.writeLong(this.modified);
        }

        public synchronized void setRecordLen(int recordLen) {
            BTreeFiler.this.fileHeader.setTotalBytes(BTreeFiler.this.fileHeader.totalBytes - (long)this.getRecordLen() + (long)recordLen);
            super.setRecordLen(recordLen);
        }

        public synchronized void setCreated(long created) {
            this.created = created;
            this.setDirty();
        }

        public synchronized long getCreated() {
            return this.created;
        }

        public synchronized void setModified(long modified) {
            this.modified = modified;
            this.setDirty();
        }

        public synchronized long getModified() {
            return this.modified;
        }
    }

    private final class BTreeFilerHeader
    extends BTree.BTreeFileHeader {
        private long totalBytes;

        protected synchronized void read(RandomAccessFile raf) throws IOException {
            super.read(raf);
            this.totalBytes = raf.readLong();
        }

        protected synchronized void write(RandomAccessFile raf) throws IOException {
            super.write(raf);
            raf.writeLong(this.totalBytes);
        }

        public synchronized void setTotalBytes(long totalBytes) {
            this.totalBytes = totalBytes;
            this.setDirty();
        }

        public synchronized long getTotalBytes() {
            return this.totalBytes;
        }
    }

    private class BTreeFilerRecordSet
    implements RecordSet,
    BTreeCallback {
        private List keys = new ArrayList();
        private Iterator iter;

        public BTreeFilerRecordSet() throws DBException {
            try {
                BTreeFiler.this.query(null, this);
                this.iter = this.keys.iterator();
            }
            catch (IOException e) {
                throw new FilerException(70, "Error generating RecordSet", e);
            }
        }

        public synchronized boolean indexInfo(Value value, long pointer) {
            this.keys.add(new Key(value));
            return true;
        }

        public synchronized Key getNextKey() {
            return (Key)this.iter.next();
        }

        public synchronized Record getNextRecord() throws DBException {
            return BTreeFiler.this.readRecord((Key)this.iter.next());
        }

        public synchronized Value getNextValue() throws DBException {
            return this.getNextRecord().getValue();
        }

        public synchronized boolean hasMoreRecords() {
            return this.iter.hasNext();
        }
    }
}

