/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.tools.command;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Hashtable;
import org.apache.xindice.tools.command.Command;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

public class ExportTree
extends Command {
    public boolean execute(Hashtable table) throws Exception {
        Collection col = null;
        if (table.get("filePath").equals("")) {
            System.out.println("ERROR: Directory name and switch required");
            return false;
        }
        if (table.get("collection") == null) {
            System.out.println("ERROR : Collection name and switch required");
            return false;
        }
        File fp = new File((String)table.get("filePath"));
        System.out.println();
        if (table.get("collection") != null) {
            String parent = this.parentDir((String)table.get("collection"));
            File dir = new File(fp, parent);
            System.out.println("Creating directory " + dir.getPath());
            dir.mkdir();
            this.process(dir, table, col);
        }
        return true;
    }

    private String parentDir(String parent) {
        int idx = parent.lastIndexOf("/");
        if (idx != -1) {
            return parent.substring(idx + 1);
        }
        return parent;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean process(File directory, Hashtable table, Collection col) throws Exception {
        block15: {
            boolean bl;
            block13: {
                try {
                    String[] files;
                    String collection;
                    String[] list;
                    block14: {
                        list = null;
                        collection = (String)table.get("collection");
                        String colstring = this.normalizeCollectionURI((String)table.get("collection"), (String)table.get("local"));
                        col = DatabaseManager.getCollection((String)colstring);
                        if (col == null) {
                            System.out.println("ERROR : Collection not found!");
                            bl = false;
                            Object var15_9 = null;
                            if (col == null) return bl;
                            break block13;
                        }
                        files = null;
                        try {
                            files = col.listResources();
                        }
                        catch (XMLDBException e) {
                            if (e.errorCode == 1) break block14;
                            throw e;
                        }
                    }
                    if (files != null) {
                        System.out.println("Extracting " + files.length + " files from " + table.get("collection"));
                        int j = 0;
                        while (j < files.length) {
                            Object var13_18;
                            Resource res = col.getResource(files[j]);
                            Object content = res.getContent();
                            FileOutputStream output = new FileOutputStream(new File(directory, files[j]));
                            try {
                                if (content instanceof String) {
                                    output.write(((String)content).getBytes("utf-8"));
                                } else {
                                    output.write((byte[])content);
                                }
                                var13_18 = null;
                            }
                            catch (Throwable throwable) {
                                var13_18 = null;
                                output.close();
                                throw throwable;
                            }
                            output.close();
                            ++j;
                        }
                    }
                    list = col.listChildCollections();
                    int i = 0;
                    while (true) {
                        if (i >= list.length) {
                            break block15;
                        }
                        File file = new File(directory, list[i]);
                        System.out.println("Creating directory " + file.getPath());
                        file.mkdirs();
                        table.put("collection", collection + "/" + file.getName());
                        this.process(new File(directory + "//" + file.getName()), table, col);
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    Object var15_11 = null;
                    if (col == null) throw throwable;
                    col.close();
                    throw throwable;
                }
            }
            col.close();
            return bl;
        }
        Object var15_10 = null;
        if (col == null) return true;
        col.close();
        return true;
    }
}

