/*
 * Decompiled with CFR 0.152.
 */
package org.exist.memtree;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.exist.dom.NamedNodeMapImpl;
import org.exist.dom.NodeListImpl;
import org.exist.dom.QName;
import org.exist.dom.QNameable;
import org.exist.memtree.AttributeImpl;
import org.exist.memtree.DocumentImpl;
import org.exist.memtree.NamespaceNode;
import org.exist.memtree.NodeImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class ElementImpl
extends NodeImpl
implements Element,
QNameable {
    public ElementImpl(DocumentImpl doc, int nodeNumber) {
        super(doc, nodeNumber);
    }

    public String getTagName() {
        return this.getNodeName();
    }

    public QName getQName() {
        return (QName)this.document.namePool.get(this.document.nodeName[this.nodeNumber]);
    }

    public boolean hasChildNodes() {
        return this.nodeNumber + 1 < this.document.size && this.document.treeLevel[this.nodeNumber + 1] > this.document.treeLevel[this.nodeNumber];
    }

    public Node getFirstChild() {
        short level = this.document.treeLevel[this.nodeNumber];
        int nextNode = this.nodeNumber + 1;
        if (nextNode < this.document.size && this.document.treeLevel[nextNode] > level) {
            return this.document.getNode(nextNode);
        }
        return null;
    }

    public NodeList getChildNodes() {
        NodeListImpl nl = new NodeListImpl();
        int nextNode = this.document.getFirstChildFor(this.nodeNumber);
        while (nextNode > this.nodeNumber) {
            NodeImpl n = this.document.getNode(nextNode);
            nl.add(n);
            nextNode = this.document.next[nextNode];
        }
        return nl;
    }

    public int getChildCount() {
        return this.document.getChildCountFor(this.nodeNumber);
    }

    public String getNamespaceURI() {
        return this.getQName().getNamespaceURI();
    }

    public String getPrefix() {
        return this.getQName().getPrefix();
    }

    public String getLocalName() {
        return this.getQName().getLocalName();
    }

    public boolean hasAttributes() {
        return this.document.alpha[this.nodeNumber] > -1 || this.document.alphaLen[this.nodeNumber] > -1;
    }

    public String getAttribute(String name) {
        int ns;
        int attr = this.document.alpha[this.nodeNumber];
        if (-1 < attr) {
            while (attr < this.document.nextAttr && this.document.attrParent[attr] == this.nodeNumber) {
                QName attrQName = (QName)this.document.namePool.get(this.document.attrName[attr]);
                if (attrQName.getStringValue().equals(name)) {
                    return this.document.attrValue[attr];
                }
                ++attr;
            }
        }
        if (name.startsWith("xmlns:") && -1 < (ns = this.document.alphaLen[this.nodeNumber])) {
            while (ns < this.document.nextNamespace && this.document.namespaceParent[ns] == this.nodeNumber) {
                QName nsQName = (QName)this.document.namePool.get(this.document.namespaceCode[ns]);
                if (nsQName.getStringValue().equals(name)) {
                    return nsQName.getNamespaceURI();
                }
                ++ns;
            }
        }
        return null;
    }

    public void setAttribute(String arg0, String arg1) throws DOMException {
    }

    public void removeAttribute(String arg0) throws DOMException {
    }

    public int getAttributesCount() {
        return this.document.getAttributesCountFor(this.nodeNumber) + this.document.getNamespacesCountFor(this.nodeNumber);
    }

    public NamedNodeMap getAttributes() {
        int ns;
        NamedNodeMapImpl map = new NamedNodeMapImpl();
        int attr = this.document.alpha[this.nodeNumber];
        if (-1 < attr) {
            while (attr < this.document.nextAttr && this.document.attrParent[attr] == this.nodeNumber) {
                map.add(new AttributeImpl(this.document, attr));
                ++attr;
            }
        }
        if ((ns = this.document.alphaLen[this.nodeNumber]) < 0) {
            return map;
        }
        while (ns < this.document.nextNamespace && this.document.namespaceParent[ns] == this.nodeNumber) {
            NamespaceNode node = new NamespaceNode(this.document, ns);
            map.add(node);
            ++ns;
        }
        return map;
    }

    public Attr getAttributeNode(String name) {
        int ns;
        int attr = this.document.alpha[this.nodeNumber];
        if (-1 < attr) {
            while (attr < this.document.nextAttr && this.document.attrParent[attr] == this.nodeNumber) {
                QName attrQName = (QName)this.document.namePool.get(this.document.attrName[attr]);
                if (attrQName.getStringValue().equals(name)) {
                    return new AttributeImpl(this.document, attr);
                }
                ++attr;
            }
        }
        if (name.startsWith("xmlns:") && -1 < (ns = this.document.alphaLen[this.nodeNumber])) {
            while (ns < this.document.nextNamespace && this.document.namespaceParent[ns] == this.nodeNumber) {
                QName nsQName = (QName)this.document.namePool.get(this.document.namespaceCode[ns]);
                if (nsQName.getStringValue().equals(name)) {
                    return new NamespaceNode(this.document, ns);
                }
                ++ns;
            }
        }
        return null;
    }

    public Attr setAttributeNode(Attr arg0) throws DOMException {
        return null;
    }

    public Attr removeAttributeNode(Attr arg0) throws DOMException {
        return null;
    }

    public NodeList getElementsByTagName(String name) {
        NodeListImpl nl = new NodeListImpl();
        int nextNode = this.nodeNumber;
        while (++nextNode < this.document.size) {
            QName qn;
            if (this.document.nodeKind[nextNode] == 1 && (qn = (QName)this.document.namePool.get(this.document.nodeName[nextNode])).getStringValue().equals(name)) {
                nl.add(this.document.getNode(nextNode));
            }
            if (this.document.next[nextNode] > this.nodeNumber) continue;
            break;
        }
        return nl;
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        int ns;
        int attr = this.document.alpha[this.nodeNumber];
        if (-1 < attr) {
            while (attr < this.document.nextAttr && this.document.attrParent[attr] == this.nodeNumber) {
                QName name = (QName)this.document.namePool.get(this.document.attrName[attr]);
                if (name.getLocalName().equals(localName) && name.getNamespaceURI().equals(namespaceURI)) {
                    return this.document.attrValue[attr];
                }
                ++attr;
            }
        }
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI) && -1 < (ns = this.document.alphaLen[this.nodeNumber])) {
            while (ns < this.document.nextNamespace && this.document.namespaceParent[ns] == this.nodeNumber) {
                QName nsQName = (QName)this.document.namePool.get(this.document.namespaceCode[ns]);
                if (nsQName.getLocalName().equals(localName)) {
                    return nsQName.getNamespaceURI();
                }
                ++ns;
            }
        }
        return null;
    }

    public void setAttributeNS(String arg0, String arg1, String arg2) throws DOMException {
    }

    public void removeAttributeNS(String arg0, String arg1) throws DOMException {
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        int ns;
        int attr = this.document.alpha[this.nodeNumber];
        if (-1 < attr) {
            while (attr < this.document.nextAttr && this.document.attrParent[attr] == this.nodeNumber) {
                QName name = (QName)this.document.namePool.get(this.document.attrName[attr]);
                if (name.getLocalName().equals(localName) && name.getNamespaceURI().equals(namespaceURI)) {
                    return new AttributeImpl(this.document, attr);
                }
                ++attr;
            }
        }
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI) && -1 < (ns = this.document.alphaLen[this.nodeNumber])) {
            while (ns < this.document.nextNamespace && this.document.namespaceParent[ns] == this.nodeNumber) {
                QName nsQName = (QName)this.document.namePool.get(this.document.namespaceCode[ns]);
                if (nsQName.getLocalName().equals(localName)) {
                    return new NamespaceNode(this.document, ns);
                }
                ++ns;
            }
        }
        return null;
    }

    public Attr setAttributeNodeNS(Attr arg0) throws DOMException {
        return null;
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String name) {
        QName qname = new QName(name, namespaceURI);
        NodeListImpl nl = new NodeListImpl();
        int nextNode = this.nodeNumber;
        while (++nextNode < this.document.size) {
            QName qn;
            if (this.document.nodeKind[nextNode] == 1 && qname.compareTo(qn = (QName)this.document.namePool.get(this.document.nodeName[nextNode])) == 0) {
                nl.add(this.document.getNode(nextNode));
            }
            if (this.document.next[nextNode] > this.nodeNumber) continue;
            break;
        }
        return nl;
    }

    public boolean hasAttribute(String name) {
        return this.getAttribute(name) != null;
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.getAttributeNS(namespaceURI, localName) != null;
    }

    public String getNamespaceForPrefix(String name) {
        int ns = this.document.alphaLen[this.nodeNumber];
        if (-1 < ns) {
            while (ns < this.document.nextNamespace && this.document.namespaceParent[ns] == this.nodeNumber) {
                QName nsQName = (QName)this.document.namePool.get(this.document.namespaceCode[ns]);
                if (nsQName.getStringValue().equals("xmlns:" + name)) {
                    return nsQName.getNamespaceURI();
                }
                ++ns;
            }
        }
        return null;
    }

    public Set getPrefixes() {
        HashSet<String> set = new HashSet<String>();
        int ns = this.document.alphaLen[this.nodeNumber];
        if (-1 < ns) {
            while (ns < this.document.nextNamespace && this.document.namespaceParent[ns] == this.nodeNumber) {
                QName nsQName = (QName)this.document.namePool.get(this.document.namespaceCode[ns]);
                set.add(nsQName.getStringValue());
                ++ns;
            }
        }
        return set;
    }

    public boolean declaresNamespacePrefixes() {
        return this.document.getNamespacesCountFor(this.nodeNumber) > 0;
    }

    public Map getNamespaceMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        int ns = this.document.alphaLen[this.nodeNumber];
        if (-1 < ns) {
            while (ns < this.document.nextNamespace && this.document.namespaceParent[ns] == this.nodeNumber) {
                QName nsQName = (QName)this.document.namePool.get(this.document.namespaceCode[ns]);
                map.put(nsQName.getLocalName(), nsQName.getNamespaceURI());
                ++ns;
            }
        }
        return map;
    }

    public int getItemType() {
        return 1;
    }

    public String getBaseURI() {
        String baseURI = this.getAttributeNS("http://www.w3.org/XML/1998/namespace", "base");
        if (baseURI == null) {
            baseURI = "";
        }
        int parent = -1;
        int test = -1;
        test = this.document.getParentNodeFor(this.nodeNumber);
        if (this.document.nodeKind[test] != 9) {
            parent = test;
        }
        while (parent != -1 && this.document.getNode(parent).getBaseURI() != null) {
            baseURI = "".equals(baseURI) ? this.document.getNode(parent).getBaseURI() : this.document.getNode(parent).getBaseURI() + "/" + baseURI;
            test = this.document.getParentNodeFor(parent);
            if (this.document.nodeKind[test] == 9) {
                return baseURI;
            }
            parent = test;
        }
        if ("".equals(baseURI)) {
            baseURI = this.getDocument().getBaseURI();
        }
        return baseURI;
    }

    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    public void setIdAttribute(String name, boolean isId) throws DOMException {
    }

    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
    }

    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
    }

    public String toString() {
        int i;
        StringBuffer result = new StringBuffer();
        result.append("in-memory#");
        result.append("element {");
        result.append(this.getQName().getStringValue());
        result.append("} {");
        NamedNodeMap theAttrs = this.getAttributes();
        if (theAttrs != null) {
            for (i = 0; i < theAttrs.getLength(); ++i) {
                Node natt;
                if (i > 0) {
                    result.append(" ");
                }
                if ("org.exist.memtree.AttributeImpl".equals((natt = theAttrs.item(i)).getClass().getName())) {
                    result.append(((AttributeImpl)natt).toString());
                    continue;
                }
                result.append(((NamespaceNode)natt).toString());
            }
        }
        for (i = 0; i < this.getChildCount(); ++i) {
            if (i > 0) {
                result.append(" ");
            }
            Node child = this.getChildNodes().item(i);
            result.append(child.toString());
        }
        result.append("} ");
        return result.toString();
    }
}

