/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.FunctionDef;
import org.exist.xquery.FunctionId;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.InternalModule;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XPathUtil;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;

public abstract class AbstractInternalModule
implements InternalModule {
    private static final Logger LOG = Logger.getLogger((Class)AbstractInternalModule.class);
    protected FunctionDef[] mFunctions;
    protected boolean ordered = false;
    protected final TreeMap mGlobalVariables = new TreeMap();

    public AbstractInternalModule(FunctionDef[] functions) {
        this(functions, false);
    }

    public AbstractInternalModule(FunctionDef[] functions, boolean functionsOrdered) {
        this.mFunctions = functions;
        this.ordered = functionsOrdered;
    }

    private AbstractInternalModule() {
    }

    public boolean isInternalModule() {
        return true;
    }

    public abstract String getNamespaceURI();

    public abstract String getDefaultPrefix();

    public FunctionSignature[] listFunctions() {
        FunctionSignature[] signatures = new FunctionSignature[this.mFunctions.length];
        for (int i = 0; i < signatures.length; ++i) {
            signatures[i] = this.mFunctions[i].getSignature();
        }
        return signatures;
    }

    public Iterator getSignaturesForFunction(QName qname) {
        ArrayList<FunctionSignature> signatures = new ArrayList<FunctionSignature>(2);
        for (int i = 0; i < this.mFunctions.length; ++i) {
            FunctionSignature signature = this.mFunctions[i].getSignature();
            if (signature.getName().compareTo(qname) != 0) continue;
            signatures.add(signature);
        }
        return signatures.iterator();
    }

    public FunctionDef getFunctionDef(QName qname, int arity) {
        FunctionId id = new FunctionId(qname, arity);
        if (this.ordered) {
            return this.binarySearch(id);
        }
        for (int i = 0; i < this.mFunctions.length; ++i) {
            if (id.compareTo(this.mFunctions[i].getSignature().getFunctionId()) != 0) continue;
            return this.mFunctions[i];
        }
        return null;
    }

    private FunctionDef binarySearch(FunctionId id) {
        int low = 0;
        int high = this.mFunctions.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            FunctionDef midVal = this.mFunctions[mid];
            int cmp = midVal.getSignature().getFunctionId().compareTo(id);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return midVal;
        }
        return null;
    }

    public List getFunctionsByName(QName qname) {
        ArrayList<FunctionSignature> funcs = new ArrayList<FunctionSignature>();
        for (int i = 0; i < this.mFunctions.length; ++i) {
            FunctionSignature sig = this.mFunctions[i].getSignature();
            if (sig.getName().compareTo(qname) != 0) continue;
            funcs.add(sig);
        }
        return funcs;
    }

    public Variable declareVariable(QName qname, Object value) throws XPathException {
        Sequence val = XPathUtil.javaObjectToXPath(value, null);
        Variable var = (Variable)this.mGlobalVariables.get(qname);
        if (var == null) {
            var = new Variable(qname);
            this.mGlobalVariables.put(qname, var);
        }
        var.setValue(val);
        return var;
    }

    public Variable declareVariable(Variable var) {
        this.mGlobalVariables.put(var.getQName(), var);
        return var;
    }

    public Variable resolveVariable(QName qname) throws XPathException {
        return (Variable)this.mGlobalVariables.get(qname);
    }

    public boolean isVarDeclared(QName qname) {
        return this.mGlobalVariables.get(qname) != null;
    }

    public void reset(XQueryContext xqueryContext) {
    }

    public static class FunctionComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            FunctionDef d1 = (FunctionDef)o1;
            return d1.getSignature().getFunctionId().compareTo(((FunctionDef)o2).getSignature().getFunctionId());
        }
    }
}

