/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.Iterator;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.QName;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.BindingExpression;
import org.exist.xquery.Cardinality;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.GroupSpec;
import org.exist.xquery.LetExpr;
import org.exist.xquery.LocalVariable;
import org.exist.xquery.OrderSpec;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.GroupedValueSequence;
import org.exist.xquery.value.GroupedValueSequenceTable;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.OrderedValueSequence;
import org.exist.xquery.value.PreorderedValueSequence;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;

public class ForExpr
extends BindingExpression {
    private String positionalVariable = null;

    public ForExpr(XQueryContext context) {
        super(context);
    }

    public void setPositionalVariable(String var) {
        this.positionalVariable = var;
    }

    public void analyze(AnalyzeContextInfo contextInfo, OrderSpec[] orderBy) throws XPathException {
        this.analyze(contextInfo, orderBy, null);
    }

    public void analyze(AnalyzeContextInfo contextInfo, OrderSpec[] orderBy, GroupSpec[] groupBy) throws XPathException {
        AnalyzeContextInfo newContextInfo;
        if (this.groupVarName != null) {
            LocalVariable groupVar = new LocalVariable(QName.parse(this.context, this.groupVarName, null));
            groupVar.setSequenceType(this.sequenceType);
            this.context.declareVariableBinding(groupVar);
        }
        if (groupBy != null) {
            for (int i = 0; i < groupBy.length; ++i) {
                LocalVariable groupKeyVar = new LocalVariable(QName.parse(this.context, groupBy[i].getKeyVarName(), null));
                groupKeyVar.setSequenceType(this.sequenceType);
                this.context.declareVariableBinding(groupKeyVar);
            }
        }
        LocalVariable mark = this.context.markLocalVariables(false);
        contextInfo.setParent(this);
        this.inputSequence.analyze(contextInfo);
        LocalVariable inVar = new LocalVariable(QName.parse(this.context, this.varName, null));
        inVar.setSequenceType(this.sequenceType);
        this.context.declareVariableBinding(inVar);
        if (this.positionalVariable != null) {
            if (this.varName.equals(this.positionalVariable)) {
                throw new XPathException("XQST0089: bound variable and positional variable have the same name");
            }
            LocalVariable posVar = new LocalVariable(QName.parse(this.context, this.positionalVariable, null));
            posVar.setSequenceType(POSITIONAL_VAR_TYPE);
            this.context.declareVariableBinding(posVar);
        }
        if (this.whereExpr != null) {
            newContextInfo = new AnalyzeContextInfo(contextInfo);
            newContextInfo.setFlags(contextInfo.getFlags() | 2 | 4);
            newContextInfo.setContextId(this.getExpressionId());
            this.whereExpr.analyze(newContextInfo);
        }
        if (this.returnExpr instanceof BindingExpression) {
            newContextInfo = new AnalyzeContextInfo(contextInfo);
            newContextInfo.addFlag(1);
            ((BindingExpression)this.returnExpr).analyze(newContextInfo, orderBy, groupBy);
        } else {
            int i;
            newContextInfo = new AnalyzeContextInfo(contextInfo);
            newContextInfo.addFlag(1);
            if (orderBy != null) {
                for (i = 0; i < orderBy.length; ++i) {
                    orderBy[i].analyze(newContextInfo);
                }
            }
            if (groupBy != null) {
                for (i = 0; i < groupBy.length; ++i) {
                    groupBy[i].analyze(newContextInfo);
                }
            }
            this.returnExpr.analyze(newContextInfo);
        }
        this.context.popLocalVariables(mark);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem, Sequence resultSequence, GroupedValueSequenceTable groupedSequence) throws XPathException {
        boolean fastExec;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
            if (resultSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "RESULT SEQUENCE", resultSequence);
            }
        }
        LocalVariable groupVar = null;
        LocalVariable[] groupKeyVar = null;
        if (this.groupSpecs != null) {
            groupedSequence = new GroupedValueSequenceTable(this.groupSpecs, this.toGroupVarName, this.context);
            groupVar = new LocalVariable(QName.parse(this.context, this.groupVarName, null));
            groupVar.setSequenceType(this.sequenceType);
            this.context.declareVariableBinding(groupVar);
            groupKeyVar = new LocalVariable[this.groupSpecs.length];
            for (int i = 0; i < this.groupSpecs.length; ++i) {
                groupKeyVar[i] = new LocalVariable(QName.parse(this.context, this.groupSpecs[i].getKeyVarName(), null));
                groupKeyVar[i].setSequenceType(this.sequenceType);
                this.context.declareVariableBinding(groupKeyVar[i]);
            }
        }
        LocalVariable mark = this.context.markLocalVariables(false);
        Sequence in = this.inputSequence.eval(contextSequence, null);
        ForExpr.clearContext(this.getExpressionId(), in);
        LocalVariable var = new LocalVariable(QName.parse(this.context, this.varName, null));
        var.setSequenceType(this.sequenceType);
        this.context.declareVariableBinding(var);
        this.registerUpdateListener(in);
        LocalVariable at = null;
        if (this.positionalVariable != null) {
            at = new LocalVariable(QName.parse(this.context, this.positionalVariable, null));
            at.setSequenceType(POSITIONAL_VAR_TYPE);
            this.context.declareVariableBinding(at);
        }
        var.setValue(in);
        if (in instanceof NodeSet) {
            var.setContextDocs(in.getDocumentSet());
        } else {
            var.setContextDocs(null);
        }
        boolean fastOrderBy = false;
        boolean bl = fastExec = this.whereExpr != null && at == null && !Dependency.dependsOn(this.whereExpr, 2) && Type.subTypeOf(in.getItemType(), -1);
        if (fastExec) {
            if (!in.isCached()) {
                ForExpr.setContext(this.getExpressionId(), in);
            }
            if (!(in = this.applyWhereExpression(in)).isCached()) {
                ForExpr.clearContext(this.getExpressionId(), in);
            }
        }
        if (fastOrderBy) {
            in = new PreorderedValueSequence(this.orderSpecs, in, this.getExpressionId());
        }
        if (resultSequence == null) {
            resultSequence = this.orderSpecs != null && !fastOrderBy ? new OrderedValueSequence(this.orderSpecs, in.getItemCount()) : new ValueSequence();
        }
        Sequence val = null;
        int p = 1;
        IntegerValue atVal = new IntegerValue(1L);
        if (this.positionalVariable != null) {
            at.setValue(atVal);
        }
        if (in.isEmpty() && this.sequenceType != null && !Cardinality.checkCardinality(this.sequenceType.getCardinality(), 1)) {
            throw new XPathException("XPTY0004: Invalid cardinality for variable $" + this.varName + ". Expected " + Cardinality.getDescription(this.sequenceType.getCardinality()) + ", got " + Cardinality.getDescription(in.getCardinality()));
        }
        p = 0;
        SequenceIterator i = in.iterate();
        while (i.hasNext()) {
            block39: {
                block38: {
                    block37: {
                        this.context.proceed(this);
                        contextItem = i.nextItem();
                        this.context.setContextPosition(p);
                        if (this.positionalVariable != null) {
                            at.setValue(new IntegerValue(p + 1));
                        }
                        contextSequence = contextItem.toSequence();
                        var.setValue(contextSequence);
                        if (this.sequenceType == null) {
                            var.checkType();
                        }
                        val = contextSequence;
                        if (this.whereExpr == null || fastExec) break block37;
                        if (contextItem instanceof NodeProxy) {
                            ((NodeProxy)contextItem).addContextNode(this.getExpressionId(), (NodeProxy)contextItem);
                        }
                        Sequence bool = this.applyWhereExpression(null);
                        if (contextItem instanceof NodeProxy) {
                            ((NodeProxy)contextItem).clearContext(this.getExpressionId());
                        }
                        if (bool.effectiveBooleanValue()) break block38;
                        break block39;
                    }
                    val = contextItem.toSequence();
                }
                this.context.setContextPosition(0);
                if (groupedSequence == null) {
                    if (this.returnExpr instanceof BindingExpression) {
                        ((BindingExpression)this.returnExpr).eval(null, null, resultSequence, null);
                    } else {
                        val = this.returnExpr.eval(null);
                        resultSequence.addAll(val);
                    }
                } else if (this.returnExpr instanceof BindingExpression) {
                    ((BindingExpression)this.returnExpr).eval(null, null, resultSequence, groupedSequence);
                } else {
                    Sequence toGroupSequence = this.context.resolveVariable(groupedSequence.getToGroupVarName()).getValue();
                    groupedSequence.addAll(toGroupSequence);
                }
            }
            ++p;
        }
        this.context.popLocalVariables(mark);
        if (this.groupSpecs != null) {
            Iterator it = groupedSequence.iterate();
            while (it.hasNext()) {
                Object key = it.next();
                GroupedValueSequence currentGroup = (GroupedValueSequence)groupedSequence.get(key);
                this.context.proceed(this);
                groupVar.setValue(currentGroup);
                groupVar.checkType();
                for (int i2 = 0; i2 < groupKeyVar.length; ++i2) {
                    groupKeyVar[i2].setValue(currentGroup.getGroupKey().itemAt(i2).toSequence());
                }
                val = this.groupReturnExpr.eval(null);
                resultSequence.addAll(val);
            }
            this.context.setContextPosition(0);
        }
        if (this.orderSpecs != null && !fastOrderBy) {
            ((OrderedValueSequence)resultSequence).sort();
        }
        ForExpr.clearContext(this.getExpressionId(), in);
        if (this.sequenceType != null) {
            if (resultSequence.isEmpty() && !Cardinality.checkCardinality(this.sequenceType.getCardinality(), 1)) {
                throw new XPathException("XPTY0004: Invalid cardinality for variable $" + this.varName + ". Expected " + Cardinality.getDescription(this.sequenceType.getCardinality()) + ", got " + Cardinality.getDescription(1));
            }
            if (!Type.subTypeOf(this.sequenceType.getPrimaryType(), -1)) {
                if (!resultSequence.isEmpty() && !Type.subTypeOf(resultSequence.getItemType(), this.sequenceType.getPrimaryType())) {
                    throw new XPathException("XPTY0004: Invalid type for variable $" + this.varName + ". Expected " + Type.getTypeName(this.sequenceType.getPrimaryType()) + ", got " + Type.getTypeName(resultSequence.getItemType()));
                }
            } else {
                var.checkType();
            }
        }
        this.actualReturnType = resultSequence.getItemType();
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", resultSequence);
        }
        return resultSequence;
    }

    public int returnsType() {
        if (this.sequenceType != null) {
            return this.sequenceType.getPrimaryType();
        }
        return this.actualReturnType;
    }

    public void dump(ExpressionDumper dumper) {
        int i;
        dumper.display("for ", this.getASTNode());
        dumper.startIndent();
        dumper.display("$").display(this.varName);
        if (this.positionalVariable != null) {
            dumper.display(" at ").display(this.positionalVariable);
        }
        if (this.sequenceType != null) {
            dumper.display(" as ").display(this.sequenceType);
        }
        dumper.display(" in ");
        this.inputSequence.dump(dumper);
        dumper.endIndent().nl();
        if (this.whereExpr != null) {
            dumper.display("where", this.whereExpr.getASTNode());
            dumper.startIndent();
            this.whereExpr.dump(dumper);
            dumper.endIndent().nl();
        }
        if (this.groupSpecs != null) {
            dumper.display("group ");
            dumper.display("$").display(this.toGroupVarName);
            dumper.display(" as ");
            dumper.display("$").display(this.groupVarName);
            dumper.display(" by ");
            for (i = 0; i < this.groupSpecs.length; ++i) {
                if (i > 0) {
                    dumper.display(", ");
                }
                dumper.display(this.groupSpecs[i].getGroupExpression().toString());
                dumper.display(" as ");
                dumper.display("$").display(this.groupSpecs[i].getKeyVarName());
            }
            dumper.nl();
        }
        if (this.orderSpecs != null) {
            dumper.display("order by ");
            for (i = 0; i < this.orderSpecs.length; ++i) {
                if (i > 0) {
                    dumper.display(", ");
                }
                dumper.display(this.orderSpecs[i]);
            }
            dumper.nl();
        }
        if (this.returnExpr instanceof LetExpr) {
            dumper.display(" ", this.returnExpr.getASTNode());
        } else {
            dumper.display("return", this.returnExpr.getASTNode());
        }
        dumper.startIndent();
        this.returnExpr.dump(dumper);
        dumper.endIndent().nl();
    }

    public String toString() {
        int i;
        StringBuffer result = new StringBuffer();
        result.append("for ");
        result.append("$").append(this.varName);
        if (this.positionalVariable != null) {
            result.append(" at ").append(this.positionalVariable);
        }
        if (this.sequenceType != null) {
            result.append(" as ").append(this.sequenceType);
        }
        result.append(" in ");
        result.append(this.inputSequence.toString());
        result.append(" ");
        if (this.whereExpr != null) {
            result.append("where");
            result.append(" ");
            result.append(this.whereExpr.toString());
            result.append(" ");
        }
        if (this.groupSpecs != null) {
            result.append("group ");
            result.append("$").append(this.toGroupVarName);
            result.append(" as ");
            result.append("$").append(this.groupVarName);
            result.append(" by ");
            for (i = 0; i < this.groupSpecs.length; ++i) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(this.groupSpecs[i].getGroupExpression().toString());
                result.append(" as ");
                result.append("$").append(this.groupSpecs[i].getKeyVarName());
            }
            result.append(" ");
        }
        if (this.orderSpecs != null) {
            result.append("order by ");
            for (i = 0; i < this.orderSpecs.length; ++i) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(this.orderSpecs[i].toString());
            }
            result.append(" ");
        }
        if (this.returnExpr instanceof LetExpr) {
            result.append(" ");
        } else {
            result.append("return ");
        }
        result.append(this.returnExpr.toString());
        return result.toString();
    }

    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
    }

    public void accept(ExpressionVisitor visitor) {
        visitor.visitForExpression(this);
    }
}

