/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import com.sun.xacml.ctx.RequestCtx;
import java.util.List;
import org.exist.dom.QName;
import org.exist.dom.VirtualNodeSet;
import org.exist.security.PermissionDeniedException;
import org.exist.security.xacml.ExistPDP;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Atomize;
import org.exist.xquery.DeferredFunctionCall;
import org.exist.xquery.Dependency;
import org.exist.xquery.DynamicCardinalityCheck;
import org.exist.xquery.DynamicTypeCheck;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.LocalVariable;
import org.exist.xquery.Profiler;
import org.exist.xquery.UntypedValueCheck;
import org.exist.xquery.UserDefinedFunction;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.Error;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;

public class FunctionCall
extends Function {
    private UserDefinedFunction functionDef;
    private Expression expression;
    private QName name = null;
    private List arguments = null;
    private boolean isRecursive = false;
    private boolean analyzed = false;

    public FunctionCall(XQueryContext context, QName name, List arguments) {
        super(context);
        this.name = name;
        this.arguments = arguments;
    }

    public FunctionCall(XQueryContext context, UserDefinedFunction functionDef) {
        super(context);
        this.setFunction(functionDef);
    }

    private void setFunction(UserDefinedFunction functionDef) {
        this.functionDef = functionDef;
        this.mySignature = functionDef.getSignature();
        this.expression = functionDef;
        SequenceType returnType = functionDef.getSignature().getReturnType();
        if (returnType.getCardinality() != 7) {
            this.expression = new DynamicCardinalityCheck(this.context, returnType.getCardinality(), this.expression, new Error("D01"));
        }
        if (Type.subTypeOf(returnType.getPrimaryType(), 20)) {
            this.expression = new Atomize(this.context, this.expression);
        }
        if (Type.subTypeOf(returnType.getPrimaryType(), 30)) {
            this.expression = new UntypedValueCheck(this.context, returnType.getPrimaryType(), this.expression, new Error("D03"));
        } else if (returnType.getPrimaryType() != 11) {
            this.expression = new DynamicTypeCheck(this.context, returnType.getPrimaryType(), this.expression);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        if (!this.analyzed) {
            super.analyze(contextInfo);
            if (this.context.tailRecursiveCall(this.functionDef.getSignature())) {
                this.isRecursive = true;
            }
            this.context.functionStart(this.functionDef.getSignature());
            try {
                this.expression.analyze(contextInfo);
                this.analyzed = true;
            }
            finally {
                this.context.functionEnd();
            }
        }
    }

    public void resolveForwardReference(UserDefinedFunction functionDef) throws XPathException {
        this.setFunction(functionDef);
        this.setArguments(this.arguments);
        this.arguments = null;
        this.name = null;
    }

    public int getArgumentCount() {
        if (this.arguments == null) {
            return super.getArgumentCount();
        }
        return this.arguments.size();
    }

    public QName getQName() {
        return this.name;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence[] seq = new Sequence[this.getArgumentCount()];
        for (int i = 0; i < this.getArgumentCount(); ++i) {
            try {
                seq[i] = this.getArgument(i).eval(contextSequence, contextItem);
                continue;
            }
            catch (XPathException e) {
                if (e.getLine() == 0) {
                    e.setASTNode(this.getASTNode());
                }
                e.addFunctionCall(this.functionDef, this.getASTNode());
                throw e;
            }
        }
        Sequence result = this.evalFunction(contextSequence, contextItem, seq);
        try {
            if (!(result instanceof DeferredFunctionCall || result.isEmpty() || result instanceof VirtualNodeSet)) {
                this.getSignature().getReturnType().checkType(result.getItemType());
            }
        }
        catch (XPathException e) {
            throw new XPathException(this.getASTNode(), "err:XPTY0004 in function '" + this.getSignature().getName() + "'. " + e.getMessage());
        }
        return result;
    }

    public Sequence evalFunction(Sequence contextSequence, Item contextItem, Sequence[] seq) throws XPathException {
        if (this.context.isProfilingEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        try {
            RequestCtx request;
            ExistPDP pdp = this.context.getPDP();
            if (pdp != null && (request = pdp.getRequestHelper().createFunctionRequest(this.context, null, this.getName())) != null) {
                pdp.evaluate(request);
            }
        }
        catch (PermissionDeniedException pde) {
            XPathException xe = new XPathException(this.getASTNode(), "Access to function '" + this.getName() + "'  denied.", pde);
            xe.addFunctionCall(this.functionDef, this.getASTNode());
            throw xe;
        }
        this.functionDef.setArguments(seq);
        if (this.isRecursive) {
            return new DeferredFunctionCallImpl(this.functionDef.getSignature(), contextSequence, contextItem);
        }
        this.context.functionStart(this.functionDef.getSignature());
        LocalVariable mark = this.context.markLocalVariables(true);
        try {
            Sequence returnSeq = this.expression.eval(contextSequence, contextItem);
            while (returnSeq instanceof DeferredFunctionCall && this.functionDef.getSignature().equals(((DeferredFunctionCall)returnSeq).getSignature())) {
                returnSeq = ((DeferredFunctionCall)returnSeq).execute();
            }
            if (this.context.isProfilingEnabled()) {
                this.context.getProfiler().end(this, "", returnSeq);
            }
            Sequence sequence = returnSeq;
            return sequence;
        }
        catch (XPathException e) {
            if (e.getLine() == 0) {
                e.setASTNode(this.getASTNode());
            }
            e.addFunctionCall(this.functionDef, this.getASTNode());
            throw e;
        }
        finally {
            this.context.popLocalVariables(mark);
            this.context.functionEnd();
        }
    }

    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.functionDef.resetState(postOptimization);
        this.analyzed = false;
    }

    public void accept(ExpressionVisitor visitor) {
        this.functionDef.accept(visitor);
    }

    private class DeferredFunctionCallImpl
    extends DeferredFunctionCall {
        private Sequence contextSequence;
        private Item contextItem;

        public DeferredFunctionCallImpl(FunctionSignature signature, Sequence contextSequence, Item contextItem) {
            super(signature);
            this.contextSequence = contextSequence;
            this.contextItem = contextItem;
        }

        protected Sequence execute() throws XPathException {
            FunctionCall.this.context.pushDocumentContext();
            FunctionCall.this.context.functionStart(FunctionCall.this.functionDef.getSignature());
            LocalVariable mark = FunctionCall.this.context.markLocalVariables(true);
            try {
                Sequence returnSeq;
                Sequence sequence = returnSeq = FunctionCall.this.expression.eval(this.contextSequence, this.contextItem);
                return sequence;
            }
            catch (XPathException e) {
                if (e.getLine() == 0) {
                    e.setASTNode(FunctionCall.this.getASTNode());
                }
                e.addFunctionCall(FunctionCall.this.functionDef, FunctionCall.this.getASTNode());
                throw e;
            }
            finally {
                FunctionCall.this.context.popLocalVariables(mark);
                FunctionCall.this.context.functionEnd();
                FunctionCall.this.context.popDocumentContext();
            }
        }
    }
}

