/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.dom.DocumentSet;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeSet;
import org.exist.dom.QName;
import org.exist.storage.FulltextIndexSpec;
import org.exist.storage.analysis.TextToken;
import org.exist.storage.analysis.Tokenizer;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.BasicExpressionVisitor;
import org.exist.xquery.CachedResult;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.LocationStep;
import org.exist.xquery.NodeTest;
import org.exist.xquery.Optimizable;
import org.exist.xquery.PathExpr;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;

public class ExtFulltext
extends Function
implements Optimizable {
    public static final FunctionSignature signature = new FunctionSignature(new QName("contains", "http://www.w3.org/2005/xpath-functions"), new SequenceType[]{new SequenceType(-1, 7)}, new SequenceType(-1, 7));
    protected PathExpr path;
    protected Expression searchTerm = null;
    protected int type = 1;
    protected CachedResult cached = null;
    private LocationStep contextStep = null;
    protected QName contextQName = null;
    protected int axis = -1;
    protected boolean optimizeSelf = false;
    protected NodeSet preselectResult = null;

    public ExtFulltext(XQueryContext context, int type) {
        super(context, signature);
        this.type = type;
    }

    public void addTerm(Expression term) {
        if (term instanceof PathExpr && ((PathExpr)term).getLength() == 1) {
            term = ((PathExpr)term).getExpression(0);
        }
        this.searchTerm = term;
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.path.analyze(contextInfo);
        this.searchTerm.analyze(contextInfo);
        List steps = BasicExpressionVisitor.findLocationSteps(this.path);
        if (!steps.isEmpty()) {
            LocationStep firstStep = (LocationStep)steps.get(0);
            LocationStep lastStep = (LocationStep)steps.get(steps.size() - 1);
            if (steps.size() == 1 && firstStep.getAxis() == 12) {
                LocationStep outerStep;
                NodeTest test;
                Expression outerExpr = contextInfo.getContextStep();
                if (outerExpr != null && outerExpr instanceof LocationStep && !(test = (outerStep = (LocationStep)outerExpr).getTest()).isWildcardTest() && test.getName() != null) {
                    this.contextQName = new QName(test.getName());
                    if (outerStep.getAxis() == 6 || outerStep.getAxis() == 13) {
                        this.contextQName.setNameType((byte)1);
                    }
                    this.contextStep = firstStep;
                    this.axis = outerStep.getAxis();
                    this.optimizeSelf = true;
                }
            } else {
                NodeTest test = lastStep.getTest();
                if (!test.isWildcardTest() && test.getName() != null) {
                    this.contextQName = new QName(test.getName());
                    if (lastStep.getAxis() == 6 || lastStep.getAxis() == 13) {
                        this.contextQName.setNameType((byte)1);
                    }
                    this.axis = firstStep.getAxis();
                    this.contextStep = lastStep;
                }
            }
        }
    }

    public boolean canOptimize(Sequence contextSequence) {
        if (this.contextQName == null) {
            return false;
        }
        return this.checkForQNameIndex(contextSequence);
    }

    public boolean optimizeOnSelf() {
        return this.optimizeSelf;
    }

    public int getOptimizeAxis() {
        return this.axis;
    }

    public NodeSet preSelect(Sequence contextSequence, boolean useContext) throws XPathException {
        String[] terms;
        this.preselectResult = null;
        String arg = this.searchTerm.eval(contextSequence).getStringValue();
        try {
            terms = this.getSearchTerms(arg);
        }
        catch (EXistException e) {
            throw new XPathException(e.getMessage(), e);
        }
        NodeSet[] hits = this.getMatches(contextSequence.getDocumentSet(), useContext ? contextSequence.toNodeSet() : null, 1, this.contextQName, terms);
        this.preselectResult = hits[0];
        if (this.preselectResult != null) {
            for (int k = 1; k < hits.length; ++k) {
                if (hits[k] == null) continue;
                this.preselectResult = this.type == 1 ? this.preselectResult.deepIntersection(hits[k]) : this.preselectResult.union(hits[k]);
            }
        } else {
            this.preselectResult = NodeSet.EMPTY_SET;
        }
        return this.preselectResult;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        NodeSet result;
        if (this.preselectResult != null && this.preselectResult.isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if (this.preselectResult == null && !this.checkForQNameIndex(contextSequence)) {
            this.contextQName = null;
        }
        if (this.path == null || !Dependency.dependsOn(this.path, 2)) {
            boolean canCache;
            boolean bl = canCache = !Dependency.dependsOn(this.searchTerm, 2) && !Dependency.dependsOnVar(this.searchTerm);
            if (canCache && this.cached != null && this.cached.isValid(contextSequence, contextItem)) {
                return this.cached.getResult();
            }
            if (this.contextStep == null || this.preselectResult == null) {
                NodeSet nodes = this.path == null ? contextSequence.toNodeSet() : this.path.eval(contextSequence).toNodeSet();
                String arg = this.searchTerm.eval(contextSequence).getStringValue();
                result = this.evalQuery(arg, nodes).toNodeSet();
            } else {
                this.contextStep.setPreloadNodeSets(true);
                this.contextStep.setPreloadedData(contextSequence.getDocumentSet(), this.preselectResult);
                result = this.path.eval(contextSequence).toNodeSet();
            }
            if (canCache && contextSequence instanceof NodeSet) {
                this.cached = new CachedResult((NodeSet)contextSequence, contextItem, result);
            }
        } else {
            result = new ExtArrayNodeSet();
            SequenceIterator i = contextSequence.iterate();
            while (i.hasNext()) {
                Item current = i.nextItem();
                String arg = this.searchTerm.eval(current.toSequence()).getStringValue();
                NodeSet nodes = this.path == null ? contextSequence.toNodeSet() : this.path.eval(current.toSequence()).toNodeSet();
                Sequence temp = this.evalQuery(arg, nodes);
                result.addAll(temp);
            }
        }
        this.preselectResult = null;
        return result;
    }

    private boolean checkForQNameIndex(Sequence contextSequence) {
        if (contextSequence == null || this.contextQName == null) {
            return false;
        }
        boolean hasQNameIndex = true;
        Iterator i = contextSequence.getCollectionIterator();
        while (i.hasNext()) {
            Collection collection = (Collection)i.next();
            if (collection.getURI().startsWith(XmldbURI.SYSTEM_COLLECTION_URI)) continue;
            FulltextIndexSpec config = collection.getFulltextIndexConfiguration(this.context.getBroker());
            if (config != null) {
                hasQNameIndex = config.hasQNameIndex(this.contextQName);
            }
            if (hasQNameIndex) continue;
            if (!LOG.isTraceEnabled()) break;
            LOG.trace((Object)("cannot use index on QName: " + this.contextQName + ". Collection " + collection.getURI() + " does not define an index"));
            break;
        }
        return hasQNameIndex;
    }

    protected Sequence evalQuery(String searchArg, NodeSet nodes) throws XPathException {
        String[] terms;
        try {
            terms = this.getSearchTerms(searchArg);
        }
        catch (EXistException e) {
            throw new XPathException(e.getMessage(), e);
        }
        NodeSet hits = this.processQuery(terms, nodes);
        if (hits == null) {
            return NodeSet.EMPTY_SET;
        }
        return hits;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.path.toString());
        if (this.type == 1) {
            result.append(" &= ");
        } else {
            result.append(" |= ");
        }
        result.append(this.searchTerm.toString());
        return result.toString();
    }

    public void dump(ExpressionDumper dumper) {
        this.path.dump(dumper);
        if (this.type == 1) {
            dumper.display(" &= ");
        } else {
            dumper.display(" |= ");
        }
        this.searchTerm.dump(dumper);
    }

    public int getDependencies() {
        return this.path.getDependencies();
    }

    protected String[] getSearchTerms(String searchString) throws EXistException {
        TextToken token;
        ArrayList<String> tokens = new ArrayList<String>();
        Tokenizer tokenizer = this.context.getBroker().getTextEngine().getTokenizer();
        tokenizer.setText(searchString);
        while (null != (token = tokenizer.nextToken(true))) {
            String word = token.getText();
            tokens.add(word);
        }
        String[] terms = new String[tokens.size()];
        return tokens.toArray(terms);
    }

    protected NodeSet processQuery(String[] terms, NodeSet contextSet) throws XPathException {
        if (terms == null) {
            throw new RuntimeException("no search terms");
        }
        if (terms.length == 0) {
            return NodeSet.EMPTY_SET;
        }
        NodeSet[] hits = this.getMatches(contextSet.getDocumentSet(), contextSet, 0, this.contextQName, terms);
        NodeSet result = hits[0];
        if (result != null) {
            for (int k = 1; k < hits.length; ++k) {
                if (hits[k] == null) continue;
                result = this.type == 1 ? result.deepIntersection(hits[k]) : result.union(hits[k]);
            }
            return result;
        }
        return NodeSet.EMPTY_SET;
    }

    protected NodeSet[] getMatches(DocumentSet docs, NodeSet contextSet, int axis, QName qname, String[] terms) throws XPathException {
        NodeSet[] hits = new NodeSet[terms.length];
        for (int k = 0; k < terms.length; ++k) {
            hits[k] = this.context.getBroker().getTextEngine().getNodesContaining(this.context, docs, contextSet, axis, qname, terms[k], 0);
        }
        return hits;
    }

    public int returnsType() {
        return -1;
    }

    public void setPath(PathExpr path) {
        this.path = path;
    }

    public void setContextDocSet(DocumentSet contextSet) {
        super.setContextDocSet(contextSet);
        this.path.setContextDocSet(contextSet);
    }

    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.path.resetState(postOptimization);
        this.searchTerm.resetState(postOptimization);
        if (!postOptimization) {
            this.preselectResult = null;
            this.cached = null;
        }
    }

    public void accept(ExpressionVisitor visitor) {
        visitor.visitFtExpression(this);
    }
}

