/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import java.net.URI;
import java.net.URISyntaxException;
import org.exist.dom.NodeImpl;
import org.exist.dom.NodeProxy;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;

public class FunBaseURI
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("base-uri", "http://www.w3.org/2005/xpath-functions"), "This version of the function returns the value of the base-uri property from the static context. If the base-uri property is undefined, the empty sequence is returned.", null, new SequenceType(25, 3)), new FunctionSignature(new QName("base-uri", "http://www.w3.org/2005/xpath-functions"), "Returns the value of the base-uri property for $a. If $a is the empty sequence, the empty sequence is returned.", new SequenceType[]{new SequenceType(-1, 3)}, new SequenceType(25, 3)), new FunctionSignature(new QName("static-base-uri", "http://www.w3.org/2005/xpath-functions"), "Returns the value of the Base URI property from the static context. If the Base URI property is undefined, the empty sequence is returned.", null, new SequenceType(25, 3))};

    public FunBaseURI(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        Sequence result = null;
        NodeValue node = null;
        if (this.isCalledAs("static-base-uri")) {
            result = this.context.isBaseURIDeclared() ? this.context.getBaseURI() : Sequence.EMPTY_SEQUENCE;
        } else if (args.length == 0) {
            if (contextSequence == null || contextSequence.isEmpty()) {
                throw new XPathException(this.getASTNode(), "err:XPDY0002: context sequence is empty and no argument specified");
            }
            Item item = contextSequence.itemAt(0);
            if (!Type.subTypeOf(item.getType(), -1)) {
                throw new XPathException(this.getASTNode(), "err:XPTY0004: context item is not a node");
            }
            node = (NodeValue)item;
        } else if (args[0].isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            node = (NodeValue)args[0].itemAt(0);
        }
        if (result == null && node != null) {
            if (node.getImplementationType() == 0) {
                org.exist.memtree.NodeImpl domNode = (org.exist.memtree.NodeImpl)node.getNode();
                short type = domNode.getNodeType();
                if (type == 7) {
                    result = Sequence.EMPTY_SEQUENCE;
                } else if (type == 1 || type == 9) {
                    URI baseURI;
                    URI relativeURI;
                    try {
                        relativeURI = new URI(domNode.getBaseURI());
                        baseURI = new URI(this.context.getBaseURI() + "/");
                    }
                    catch (URISyntaxException e) {
                        throw new XPathException(e.getMessage(), e);
                    }
                    result = !"".equals(relativeURI.toString()) ? (relativeURI.isAbsolute() ? new AnyURIValue(relativeURI) : new AnyURIValue(baseURI.resolve(relativeURI))) : Sequence.EMPTY_SEQUENCE;
                } else {
                    result = Sequence.EMPTY_SEQUENCE;
                }
            } else {
                NodeProxy proxy = (NodeProxy)node;
                short type = proxy.getNodeType();
                if (type == 1 || type == 9 || type == 7) {
                    URI baseURI;
                    URI relativeURI;
                    try {
                        NodeImpl baseNode = (NodeImpl)proxy.getNode();
                        relativeURI = new URI(baseNode.getBaseURI());
                        baseURI = new URI(this.context.getBaseURI() + "/");
                    }
                    catch (URISyntaxException e) {
                        throw new XPathException(e.getMessage(), e);
                    }
                    result = relativeURI.isAbsolute() ? new AnyURIValue(relativeURI) : new AnyURIValue(baseURI.resolve(relativeURI));
                } else {
                    result = Sequence.EMPTY_SEQUENCE;
                }
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

