/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.exist.collections.Collection;
import org.exist.dom.QName;
import org.exist.security.PermissionDeniedException;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class XMLDBReindex
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("reindex", "http://exist-db.org/xquery/xmldb", "xmldb"), "Reindex collection $a. DBA only", new SequenceType[]{new SequenceType(22, 2)}, new SequenceType(23, 1));

    public XMLDBReindex(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String ROOTCOLLECTION = XmldbURI.ROOT_COLLECTION_URI.toString();
        if (!this.context.getUser().hasDbaRole()) {
            throw new XPathException("Permission denied, user '" + this.context.getUser().getName() + "' must be a DBA to shutdown the database");
        }
        String collectionArg = args[0].getStringValue();
        if (!collectionArg.startsWith(ROOTCOLLECTION)) {
            throw new XPathException(this.getASTNode(), "Collection should start with " + ROOTCOLLECTION + "");
        }
        XmldbURI colName = XmldbURI.create(collectionArg);
        Collection coll = this.context.getBroker().getCollection(colName);
        if (coll == null) {
            throw new XPathException(this.getASTNode(), "Collection " + colName.toString() + " does not exist.");
        }
        try {
            this.context.getBroker().reindexCollection(colName);
        }
        catch (PermissionDeniedException ex) {
            throw new XPathException(this.getASTNode(), ex.getMessage());
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

