/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.db.DatabaseEntry;

public class LongBinding
extends TupleBinding {
    private static final int LONG_SIZE = 8;

    public Object entryToObject(TupleInput input) {
        return new Long(input.readLong());
    }

    public void objectToEntry(Object object, TupleOutput output) {
        output.writeLong(((Number)object).longValue());
    }

    protected TupleOutput getTupleOutput(Object object) {
        return LongBinding.sizedOutput();
    }

    public static long entryToLong(DatabaseEntry entry) {
        return LongBinding.entryToInput(entry).readLong();
    }

    public static void longToEntry(long val, DatabaseEntry entry) {
        LongBinding.outputToEntry(LongBinding.sizedOutput().writeLong(val), entry);
    }

    private static TupleOutput sizedOutput() {
        return new TupleOutput(new byte[8]);
    }
}

