/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.collections.BaseIterator;
import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.StoredCollection;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.OperationStatus;
import java.util.Set;

public class StoredKeySet
extends StoredCollection
implements Set {
    public StoredKeySet(Database database, EntryBinding keyBinding, boolean writeAllowed) {
        super(new DataView(database, keyBinding, null, null, writeAllowed, null));
    }

    StoredKeySet(DataView keySetView) {
        super(keySetView);
    }

    public boolean add(Object key) {
        DataCursor cursor = null;
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            cursor = new DataCursor(this.view, true);
            OperationStatus status = cursor.putNoOverwrite(key, null, false);
            this.closeCursor(cursor);
            this.commitAutoCommit(doAutoCommit);
            return status == OperationStatus.SUCCESS;
        }
        catch (Exception e) {
            this.closeCursor(cursor);
            throw this.handleException(e, doAutoCommit);
        }
    }

    public boolean remove(Object key) {
        return this.removeKey(key, null);
    }

    public boolean contains(Object key) {
        return this.containsKey(key);
    }

    boolean hasValues() {
        return false;
    }

    Object makeIteratorData(BaseIterator iterator, DatabaseEntry keyEntry, DatabaseEntry priKeyEntry, DatabaseEntry valueEntry) {
        return this.view.makeKey(keyEntry, priKeyEntry);
    }

    boolean iterateDuplicates() {
        return false;
    }
}

