/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.ErrorHandler;
import com.sleepycat.db.EventHandler;
import com.sleepycat.db.FeedbackHandler;
import com.sleepycat.db.LockDetectMode;
import com.sleepycat.db.LogRecordHandler;
import com.sleepycat.db.MessageHandler;
import com.sleepycat.db.PanicHandler;
import com.sleepycat.db.ReplicationHostAddress;
import com.sleepycat.db.ReplicationManagerAckPolicy;
import com.sleepycat.db.ReplicationTransport;
import com.sleepycat.db.VerboseConfig;
import com.sleepycat.db.internal.DbEnv;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class EnvironmentConfig
implements Cloneable {
    public static final EnvironmentConfig DEFAULT = new EnvironmentConfig();
    private int mode = 420;
    private int cacheCount = 0;
    private long cacheSize = 0L;
    private long cacheMax = 0L;
    private Vector dataDirs = new Vector();
    private int envid = 0;
    private String errorPrefix = null;
    private OutputStream errorStream = null;
    private OutputStream messageStream = null;
    private byte[][] lockConflicts = null;
    private LockDetectMode lockDetectMode = LockDetectMode.NONE;
    private int maxLocks = 0;
    private int maxLockers = 0;
    private int maxLockObjects = 0;
    private int maxLogFileSize = 0;
    private int logBufferSize = 0;
    private File logDirectory = null;
    private int logFileMode = 0;
    private int logRegionSize = 0;
    private int maxMutexes = 0;
    private int maxOpenFiles = 0;
    private int maxWrite = 0;
    private long maxWriteSleep = 0L;
    private int mutexAlignment = 0;
    private int mutexIncrement = 0;
    private int mutexTestAndSetSpins = 0;
    private long mmapSize = 0L;
    private String password = null;
    private int replicationLease = 0;
    private long replicationLimit = 0L;
    private int replicationNSites = 0;
    private int replicationPriority = 100;
    private int replicationRequestMin = 0;
    private int replicationRequestMax = 0;
    private String rpcServer = null;
    private long rpcClientTimeout = 0L;
    private long rpcServerTimeout = 0L;
    private long segmentId = 0L;
    private long lockTimeout = 0L;
    private int txnMaxActive = 0;
    private long txnTimeout = 0L;
    private Date txnTimestamp = null;
    private File temporaryDirectory = null;
    private ReplicationManagerAckPolicy repmgrAckPolicy = ReplicationManagerAckPolicy.ALL;
    private ReplicationHostAddress repmgrLocalSiteAddr = null;
    private Vector repmgrRemoteSites = new Vector();
    private boolean allowCreate = false;
    private boolean initializeCache = false;
    private boolean initializeCDB = false;
    private boolean initializeLocking = false;
    private boolean initializeLogging = false;
    private boolean initializeReplication = false;
    private boolean joinEnvironment = false;
    private boolean lockDown = false;
    private boolean isPrivate = false;
    private boolean register = false;
    private boolean runRecovery = false;
    private boolean runFatalRecovery = false;
    private boolean systemMemory = false;
    private boolean threaded = true;
    private boolean transactional = false;
    private boolean useEnvironment = false;
    private boolean useEnvironmentRoot = false;
    private boolean cdbLockAllDatabases = false;
    private boolean directDatabaseIO = false;
    private boolean directLogIO = false;
    private boolean dsyncDatabases = false;
    private boolean dsyncLog = false;
    private boolean initializeRegions = false;
    private boolean logAutoRemove = false;
    private boolean logInMemory = false;
    private boolean multiversion = false;
    private boolean noLocking = false;
    private boolean noMMap = false;
    private boolean noPanic = false;
    private boolean overwrite = false;
    private boolean txnNoSync = false;
    private boolean txnNoWait = false;
    private boolean txnNotDurable = false;
    private boolean txnSnapshot = false;
    private boolean txnWriteNoSync = false;
    private boolean yieldCPU = false;
    private boolean verboseDeadlock = false;
    private boolean verboseFileops = false;
    private boolean verboseFileopsAll = false;
    private boolean verboseRecovery = false;
    private boolean verboseRegister = false;
    private boolean verboseReplication = false;
    private boolean verboseWaitsFor = false;
    private ErrorHandler errorHandler = null;
    private FeedbackHandler feedbackHandler = null;
    private LogRecordHandler logRecordHandler = null;
    private EventHandler eventHandler = null;
    private MessageHandler messageHandler = null;
    private PanicHandler panicHandler = null;
    private ReplicationTransport replicationTransport = null;

    static EnvironmentConfig checkNull(EnvironmentConfig config) {
        return config == null ? DEFAULT : config;
    }

    public EnvironmentConfig() {
    }

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    public boolean getAllowCreate() {
        return this.allowCreate;
    }

    public void setCacheSize(long cacheSize) {
        this.cacheSize = cacheSize;
    }

    public long getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheMax(long cacheMax) {
        this.cacheMax = cacheMax;
    }

    public long getCacheMax() {
        return this.cacheMax;
    }

    public void setCacheCount(int cacheCount) {
        this.cacheCount = cacheCount;
    }

    public int getCacheCount() {
        return this.cacheCount;
    }

    public void setCDBLockAllDatabases(boolean cdbLockAllDatabases) {
        this.cdbLockAllDatabases = cdbLockAllDatabases;
    }

    public boolean getCDBLockAllDatabases() {
        return this.cdbLockAllDatabases;
    }

    public void addDataDir(File dataDir) {
        this.dataDirs.add(dataDir);
    }

    public void addDataDir(String dataDir) {
        this.addDataDir(new File(dataDir));
    }

    public File[] getDataDirs() {
        Object[] dirs = new File[this.dataDirs.size()];
        this.dataDirs.copyInto(dirs);
        return dirs;
    }

    public void setDirectDatabaseIO(boolean directDatabaseIO) {
        this.directDatabaseIO = directDatabaseIO;
    }

    public boolean getDirectDatabaseIO() {
        return this.directDatabaseIO;
    }

    public void setDirectLogIO(boolean directLogIO) {
        this.directLogIO = directLogIO;
    }

    public boolean getDirectLogIO() {
        return this.directLogIO;
    }

    public void setDsyncDatabases(boolean dsyncDatabases) {
        this.dsyncDatabases = dsyncDatabases;
    }

    public boolean getDsyncDatabases() {
        return this.dsyncDatabases;
    }

    public void setDsyncLog(boolean dsyncLog) {
        this.dsyncLog = dsyncLog;
    }

    public boolean getDsyncLog() {
        return this.dsyncLog;
    }

    public void setEncrypted(String password) {
        this.password = password;
    }

    public boolean getEncrypted() {
        return this.password != null;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorPrefix(String errorPrefix) {
        this.errorPrefix = errorPrefix;
    }

    public String getErrorPrefix() {
        return this.errorPrefix;
    }

    public void setErrorStream(OutputStream errorStream) {
        this.errorStream = errorStream;
    }

    public OutputStream getErrorStream() {
        return this.errorStream;
    }

    public void setFeedbackHandler(FeedbackHandler feedbackHandler) {
        this.feedbackHandler = feedbackHandler;
    }

    public FeedbackHandler getFeedbackHandler() {
        return this.feedbackHandler;
    }

    public void setInitializeCache(boolean initializeCache) {
        this.initializeCache = initializeCache;
    }

    public boolean getInitializeCache() {
        return this.initializeCache;
    }

    public void setInitializeCDB(boolean initializeCDB) {
        this.initializeCDB = initializeCDB;
    }

    public boolean getInitializeCDB() {
        return this.initializeCDB;
    }

    public void setInitializeLocking(boolean initializeLocking) {
        this.initializeLocking = initializeLocking;
    }

    public boolean getInitializeLocking() {
        return this.initializeLocking;
    }

    public void setInitializeLogging(boolean initializeLogging) {
        this.initializeLogging = initializeLogging;
    }

    public boolean getInitializeLogging() {
        return this.initializeLogging;
    }

    public void setInitializeRegions(boolean initializeRegions) {
        this.initializeRegions = initializeRegions;
    }

    public boolean getInitializeRegions() {
        return this.initializeRegions;
    }

    public void setInitializeReplication(boolean initializeReplication) {
        this.initializeReplication = initializeReplication;
    }

    public boolean getInitializeReplication() {
        return this.initializeReplication;
    }

    public void setJoinEnvironment(boolean joinEnvironment) {
        this.joinEnvironment = joinEnvironment;
    }

    public boolean getJoinEnvironment() {
        return this.joinEnvironment;
    }

    public void setLockConflicts(byte[][] lockConflicts) {
        this.lockConflicts = lockConflicts;
    }

    public byte[][] getLockConflicts() {
        return this.lockConflicts;
    }

    public void setLockDetectMode(LockDetectMode lockDetectMode) {
        this.lockDetectMode = lockDetectMode;
    }

    public LockDetectMode getLockDetectMode() {
        return this.lockDetectMode;
    }

    public void setLockDown(boolean lockDown) {
        this.lockDown = lockDown;
    }

    public boolean getLockDown() {
        return this.lockDown;
    }

    public void setLockTimeout(long lockTimeout) {
        this.lockTimeout = lockTimeout;
    }

    public long getLockTimeout() {
        return this.lockTimeout;
    }

    public void setLogAutoRemove(boolean logAutoRemove) {
        this.logAutoRemove = logAutoRemove;
    }

    public boolean getLogAutoRemove() {
        return this.logAutoRemove;
    }

    public void setLogInMemory(boolean logInMemory) {
        this.logInMemory = logInMemory;
    }

    public boolean getLogInMemory() {
        return this.logInMemory;
    }

    public void setLogRecordHandler(LogRecordHandler logRecordHandler) {
        this.logRecordHandler = logRecordHandler;
    }

    public LogRecordHandler getLogRecordHandler() {
        return this.logRecordHandler;
    }

    public void setEventHandler(EventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public EventHandler getEventHandler() {
        return this.eventHandler;
    }

    public void setReplicationManagerAckPolicy(ReplicationManagerAckPolicy repmgrAckPolicy) {
        this.repmgrAckPolicy = repmgrAckPolicy;
    }

    public ReplicationManagerAckPolicy getReplicationManagerAckPolicy() {
        return this.repmgrAckPolicy;
    }

    public void setReplicationManagerLocalSite(ReplicationHostAddress repmgrLocalSiteAddr) {
        this.repmgrLocalSiteAddr = repmgrLocalSiteAddr;
    }

    public ReplicationHostAddress getReplicationManagerLocalSite() {
        return this.repmgrLocalSiteAddr;
    }

    public void replicationManagerAddRemoteSite(ReplicationHostAddress repmgrRemoteAddr) {
        this.repmgrRemoteSites.add(repmgrRemoteAddr);
    }

    public void setMaxLocks(int maxLocks) {
        this.maxLocks = maxLocks;
    }

    public int getMaxLocks() {
        return this.maxLocks;
    }

    public void setMaxLockers(int maxLockers) {
        this.maxLockers = maxLockers;
    }

    public int getMaxLockers() {
        return this.maxLockers;
    }

    public void setMaxLockObjects(int maxLockObjects) {
        this.maxLockObjects = maxLockObjects;
    }

    public int getMaxLockObjects() {
        return this.maxLockObjects;
    }

    public void setMaxLogFileSize(int maxLogFileSize) {
        this.maxLogFileSize = maxLogFileSize;
    }

    public int getMaxLogFileSize() {
        return this.maxLogFileSize;
    }

    public void setLogBufferSize(int logBufferSize) {
        this.logBufferSize = logBufferSize;
    }

    public int getLogBufferSize() {
        return this.logBufferSize;
    }

    public void setLogDirectory(File logDirectory) {
        this.logDirectory = logDirectory;
    }

    public File getLogDirectory() {
        return this.logDirectory;
    }

    public void setLogFileMode(int logFileMode) {
        this.logFileMode = logFileMode;
    }

    public int getLogFileMode() {
        return this.logFileMode;
    }

    public void setLogRegionSize(int logRegionSize) {
        this.logRegionSize = logRegionSize;
    }

    public int getLogRegionSize() {
        return this.logRegionSize;
    }

    public void setMaxOpenFiles(int maxOpenFiles) {
        this.maxOpenFiles = maxOpenFiles;
    }

    public int getMaxOpenFiles() {
        return this.maxOpenFiles;
    }

    public void setMaxWrite(int maxWrite, long maxWriteSleep) {
        this.maxWrite = maxWrite;
        this.maxWriteSleep = maxWriteSleep;
    }

    public int getMaxWrite() {
        return this.maxWrite;
    }

    public long getMaxWriteSleep() {
        return this.maxWriteSleep;
    }

    public void setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public void setMessageStream(OutputStream messageStream) {
        this.messageStream = messageStream;
    }

    public OutputStream getMessageStream() {
        return this.messageStream;
    }

    public void setMMapSize(long mmapSize) {
        this.mmapSize = mmapSize;
    }

    public long getMMapSize() {
        return this.mmapSize;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public long getMode() {
        return this.mode;
    }

    public void setMultiversion(boolean multiversion) {
        this.multiversion = multiversion;
    }

    public boolean getMultiversion() {
        return this.multiversion;
    }

    public void setNoLocking(boolean noLocking) {
        this.noLocking = noLocking;
    }

    public boolean getNoLocking() {
        return this.noLocking;
    }

    public void setNoMMap(boolean noMMap) {
        this.noMMap = noMMap;
    }

    public boolean getNoMMap() {
        return this.noMMap;
    }

    public void setNoPanic(boolean noPanic) {
        this.noPanic = noPanic;
    }

    public boolean getNoPanic() {
        return this.noPanic;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public void setPanicHandler(PanicHandler panicHandler) {
        this.panicHandler = panicHandler;
    }

    public PanicHandler getPanicHandler() {
        return this.panicHandler;
    }

    public void setPrivate(boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    public boolean getPrivate() {
        return this.isPrivate;
    }

    public void setReplicationLease(int replicationLease) {
        this.replicationLease = replicationLease;
    }

    public int getReplicationLease() {
        return this.replicationLease;
    }

    public void setReplicationLimit(long replicationLimit) {
        this.replicationLimit = replicationLimit;
    }

    public long getReplicationLimit() {
        return this.replicationLimit;
    }

    public void setReplicationRequestMin(int replicationRequestMin) {
        this.replicationRequestMin = replicationRequestMin;
    }

    public int getReplicationRequestMin() {
        return this.replicationRequestMin;
    }

    public void setReplicationRequestMax(int replicationRequestMax) {
        this.replicationRequestMax = replicationRequestMax;
    }

    public int getReplicationRequestMax() {
        return this.replicationRequestMax;
    }

    public void setReplicationTransport(int envid, ReplicationTransport replicationTransport) {
        this.envid = envid;
        this.replicationTransport = replicationTransport;
    }

    public ReplicationTransport getReplicationTransport() {
        return this.replicationTransport;
    }

    public void setRegister(boolean register) {
        this.register = register;
    }

    public boolean getRegister() {
        return this.register;
    }

    public void setRunFatalRecovery(boolean runFatalRecovery) {
        this.runFatalRecovery = runFatalRecovery;
    }

    public boolean getRunFatalRecovery() {
        return this.runFatalRecovery;
    }

    public void setRunRecovery(boolean runRecovery) {
        this.runRecovery = runRecovery;
    }

    public boolean getRunRecovery() {
        return this.runRecovery;
    }

    public void setSystemMemory(boolean systemMemory) {
        this.systemMemory = systemMemory;
    }

    public boolean getSystemMemory() {
        return this.systemMemory;
    }

    public void setRPCServer(String rpcServer, long rpcClientTimeout, long rpcServerTimeout) {
        this.rpcServer = rpcServer;
        this.rpcClientTimeout = rpcClientTimeout;
        this.rpcServerTimeout = rpcServerTimeout;
        this.threaded = false;
    }

    public void setSegmentId(long segmentId) {
        this.segmentId = segmentId;
    }

    public long getSegmentId() {
        return this.segmentId;
    }

    public void setTemporaryDirectory(File temporaryDirectory) {
        this.temporaryDirectory = temporaryDirectory;
    }

    public void setTemporaryDirectory(String temporaryDirectory) {
        this.setTemporaryDirectory(new File(temporaryDirectory));
    }

    public File getTemporaryDirectory() {
        return this.temporaryDirectory;
    }

    public void setMutexAlignment(int mutexAlignment) {
        this.mutexAlignment = mutexAlignment;
    }

    public int getMutexAlignment() {
        return this.mutexAlignment;
    }

    public void setMutexIncrement(int mutexIncrement) {
        this.mutexIncrement = mutexIncrement;
    }

    public int getMutexIncrement() {
        return this.mutexIncrement;
    }

    public void setMaxMutexes(int maxMutexes) {
        this.maxMutexes = maxMutexes;
    }

    public int getMaxMutexes() {
        return this.maxMutexes;
    }

    public void setMutexTestAndSetSpins(int mutexTestAndSetSpins) {
        this.mutexTestAndSetSpins = mutexTestAndSetSpins;
    }

    public int getMutexTestAndSetSpins() {
        return this.mutexTestAndSetSpins;
    }

    public void setReplicationNumSites(int replicationNSites) {
        this.replicationNSites = replicationNSites;
    }

    public int getReplicationNumSites() {
        return this.replicationNSites;
    }

    public void setReplicationPriority(int replicationPriority) {
        this.replicationPriority = replicationPriority;
    }

    public int getReplicationPriority() {
        return this.replicationPriority;
    }

    public void setTestAndSetSpins(int mutexTestAndSetSpins) {
        this.setMutexTestAndSetSpins(mutexTestAndSetSpins);
    }

    public int getTestAndSetSpins() {
        return this.getMutexTestAndSetSpins();
    }

    public void setThreaded(boolean threaded) {
        this.threaded = threaded;
    }

    public boolean getThreaded() {
        return this.threaded;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    public boolean getTransactional() {
        return this.transactional;
    }

    public void setTxnNoSync(boolean txnNoSync) {
        this.txnNoSync = txnNoSync;
    }

    public boolean getTxnNoSync() {
        return this.txnNoSync;
    }

    public void setTxnNoWait(boolean txnNoWait) {
        this.txnNoWait = txnNoWait;
    }

    public boolean getTxnNoWait() {
        return this.txnNoWait;
    }

    public void setTxnNotDurable(boolean txnNotDurable) {
        this.txnNotDurable = txnNotDurable;
    }

    public boolean getTxnNotDurable() {
        return this.txnNotDurable;
    }

    public void setTxnSnapshot(boolean txnSnapshot) {
        this.txnSnapshot = txnSnapshot;
    }

    public boolean getTxnSnapshot() {
        return this.txnSnapshot;
    }

    public void setTxnMaxActive(int txnMaxActive) {
        this.txnMaxActive = txnMaxActive;
    }

    public int getTxnMaxActive() {
        return this.txnMaxActive;
    }

    public void setTxnTimeout(long txnTimeout) {
        this.txnTimeout = txnTimeout;
    }

    public long getTxnTimeout() {
        return this.txnTimeout;
    }

    public void setTxnTimestamp(Date txnTimestamp) {
        this.txnTimestamp = txnTimestamp;
    }

    public Date getTxnTimestamp() {
        return this.txnTimestamp;
    }

    public void setTxnWriteNoSync(boolean txnWriteNoSync) {
        this.txnWriteNoSync = txnWriteNoSync;
    }

    public boolean getTxnWriteNoSync() {
        return this.txnWriteNoSync;
    }

    public void setUseEnvironment(boolean useEnvironment) {
        this.useEnvironment = useEnvironment;
    }

    public boolean getUseEnvironment() {
        return this.useEnvironment;
    }

    public void setUseEnvironmentRoot(boolean useEnvironmentRoot) {
        this.useEnvironmentRoot = useEnvironmentRoot;
    }

    public boolean getUseEnvironmentRoot() {
        return this.useEnvironmentRoot;
    }

    public void setVerbose(VerboseConfig flag, boolean enable) {
        int iflag = flag.getInternalFlag();
        switch (iflag) {
            case 1: {
                this.verboseDeadlock = enable;
                break;
            }
            case 2: {
                this.verboseFileops = enable;
                break;
            }
            case 4: {
                this.verboseFileopsAll = enable;
                break;
            }
            case 8: {
                this.verboseRecovery = enable;
                break;
            }
            case 16: {
                this.verboseRegister = enable;
                break;
            }
            case 32: {
                this.verboseReplication = enable;
                break;
            }
            case 64: {
                this.verboseWaitsFor = enable;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown verbose flag: " + DbEnv.strerror(iflag));
            }
        }
    }

    public boolean getVerbose(VerboseConfig flag) {
        int iflag = flag.getInternalFlag();
        switch (iflag) {
            case 1: {
                return this.verboseDeadlock;
            }
            case 2: {
                return this.verboseFileops;
            }
            case 4: {
                return this.verboseFileopsAll;
            }
            case 8: {
                return this.verboseRecovery;
            }
            case 16: {
                return this.verboseRegister;
            }
            case 32: {
                return this.verboseReplication;
            }
            case 64: {
                return this.verboseWaitsFor;
            }
        }
        throw new IllegalArgumentException("Unknown verbose flag: " + DbEnv.strerror(iflag));
    }

    public void setVerboseDeadlock(boolean verboseDeadlock) {
        this.verboseDeadlock = verboseDeadlock;
    }

    public boolean getVerboseDeadlock() {
        return this.verboseDeadlock;
    }

    public void setVerboseRecovery(boolean verboseRecovery) {
        this.verboseRecovery = verboseRecovery;
    }

    public boolean getVerboseRecovery() {
        return this.verboseRecovery;
    }

    public void setVerboseRegister(boolean verboseRegister) {
        this.verboseRegister = verboseRegister;
    }

    public boolean getVerboseRegister() {
        return this.verboseRegister;
    }

    public void setVerboseReplication(boolean verboseReplication) {
        this.verboseReplication = verboseReplication;
    }

    public boolean getVerboseReplication() {
        return this.verboseReplication;
    }

    public void setVerboseWaitsFor(boolean verboseWaitsFor) {
        this.verboseWaitsFor = verboseWaitsFor;
    }

    public boolean getVerboseWaitsFor() {
        return this.verboseWaitsFor;
    }

    public void setYieldCPU(boolean yieldCPU) {
        this.yieldCPU = yieldCPU;
    }

    public boolean getYieldCPU() {
        return this.yieldCPU;
    }

    private boolean lockConflictsEqual(byte[][] lc1, byte[][] lc2) {
        if (lc1 == lc2) {
            return true;
        }
        if (lc1 == null || lc2 == null || lc1.length != lc2.length) {
            return false;
        }
        for (int i = 0; i < lc1.length; ++i) {
            if (lc1[i].length != lc2[i].length) {
                return false;
            }
            for (int j = 0; j < lc1[i].length; ++j) {
                if (lc1[i][j] == lc2[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DbEnv openEnvironment(File home) throws DatabaseException, FileNotFoundException {
        DbEnv dbenv = this.createEnvironment();
        int openFlags = 0;
        openFlags |= this.allowCreate ? 1 : 0;
        openFlags |= this.initializeCache ? 524288 : 0;
        openFlags |= this.initializeCDB ? 65536 : 0;
        openFlags |= this.initializeLocking ? 131072 : 0;
        openFlags |= this.initializeLogging ? 262144 : 0;
        openFlags |= this.initializeReplication ? 0x100000 : 0;
        openFlags |= this.joinEnvironment ? 0 : 0;
        openFlags |= this.lockDown ? 0x400000 : 0;
        openFlags |= this.isPrivate ? 0x800000 : 0;
        openFlags |= this.register ? 0x2000000 : 0;
        openFlags |= this.runRecovery ? 64 : 0;
        openFlags |= this.runFatalRecovery ? 0x1000000 : 0;
        openFlags |= this.systemMemory ? 0x4000000 : 0;
        openFlags |= this.threaded ? 128 : 0;
        openFlags |= this.transactional ? 0x200000 : 0;
        openFlags |= this.useEnvironment ? 16384 : 0;
        openFlags |= this.useEnvironmentRoot ? 32768 : 0;
        boolean succeeded = false;
        try {
            dbenv.open(home == null ? null : home.toString(), openFlags, this.mode);
            succeeded = true;
            DbEnv dbEnv = dbenv;
            return dbEnv;
        }
        finally {
            if (!succeeded) {
                try {
                    dbenv.close(0);
                }
                catch (Throwable t) {}
            }
        }
    }

    DbEnv createEnvironment() throws DatabaseException {
        int createFlags = 0;
        if (this.rpcServer != null) {
            createFlags |= 2;
        }
        DbEnv dbenv = new DbEnv(createFlags);
        this.configureEnvironment(dbenv, DEFAULT);
        return dbenv;
    }

    void configureEnvironment(DbEnv dbenv, EnvironmentConfig oldConfig) throws DatabaseException {
        if (this.errorHandler != oldConfig.errorHandler) {
            dbenv.set_errcall(this.errorHandler);
        }
        if (this.errorPrefix != oldConfig.errorPrefix && this.errorPrefix != null && !this.errorPrefix.equals(oldConfig.errorPrefix)) {
            dbenv.set_errpfx(this.errorPrefix);
        }
        if (this.errorStream != oldConfig.errorStream) {
            dbenv.set_error_stream(this.errorStream);
        }
        if (this.rpcServer != oldConfig.rpcServer || this.rpcClientTimeout != oldConfig.rpcClientTimeout || this.rpcServerTimeout != oldConfig.rpcServerTimeout) {
            dbenv.set_rpc_server(this.rpcServer, this.rpcClientTimeout, this.rpcServerTimeout, 0);
        }
        int onFlags = 0x40000000;
        int offFlags = 0;
        if (this.cdbLockAllDatabases && !oldConfig.cdbLockAllDatabases) {
            onFlags |= 0x4000;
        }
        if (!this.cdbLockAllDatabases && oldConfig.cdbLockAllDatabases) {
            offFlags |= 0x4000;
        }
        if (this.directDatabaseIO && !oldConfig.directDatabaseIO) {
            onFlags |= 0x8000;
        }
        if (!this.directDatabaseIO && oldConfig.directDatabaseIO) {
            offFlags |= 0x8000;
        }
        if (this.directLogIO && !oldConfig.directLogIO) {
            onFlags |= 0x10000;
        }
        if (!this.directLogIO && oldConfig.directLogIO) {
            offFlags |= 0x10000;
        }
        if (this.dsyncDatabases && !oldConfig.dsyncDatabases) {
            onFlags |= 0x20000;
        }
        if (!this.dsyncDatabases && oldConfig.dsyncDatabases) {
            offFlags |= 0x20000;
        }
        if (this.dsyncLog && !oldConfig.dsyncLog) {
            onFlags |= 0x40000;
        }
        if (!this.dsyncLog && oldConfig.dsyncLog) {
            offFlags |= 0x40000;
        }
        if (this.initializeRegions && !oldConfig.initializeRegions) {
            onFlags |= 0x20000000;
        }
        if (!this.initializeRegions && oldConfig.initializeRegions) {
            offFlags |= 0x20000000;
        }
        if (this.logAutoRemove && !oldConfig.logAutoRemove) {
            onFlags |= 0x80000;
        }
        if (!this.logAutoRemove && oldConfig.logAutoRemove) {
            offFlags |= 0x80000;
        }
        if (this.logInMemory && !oldConfig.logInMemory) {
            onFlags |= 0x100000;
        }
        if (!this.logInMemory && oldConfig.logInMemory) {
            offFlags |= 0x100000;
        }
        if (this.multiversion && !oldConfig.multiversion) {
            onFlags |= 8;
        }
        if (!this.multiversion && oldConfig.multiversion) {
            offFlags |= 8;
        }
        if (this.noLocking && !oldConfig.noLocking) {
            onFlags |= 0x200000;
        }
        if (!this.noLocking && oldConfig.noLocking) {
            offFlags |= 0x200000;
        }
        if (this.noMMap && !oldConfig.noMMap) {
            onFlags |= 0x10;
        }
        if (!this.noMMap && oldConfig.noMMap) {
            offFlags |= 0x10;
        }
        if (this.noPanic && !oldConfig.noPanic) {
            onFlags |= 0x400000;
        }
        if (!this.noPanic && oldConfig.noPanic) {
            offFlags |= 0x400000;
        }
        if (this.overwrite && !oldConfig.overwrite) {
            onFlags |= 0x800000;
        }
        if (!this.overwrite && oldConfig.overwrite) {
            offFlags |= 0x800000;
        }
        if (this.txnNoSync && !oldConfig.txnNoSync) {
            onFlags |= 0x200;
        }
        if (!this.txnNoSync && oldConfig.txnNoSync) {
            offFlags |= 0x200;
        }
        if (this.txnNoWait && !oldConfig.txnNoWait) {
            onFlags |= 0x400;
        }
        if (!this.txnNoWait && oldConfig.txnNoWait) {
            offFlags |= 0x400;
        }
        if (this.txnNotDurable && !oldConfig.txnNotDurable) {
            onFlags |= 0x800;
        }
        if (!this.txnNotDurable && oldConfig.txnNotDurable) {
            offFlags |= 0x800;
        }
        if (this.txnSnapshot && !oldConfig.txnSnapshot) {
            onFlags |= 0x10000000;
        }
        if (!this.txnSnapshot && oldConfig.txnSnapshot) {
            offFlags |= 0x10000000;
        }
        if (this.txnWriteNoSync && !oldConfig.txnWriteNoSync) {
            onFlags |= 0x1000;
        }
        if (!this.txnWriteNoSync && oldConfig.txnWriteNoSync) {
            offFlags |= 0x1000;
        }
        if (this.yieldCPU && !oldConfig.yieldCPU) {
            onFlags |= Integer.MIN_VALUE;
        }
        if (!this.yieldCPU && oldConfig.yieldCPU) {
            offFlags |= Integer.MIN_VALUE;
        }
        if (onFlags != 0) {
            dbenv.set_flags(onFlags, true);
        }
        if (offFlags != 0) {
            dbenv.set_flags(offFlags, false);
        }
        if (this.verboseDeadlock && !oldConfig.verboseDeadlock) {
            dbenv.set_verbose(1, true);
        }
        if (!this.verboseDeadlock && oldConfig.verboseDeadlock) {
            dbenv.set_verbose(1, false);
        }
        if (this.verboseFileops && !oldConfig.verboseFileops) {
            dbenv.set_verbose(2, true);
        }
        if (!this.verboseFileops && oldConfig.verboseFileops) {
            dbenv.set_verbose(2, false);
        }
        if (this.verboseFileopsAll && !oldConfig.verboseFileopsAll) {
            dbenv.set_verbose(4, true);
        }
        if (!this.verboseFileopsAll && oldConfig.verboseFileopsAll) {
            dbenv.set_verbose(4, false);
        }
        if (this.verboseRecovery && !oldConfig.verboseRecovery) {
            dbenv.set_verbose(8, true);
        }
        if (!this.verboseRecovery && oldConfig.verboseRecovery) {
            dbenv.set_verbose(8, false);
        }
        if (this.verboseRegister && !oldConfig.verboseRegister) {
            dbenv.set_verbose(16, true);
        }
        if (!this.verboseRegister && oldConfig.verboseRegister) {
            dbenv.set_verbose(16, false);
        }
        if (this.verboseReplication && !oldConfig.verboseReplication) {
            dbenv.set_verbose(32, true);
        }
        if (!this.verboseReplication && oldConfig.verboseReplication) {
            dbenv.set_verbose(32, false);
        }
        if (this.verboseWaitsFor && !oldConfig.verboseWaitsFor) {
            dbenv.set_verbose(64, true);
        }
        if (!this.verboseWaitsFor && oldConfig.verboseWaitsFor) {
            dbenv.set_verbose(64, false);
        }
        if (this.feedbackHandler != oldConfig.feedbackHandler) {
            dbenv.set_feedback(this.feedbackHandler);
        }
        if (this.logRecordHandler != oldConfig.logRecordHandler) {
            dbenv.set_app_dispatch(this.logRecordHandler);
        }
        if (this.eventHandler != oldConfig.eventHandler) {
            dbenv.set_event_notify(this.eventHandler);
        }
        if (this.messageHandler != oldConfig.messageHandler) {
            dbenv.set_msgcall(this.messageHandler);
        }
        if (this.panicHandler != oldConfig.panicHandler) {
            dbenv.set_paniccall(this.panicHandler);
        }
        if (this.replicationTransport != oldConfig.replicationTransport) {
            dbenv.rep_set_transport(this.envid, this.replicationTransport);
        }
        if (this.cacheSize != oldConfig.cacheSize || this.cacheCount != oldConfig.cacheCount) {
            dbenv.set_cachesize(this.cacheSize, this.cacheCount);
        }
        if (this.cacheMax != oldConfig.cacheMax) {
            dbenv.set_cache_max(this.cacheMax);
        }
        Enumeration e = this.dataDirs.elements();
        while (e.hasMoreElements()) {
            File dir = (File)e.nextElement();
            if (oldConfig.dataDirs.contains(dir)) continue;
            dbenv.set_data_dir(dir.toString());
        }
        if (!this.lockConflictsEqual(this.lockConflicts, oldConfig.lockConflicts)) {
            dbenv.set_lk_conflicts(this.lockConflicts);
        }
        if (this.lockDetectMode != oldConfig.lockDetectMode) {
            dbenv.set_lk_detect(this.lockDetectMode.getFlag());
        }
        if (this.maxLocks != oldConfig.maxLocks) {
            dbenv.set_lk_max_locks(this.maxLocks);
        }
        if (this.maxLockers != oldConfig.maxLockers) {
            dbenv.set_lk_max_lockers(this.maxLockers);
        }
        if (this.maxLockObjects != oldConfig.maxLockObjects) {
            dbenv.set_lk_max_objects(this.maxLockObjects);
        }
        if (this.maxLogFileSize != oldConfig.maxLogFileSize) {
            dbenv.set_lg_max(this.maxLogFileSize);
        }
        if (this.logBufferSize != oldConfig.logBufferSize) {
            dbenv.set_lg_bsize(this.logBufferSize);
        }
        if (this.logDirectory != oldConfig.logDirectory && this.logDirectory != null && !this.logDirectory.equals(oldConfig.logDirectory)) {
            dbenv.set_lg_dir(this.logDirectory.toString());
        }
        if (this.logFileMode != oldConfig.logFileMode) {
            dbenv.set_lg_filemode(this.logFileMode);
        }
        if (this.logRegionSize != oldConfig.logRegionSize) {
            dbenv.set_lg_regionmax(this.logRegionSize);
        }
        if (this.maxOpenFiles != oldConfig.maxOpenFiles) {
            dbenv.set_mp_max_openfd(this.maxOpenFiles);
        }
        if (this.maxWrite != oldConfig.maxWrite || this.maxWriteSleep != oldConfig.maxWriteSleep) {
            dbenv.set_mp_max_write(this.maxWrite, this.maxWriteSleep);
        }
        if (this.messageStream != oldConfig.messageStream) {
            dbenv.set_message_stream(this.messageStream);
        }
        if (this.mmapSize != oldConfig.mmapSize) {
            dbenv.set_mp_mmapsize(this.mmapSize);
        }
        if (this.password != null) {
            dbenv.set_encrypt(this.password, 1);
        }
        if (this.replicationLease != oldConfig.replicationLease) {
            dbenv.rep_set_lease(this.replicationLease, 0);
        }
        if (this.replicationLimit != oldConfig.replicationLimit) {
            dbenv.rep_set_limit(this.replicationLimit);
        }
        if (this.replicationRequestMin != oldConfig.replicationRequestMin || this.replicationRequestMax != oldConfig.replicationRequestMax) {
            dbenv.set_rep_request(this.replicationRequestMin, this.replicationRequestMax);
        }
        if (this.segmentId != oldConfig.segmentId) {
            dbenv.set_shm_key(this.segmentId);
        }
        if (this.mutexAlignment != oldConfig.mutexAlignment) {
            dbenv.mutex_set_align(this.mutexAlignment);
        }
        if (this.mutexIncrement != oldConfig.mutexIncrement) {
            dbenv.mutex_set_increment(this.mutexIncrement);
        }
        if (this.maxMutexes != oldConfig.maxMutexes) {
            dbenv.mutex_set_max(this.maxMutexes);
        }
        if (this.mutexTestAndSetSpins != oldConfig.mutexTestAndSetSpins) {
            dbenv.mutex_set_tas_spins(this.mutexTestAndSetSpins);
        }
        if (this.replicationNSites != oldConfig.replicationNSites) {
            dbenv.rep_set_nsites(this.replicationNSites);
        }
        if (this.replicationPriority != oldConfig.replicationPriority) {
            dbenv.rep_set_priority(this.replicationPriority);
        }
        if (this.lockTimeout != oldConfig.lockTimeout) {
            dbenv.set_timeout(this.lockTimeout, 1);
        }
        if (this.txnMaxActive != oldConfig.txnMaxActive) {
            dbenv.set_tx_max(this.txnMaxActive);
        }
        if (this.txnTimeout != oldConfig.txnTimeout) {
            dbenv.set_timeout(this.txnTimeout, 3);
        }
        if (this.txnTimestamp != oldConfig.txnTimestamp && this.txnTimestamp != null && !this.txnTimestamp.equals(oldConfig.txnTimestamp)) {
            dbenv.set_tx_timestamp(this.txnTimestamp);
        }
        if (this.temporaryDirectory != oldConfig.temporaryDirectory && this.temporaryDirectory != null && !this.temporaryDirectory.equals(oldConfig.temporaryDirectory)) {
            dbenv.set_tmp_dir(this.temporaryDirectory.toString());
        }
        if (this.repmgrAckPolicy != oldConfig.repmgrAckPolicy) {
            dbenv.repmgr_set_ack_policy(this.repmgrAckPolicy.getId());
        }
        if (this.repmgrLocalSiteAddr != oldConfig.repmgrLocalSiteAddr) {
            dbenv.repmgr_set_local_site(this.repmgrLocalSiteAddr.host, this.repmgrLocalSiteAddr.port, 0);
        }
        Enumeration elems = this.repmgrRemoteSites.elements();
        while (elems.hasMoreElements()) {
            ReplicationHostAddress nextAddr = (ReplicationHostAddress)elems.nextElement();
            dbenv.repmgr_add_remote_site(nextAddr.host, nextAddr.port, nextAddr.isPeer ? 1 : 0);
        }
    }

    EnvironmentConfig(DbEnv dbenv) throws DatabaseException {
        String[] dataDirArray;
        int openFlags = dbenv.get_open_flags();
        this.allowCreate = (openFlags & 1) != 0;
        this.initializeCache = (openFlags & 0x80000) != 0;
        this.initializeCDB = (openFlags & 0x10000) != 0;
        this.initializeLocking = (openFlags & 0x20000) != 0;
        this.initializeLogging = (openFlags & 0x40000) != 0;
        this.initializeReplication = (openFlags & 0x100000) != 0;
        this.joinEnvironment = (openFlags & 0) != 0;
        this.lockDown = (openFlags & 0x400000) != 0;
        this.isPrivate = (openFlags & 0x800000) != 0;
        this.register = (openFlags & 0x2000000) != 0;
        this.runRecovery = (openFlags & 0x40) != 0;
        this.runFatalRecovery = (openFlags & 0x1000000) != 0;
        this.systemMemory = (openFlags & 0x4000000) != 0;
        this.threaded = (openFlags & 0x80) != 0;
        this.transactional = (openFlags & 0x200000) != 0;
        this.useEnvironment = (openFlags & 0x4000) != 0;
        this.useEnvironmentRoot = (openFlags & 0x8000) != 0;
        int envFlags = dbenv.get_flags();
        this.cdbLockAllDatabases = (envFlags & 0x4000) != 0;
        this.directDatabaseIO = (envFlags & 0x8000) != 0;
        this.directLogIO = (envFlags & 0x10000) != 0;
        this.dsyncDatabases = (envFlags & 0x20000) != 0;
        this.dsyncLog = (envFlags & 0x40000) != 0;
        this.initializeRegions = (envFlags & 0x20000000) != 0;
        this.logAutoRemove = (envFlags & 0x80000) != 0;
        this.logInMemory = (envFlags & 0x100000) != 0;
        this.multiversion = (envFlags & 8) != 0;
        this.noLocking = (envFlags & 0x200000) != 0;
        this.noMMap = (envFlags & 0x10) != 0;
        this.noPanic = (envFlags & 0x400000) != 0;
        this.overwrite = (envFlags & 0x800000) != 0;
        this.txnNoSync = (envFlags & 0x200) != 0;
        this.txnNoWait = (envFlags & 0x400) != 0;
        this.txnNotDurable = (envFlags & 0x800) != 0;
        this.txnSnapshot = (envFlags & 0x10000000) != 0;
        this.txnWriteNoSync = (envFlags & 0x1000) != 0;
        this.yieldCPU = (envFlags & Integer.MIN_VALUE) != 0;
        this.verboseDeadlock = dbenv.get_verbose(1);
        this.verboseFileops = dbenv.get_verbose(2);
        this.verboseFileopsAll = dbenv.get_verbose(4);
        this.verboseRecovery = dbenv.get_verbose(8);
        this.verboseRegister = dbenv.get_verbose(16);
        this.verboseReplication = dbenv.get_verbose(32);
        this.verboseWaitsFor = dbenv.get_verbose(64);
        this.errorHandler = dbenv.get_errcall();
        this.feedbackHandler = dbenv.get_feedback();
        this.logRecordHandler = dbenv.get_app_dispatch();
        this.eventHandler = dbenv.get_event_notify();
        this.messageHandler = dbenv.get_msgcall();
        this.panicHandler = dbenv.get_paniccall();
        if (this.initializeCache) {
            this.cacheSize = dbenv.get_cachesize();
            this.cacheMax = dbenv.get_cache_max();
            this.cacheCount = dbenv.get_cachesize_ncache();
            this.mmapSize = dbenv.get_mp_mmapsize();
            this.maxOpenFiles = dbenv.get_mp_max_openfd();
            this.maxWrite = dbenv.get_mp_max_write();
            this.maxWriteSleep = dbenv.get_mp_max_write_sleep();
        }
        if ((dataDirArray = dbenv.get_data_dirs()) == null) {
            dataDirArray = new String[]{};
        }
        this.dataDirs = new Vector(dataDirArray.length);
        this.dataDirs.setSize(dataDirArray.length);
        for (int i = 0; i < dataDirArray.length; ++i) {
            this.dataDirs.set(i, new File(dataDirArray[i]));
        }
        this.errorPrefix = dbenv.get_errpfx();
        this.errorStream = dbenv.get_error_stream();
        if (this.initializeLocking) {
            this.lockConflicts = dbenv.get_lk_conflicts();
            this.lockDetectMode = LockDetectMode.fromFlag(dbenv.get_lk_detect());
            this.lockTimeout = dbenv.get_timeout(1);
            this.maxLocks = dbenv.get_lk_max_locks();
            this.maxLockers = dbenv.get_lk_max_lockers();
            this.maxLockObjects = dbenv.get_lk_max_objects();
            this.txnTimeout = dbenv.get_timeout(3);
        } else {
            this.lockConflicts = null;
            this.lockDetectMode = LockDetectMode.NONE;
            this.lockTimeout = 0L;
            this.maxLocks = 0;
            this.maxLockers = 0;
            this.maxLockObjects = 0;
            this.txnTimeout = 0L;
        }
        if (this.initializeLogging) {
            this.maxLogFileSize = dbenv.get_lg_max();
            this.logBufferSize = dbenv.get_lg_bsize();
            this.logDirectory = dbenv.get_lg_dir() == null ? null : new File(dbenv.get_lg_dir());
            this.logFileMode = dbenv.get_lg_filemode();
            this.logRegionSize = dbenv.get_lg_regionmax();
        } else {
            this.maxLogFileSize = 0;
            this.logBufferSize = 0;
            this.logDirectory = null;
            this.logRegionSize = 0;
        }
        this.messageStream = dbenv.get_message_stream();
        String string = this.password = dbenv.get_encrypt_flags() == 0 ? null : "";
        if (this.initializeReplication) {
            this.replicationLimit = dbenv.rep_get_limit();
            this.repmgrRemoteSites = new Vector<ReplicationHostAddress>(Arrays.asList(dbenv.repmgr_site_list()));
        } else {
            this.replicationLimit = 0L;
            this.replicationRequestMin = 0;
            this.replicationRequestMax = 0;
        }
        this.rpcServer = null;
        this.rpcClientTimeout = 0L;
        this.rpcServerTimeout = 0L;
        this.segmentId = dbenv.get_shm_key();
        this.mutexAlignment = dbenv.mutex_get_align();
        this.mutexIncrement = dbenv.mutex_get_increment();
        this.maxMutexes = dbenv.mutex_get_max();
        this.mutexTestAndSetSpins = dbenv.mutex_get_tas_spins();
        this.replicationNSites = dbenv.rep_get_nsites();
        this.replicationPriority = dbenv.rep_get_priority();
        if (this.transactional) {
            this.txnMaxActive = dbenv.get_tx_max();
            long txnTimestampSeconds = dbenv.get_tx_timestamp();
            this.txnTimestamp = txnTimestampSeconds != 0L ? new Date(txnTimestampSeconds * 1000L) : null;
        } else {
            this.txnMaxActive = 0;
            this.txnTimestamp = null;
        }
        this.temporaryDirectory = new File(dbenv.get_tmp_dir());
    }
}

