/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.xml;

import com.topologi.diffx.xml.XMLWriter;
import com.topologi.diffx.xml.XMLWriterBase;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public final class SimpleXMLWriter
extends XMLWriterBase
implements XMLWriter {
    private static final Element ROOT = new Element("", true);
    private List elements = new ArrayList();
    private boolean isNude = false;

    public SimpleXMLWriter(Writer writer) throws NullPointerException {
        super(writer, true);
        this.elements.add(ROOT);
    }

    public SimpleXMLWriter(Writer writer, boolean bl) throws NullPointerException {
        super(writer, bl);
        this.elements.add(ROOT);
    }

    public void writeComment(String string) throws IOException {
        this.deNude();
        super.writeComment(string);
    }

    public void writePI(String string, String string2) throws IOException {
        this.deNude();
        super.writePI(string, string2);
    }

    public void writeText(char c) throws IOException {
        this.deNude();
        this.writerEscape.writeText(c);
    }

    public void writeText(String string) throws IOException {
        if (string == null) {
            return;
        }
        this.deNude();
        this.writerEscape.writeText(string);
    }

    public void writeText(char[] cArray, int n, int n2) throws IOException {
        this.deNude();
        this.writerEscape.writeText(cArray, n, n2);
    }

    public void writeXML(String string) throws IOException {
        if (string == null) {
            return;
        }
        this.deNude();
        this.writer.write(string);
    }

    public void writeXML(char[] cArray, int n, int n2) throws IOException {
        this.deNude();
        this.writer.write(cArray, n, n2);
    }

    private void deNude() throws IOException {
        if (this.isNude) {
            this.writer.write(62);
            if (this.peekElement().hasChildren) {
                this.writer.write(10);
            }
            this.isNude = false;
        }
    }

    public void openElement(String string) throws IOException {
        this.openElement(string, false);
    }

    public void openElement(String string, boolean bl) throws IOException {
        this.deNude();
        this.indent();
        this.elements.add(new Element(string, bl));
        this.writer.write(60);
        this.writer.write(string);
        this.isNude = true;
        ++this.depth;
    }

    public void closeElement() throws IOException {
        Element element = this.popElement();
        --this.depth;
        if (this.isNude) {
            this.writer.write(47);
            this.isNude = false;
        } else {
            if (element.hasChildren) {
                this.indent();
            }
            this.writer.write(60);
            this.writer.write(47);
            int n = element.name.indexOf(32);
            if (n < 0) {
                this.writer.write(element.name);
            } else {
                this.writer.write(element.name.substring(0, n));
            }
        }
        this.writer.write(62);
    }

    public void emptyElement(String string) throws IOException {
        this.deNude();
        this.indent();
        this.writer.write(60);
        this.writer.write(string);
        this.writer.write(47);
        this.writer.write(62);
        this.writer.write(10);
    }

    private Element peekElement() {
        return (Element)this.elements.get(this.elements.size() - 1);
    }

    private Element popElement() {
        return (Element)this.elements.remove(this.elements.size() - 1);
    }

    public void attribute(String string, String string2) throws IOException, IllegalStateException {
        if (!this.isNude) {
            throw new IllegalArgumentException("Cannot write attribute: too late!");
        }
        this.writer.write(32);
        this.writer.write(string);
        this.writer.write("=\"");
        this.writerEscape.writeAttValue(string2);
        this.writer.write(34);
    }

    public void attribute(String string, int n) throws IOException, IllegalStateException {
        if (!this.isNude) {
            throw new IllegalArgumentException("Cannot write attribute: too late!");
        }
        this.writer.write(32);
        this.writer.write(string);
        this.writer.write("=\"");
        this.writer.write(Integer.toString(n));
        this.writer.write(34);
    }

    public void openElement(String string, String string2) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This class does not handle namespaces.");
    }

    public void openElement(String string, String string2, boolean bl) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This class does not handle namespaces.");
    }

    public void emptyElement(String string, String string2) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This class does not handle namespaces");
    }

    public void setPrefixMapping(String string, String string2) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This class does not handle namespaces");
    }

    public void attribute(String string, String string2, String string3) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This class does not handle namespaces");
    }

    public void attribute(String string, String string2, int n) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This class does not handle namespaces");
    }

    private static final class Element {
        private String name;
        private boolean hasChildren;

        public Element(String string, boolean bl) {
            this.name = string;
            this.hasChildren = bl;
        }
    }
}

