/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.dbxml;

import com.sleepycat.dbxml.XmlContainerConfig;
import com.sleepycat.dbxml.XmlDocument;
import com.sleepycat.dbxml.XmlDocumentConfig;
import com.sleepycat.dbxml.XmlEventReader;
import com.sleepycat.dbxml.XmlEventWriter;
import com.sleepycat.dbxml.XmlException;
import com.sleepycat.dbxml.XmlIndexSpecification;
import com.sleepycat.dbxml.XmlInputStream;
import com.sleepycat.dbxml.XmlManager;
import com.sleepycat.dbxml.XmlQueryContext;
import com.sleepycat.dbxml.XmlResults;
import com.sleepycat.dbxml.XmlStatistics;
import com.sleepycat.dbxml.XmlTransaction;
import com.sleepycat.dbxml.XmlUpdateContext;
import com.sleepycat.dbxml.XmlValue;
import com.sleepycat.dbxml.dbxml_javaJNI;

public class XmlContainer {
    private long swigCPtr;
    protected boolean swigCMemOwn;
    private XmlContainerConfig config;
    private XmlManager manager;
    public static final int WholedocContainer = 0;
    public static final int NodeContainer = 1;

    protected XmlContainer(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(XmlContainer obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            dbxml_javaJNI.delete_XmlContainer(this.swigCPtr);
        }
        this.swigCPtr = 0L;
    }

    public XmlContainerConfig getContainerConfig() throws XmlException {
        return this.config;
    }

    public XmlManager getManager() throws XmlException {
        return this.manager;
    }

    public void close() throws XmlException {
        this.delete();
    }

    public void putDocument(XmlDocument document) throws XmlException {
        this.putDocument(null, document, null, null);
    }

    public void putDocument(XmlDocument document, XmlUpdateContext context) throws XmlException {
        this.putDocument(null, document, null, null);
    }

    public void putDocument(XmlDocument document, XmlDocumentConfig config) throws XmlException {
        this.putDocument(null, document, null, config);
    }

    public void putDocument(XmlDocument document, XmlUpdateContext context, XmlDocumentConfig config) throws XmlException {
        this.putDocument(null, document, null, config);
    }

    public void putDocument(XmlTransaction txn, XmlDocument document) throws XmlException {
        this.putDocument(txn, document, null, null);
    }

    public void putDocument(XmlTransaction txn, XmlDocument document, XmlUpdateContext context) throws XmlException {
        this.putDocument(txn, document, null, null);
    }

    public void putDocument(XmlTransaction txn, XmlDocument document, XmlDocumentConfig config) throws XmlException {
        this.putDocument(txn, document, null, config);
    }

    public void putDocument(XmlTransaction txn, XmlDocument document, XmlUpdateContext context, XmlDocumentConfig config) throws XmlException {
        int flags = config == null ? 0 : config.makeFlags();
        XmlDocument doc = txn != null ? this.putDocumentInternal(txn, document, flags) : this.putDocumentInternal(document, flags);
        document.copy(doc);
        document.setManager(this.manager);
        if (txn != null) {
            document.setTransaction(txn);
        }
    }

    public String putDocument(String name, XmlInputStream input) throws XmlException {
        return this.putDocument(null, name, input, null, null);
    }

    public String putDocument(String name, XmlInputStream input, XmlUpdateContext context) throws XmlException {
        return this.putDocument(null, name, input, null, null);
    }

    public String putDocument(String name, XmlInputStream input, XmlDocumentConfig config) throws XmlException {
        return this.putDocument(null, name, input, null, config);
    }

    public String putDocument(String name, XmlInputStream input, XmlUpdateContext context, XmlDocumentConfig config) throws XmlException {
        return this.putDocument(null, name, input, null, config);
    }

    public String putDocument(XmlTransaction txn, String name, XmlInputStream input) throws XmlException {
        return this.putDocument(txn, name, input, null, null);
    }

    public String putDocument(XmlTransaction txn, String name, XmlInputStream input, XmlUpdateContext context) throws XmlException {
        return this.putDocument(txn, name, input, null, null);
    }

    public String putDocument(XmlTransaction txn, String name, XmlInputStream input, XmlDocumentConfig config) throws XmlException {
        return this.putDocument(txn, name, input, null, config);
    }

    public String putDocument(XmlTransaction txn, String name, XmlInputStream input, XmlUpdateContext context, XmlDocumentConfig config) throws XmlException {
        int flags = config == null ? 0 : config.makeFlags();
        String docName = "";
        try {
            docName = txn != null ? this.putDocument(txn, name, input, flags) : this.putDocument(name, input, flags);
        }
        catch (XmlException e) {
            input.release();
            throw e;
        }
        input.release();
        return docName;
    }

    public String putDocument(String name, String content) throws XmlException {
        return this.putDocument(null, name, content, null, null);
    }

    public String putDocument(String name, String content, XmlDocumentConfig config) throws XmlException {
        return this.putDocument(null, name, content, null, config);
    }

    public String putDocument(String name, String content, XmlUpdateContext context, XmlDocumentConfig config) throws XmlException {
        return this.putDocument(null, name, content, null, config);
    }

    public String putDocument(XmlTransaction txn, String name, String content) throws XmlException {
        return this.putDocument(txn, name, content, null, null);
    }

    public String putDocument(XmlTransaction txn, String name, String content, XmlDocumentConfig config) throws XmlException {
        return this.putDocument(txn, name, content, null, config);
    }

    public String putDocument(XmlTransaction txn, String name, String content, XmlUpdateContext context, XmlDocumentConfig config) throws XmlException {
        int flags;
        int n = flags = config == null ? 0 : config.makeFlags();
        if (context == null) {
            context = new XmlUpdateContext(this.manager);
        }
        if (txn != null) {
            return this.putDocument(txn, name, content, context, flags);
        }
        return this.putDocument(name, content, context, flags);
    }

    public String putDocument(String name, XmlEventReader reader) throws XmlException {
        return this.putDocument(null, name, reader, null, null);
    }

    public String putDocument(String name, XmlEventReader reader, XmlDocumentConfig config) throws XmlException {
        return this.putDocument(null, name, reader, null, config);
    }

    public String putDocument(String name, XmlEventReader reader, XmlUpdateContext context, XmlDocumentConfig config) throws XmlException {
        return this.putDocument(null, name, reader, context, config);
    }

    public String putDocument(String name, XmlEventReader reader, XmlUpdateContext context) throws XmlException {
        return this.putDocument(null, name, reader, context, null);
    }

    public String putDocument(XmlTransaction txn, String name, XmlEventReader reader, XmlDocumentConfig config) throws XmlException {
        return this.putDocument(txn, name, reader, null, config);
    }

    public String putDocument(XmlTransaction txn, String name, XmlEventReader reader) throws XmlException {
        return this.putDocument(txn, name, reader, null, null);
    }

    public String putDocument(XmlTransaction txn, String name, XmlEventReader reader, XmlUpdateContext context) throws XmlException {
        return this.putDocument(txn, name, reader, context, null);
    }

    public String putDocument(XmlTransaction txn, String name, XmlEventReader reader, XmlUpdateContext context, XmlDocumentConfig config) throws XmlException {
        int flags = config == null ? 0 : config.makeFlags();
        String ret = "";
        if (context == null) {
            context = new XmlUpdateContext(this.manager);
        }
        try {
            ret = txn != null ? this.putDocument(txn, name, reader, context, flags) : this.putDocument(name, reader, context, flags);
        }
        catch (XmlException e) {
            reader.release();
            throw e;
        }
        reader.release();
        return ret;
    }

    public XmlEventWriter putDocumentAsEventWriter(XmlDocument document) throws XmlException {
        return this.putDocumentAsEventWriter(null, document, null, null);
    }

    public XmlEventWriter putDocumentAsEventWriter(XmlDocument document, XmlDocumentConfig config) throws XmlException {
        return this.putDocumentAsEventWriter(null, document, null, config);
    }

    public XmlEventWriter putDocumentAsEventWriter(XmlDocument document, XmlUpdateContext context) throws XmlException {
        return this.putDocumentAsEventWriter(null, document, null, null);
    }

    public XmlEventWriter putDocumentAsEventWriter(XmlDocument document, XmlUpdateContext context, XmlDocumentConfig config) throws XmlException {
        return this.putDocumentAsEventWriter(null, document, null, config);
    }

    public XmlEventWriter putDocumentAsEventWriter(XmlTransaction txn, XmlDocument document) throws XmlException {
        return this.putDocumentAsEventWriter(txn, document, null, null);
    }

    public XmlEventWriter putDocumentAsEventWriter(XmlTransaction txn, XmlDocument document, XmlUpdateContext context) throws XmlException {
        return this.putDocumentAsEventWriter(txn, document, null, null);
    }

    public XmlEventWriter putDocumentAsEventWriter(XmlTransaction txn, XmlDocument document, XmlDocumentConfig config) throws XmlException {
        return this.putDocumentAsEventWriter(txn, document, null, config);
    }

    public XmlEventWriter putDocumentAsEventWriter(XmlTransaction txn, XmlDocument document, XmlUpdateContext context, XmlDocumentConfig config) throws XmlException {
        long cPtr;
        int flags = config == null ? 0 : config.makeFlags();
        document.clearContent();
        XmlDocument doc = txn != null ? (XmlDocument)this.putDocumentAsEventWriter(txn, document, flags) : (XmlDocument)this.putDocumentAsEventWriter(document, flags);
        document.copy(doc);
        document.setManager(this.manager);
        if (txn != null) {
            document.setTransaction(txn);
        }
        return (cPtr = doc.getEventWriterPtr()) == 0L ? null : new XmlEventWriter(cPtr, true);
    }

    public void deleteDocument(String name) throws XmlException {
        this.deleteDocument(name, null);
    }

    public void deleteDocument(XmlDocument document) throws XmlException {
        this.deleteDocument(document, null);
    }

    public void deleteDocument(XmlDocument document, XmlUpdateContext context) throws XmlException {
        XmlDocument doc = this.deleteDocumentInternal(document);
        document.copy(doc);
        document.clearID();
        document.setManager(this.manager);
    }

    public void deleteDocument(XmlTransaction txn, String name) throws XmlException {
        this.deleteDocument(txn, name, null);
    }

    public void deleteDocument(XmlTransaction txn, XmlDocument document) throws XmlException {
        this.deleteDocument(txn, document, null);
    }

    public void deleteDocument(XmlTransaction txn, XmlDocument document, XmlUpdateContext context) throws XmlException {
        XmlDocument doc = this.deleteDocumentInternal(txn, document);
        document.copy(doc);
        document.clearID();
        document.setManager(this.manager);
        document.setTransaction(txn);
    }

    public void updateDocument(XmlDocument document) throws XmlException {
        this.updateDocument(document, null);
    }

    public void updateDocument(XmlDocument document, XmlUpdateContext context) throws XmlException {
        XmlDocument doc = this.updateDocumentInternal(document);
        document.copy(doc);
        document.setManager(this.manager);
    }

    public void updateDocument(XmlTransaction txn, XmlDocument document) throws XmlException {
        this.updateDocument(txn, document, null);
    }

    public void updateDocument(XmlTransaction txn, XmlDocument document, XmlUpdateContext context) throws XmlException {
        XmlDocument doc = this.updateDocumentInternal(txn, document);
        document.copy(doc);
        document.setManager(this.manager);
        document.setTransaction(txn);
    }

    public void setIndexSpecification(XmlIndexSpecification index) throws XmlException {
        this.setIndexSpecification(index, new XmlUpdateContext(this.manager));
    }

    public void addIndex(String uri, String name, String index) throws XmlException {
        this.addIndex(uri, name, index, new XmlUpdateContext(this.manager));
    }

    public void addIndex(String uri, String name, int indexType, int syntaxType) throws XmlException {
        this.addIndex(uri, name, indexType, syntaxType, new XmlUpdateContext(this.manager));
    }

    public void deleteIndex(String uri, String name, String index) throws XmlException {
        this.deleteIndex(uri, name, index, new XmlUpdateContext(this.manager));
    }

    public void replaceIndex(String uri, String name, String index) throws XmlException {
        this.replaceIndex(uri, name, index, new XmlUpdateContext(this.manager));
    }

    public void addDefaultIndex(String index) throws XmlException {
        this.addDefaultIndex(index, new XmlUpdateContext(this.manager));
    }

    public void deleteDefaultIndex(String index) throws XmlException {
        this.deleteDefaultIndex(index, new XmlUpdateContext(this.manager));
    }

    public void replaceDefaultIndex(String index) throws XmlException {
        this.replaceDefaultIndex(index, new XmlUpdateContext(this.manager));
    }

    public void setIndexSpecification(XmlTransaction txn, XmlIndexSpecification index) throws XmlException {
        this.setIndexSpecification(txn, index, new XmlUpdateContext(this.manager));
    }

    public void addIndex(XmlTransaction txn, String uri, String name, String index) throws XmlException {
        this.addIndex(txn, uri, name, index, new XmlUpdateContext(this.manager));
    }

    public void addIndex(XmlTransaction txn, String uri, String name, int indexType, int syntaxType) throws XmlException {
        this.addIndex(txn, uri, name, indexType, syntaxType, new XmlUpdateContext(this.manager));
    }

    public void deleteIndex(XmlTransaction txn, String uri, String name, String index) throws XmlException {
        this.deleteIndex(txn, uri, name, index, new XmlUpdateContext(this.manager));
    }

    public void replaceIndex(XmlTransaction txn, String uri, String name, String index) throws XmlException {
        this.replaceIndex(txn, uri, name, index, new XmlUpdateContext(this.manager));
    }

    public void addDefaultIndex(XmlTransaction txn, String index) throws XmlException {
        this.addDefaultIndex(txn, index, new XmlUpdateContext(this.manager));
    }

    public void deleteDefaultIndex(XmlTransaction txn, String index) throws XmlException {
        this.deleteDefaultIndex(txn, index, new XmlUpdateContext(this.manager));
    }

    public void replaceDefaultIndex(XmlTransaction txn, String index) throws XmlException {
        this.replaceDefaultIndex(txn, index, new XmlUpdateContext(this.manager));
    }

    public XmlDocument getDocument(String name) throws XmlException {
        return this.getDocument(name, null);
    }

    public XmlDocument getDocument(String name, XmlDocumentConfig config) throws XmlException {
        int flags = config == null ? 0 : config.makeFlags();
        XmlDocument doc = this.getDocumentInternal(name, flags);
        doc.setManager(this.manager);
        return doc;
    }

    public XmlDocument getDocument(XmlTransaction txn, String name) throws XmlException {
        return this.getDocument(txn, name, null);
    }

    public XmlDocument getDocument(XmlTransaction txn, String name, XmlDocumentConfig config) throws XmlException {
        int flags = config == null ? 0 : config.makeFlags();
        XmlDocument doc = this.getDocumentInternal(txn, name, flags);
        doc.setManager(this.manager);
        doc.setTransaction(txn);
        return doc;
    }

    public XmlResults getAllDocuments(XmlDocumentConfig config) throws XmlException {
        int flags = config == null ? 0 : config.makeFlags();
        return this.getAllDocuments(flags);
    }

    public XmlResults getAllDocuments(XmlTransaction txn, XmlDocumentConfig config) throws XmlException {
        int flags = config == null ? 0 : config.makeFlags();
        return this.getAllDocuments(txn, flags);
    }

    public XmlResults getNode(XmlTransaction txn, String name, XmlDocumentConfig config) throws XmlException {
        int flags = config == null ? 0 : config.makeFlags();
        return this.getNode(txn, name, flags);
    }

    public XmlIndexSpecification getIndexSpecification(XmlTransaction txn, XmlDocumentConfig config) throws XmlException {
        int flags = config == null ? 0 : config.makeFlags();
        return this.getIndexSpecification(txn, flags);
    }

    public XmlResults lookupIndex(XmlQueryContext context, String uri, String name, String index, XmlValue value, XmlDocumentConfig config) throws XmlException {
        int flags = config == null ? 0 : config.makeFlags();
        return this.lookupIndex(context, uri, name, index, value, flags);
    }

    public XmlResults lookupIndex(XmlTransaction txn, XmlQueryContext context, String uri, String name, String index, XmlValue value, XmlDocumentConfig config) throws XmlException {
        int flags = config == null ? 0 : config.makeFlags();
        return this.lookupIndex(txn, context, uri, name, index, value, flags);
    }

    public XmlResults lookupIndex(XmlQueryContext context, String uri, String name, String parentUri, String parentName, String index, XmlValue value, XmlDocumentConfig config) throws XmlException {
        int flags = config == null ? 0 : config.makeFlags();
        return this.lookupIndex(context, uri, name, parentUri, parentName, index, value, flags);
    }

    public XmlResults lookupIndex(XmlTransaction txn, XmlQueryContext context, String uri, String name, String parentUri, String parentName, String index, XmlValue value, XmlDocumentConfig config) throws XmlException {
        int flags = config == null ? 0 : config.makeFlags();
        return this.lookupIndex(txn, context, uri, name, parentUri, parentName, index, value, flags);
    }

    void setContainerConfig(XmlContainerConfig config) {
        this.config = config;
    }

    void setManager(XmlManager manager) {
        this.manager = manager;
    }

    public XmlContainer(XmlContainer o) throws XmlException {
        this(dbxml_javaJNI.new_XmlContainer(XmlContainer.getCPtr(o), o), true);
    }

    public void sync() throws XmlException {
        dbxml_javaJNI.XmlContainer_sync(this.swigCPtr, this);
    }

    public boolean addAlias(String alias) throws XmlException {
        return dbxml_javaJNI.XmlContainer_addAlias(this.swigCPtr, this, alias);
    }

    public boolean removeAlias(String alias) throws XmlException {
        return dbxml_javaJNI.XmlContainer_removeAlias(this.swigCPtr, this, alias);
    }

    public String getName() throws XmlException {
        return dbxml_javaJNI.XmlContainer_getName(this.swigCPtr, this);
    }

    public int getContainerType() throws XmlException {
        return dbxml_javaJNI.XmlContainer_getContainerType(this.swigCPtr, this);
    }

    public boolean getIndexNodes() throws XmlException {
        return dbxml_javaJNI.XmlContainer_getIndexNodes(this.swigCPtr, this);
    }

    public int getPageSize() throws XmlException {
        return dbxml_javaJNI.XmlContainer_getPageSize(this.swigCPtr, this);
    }

    public void setIndexSpecification(XmlIndexSpecification index, XmlUpdateContext uc) throws XmlException {
        dbxml_javaJNI.XmlContainer_setIndexSpecification__SWIG_0(this.swigCPtr, this, XmlIndexSpecification.getCPtr(index), index, XmlUpdateContext.getCPtr(uc));
    }

    public void addIndex(String uri, String name, String index, XmlUpdateContext uc) throws XmlException {
        dbxml_javaJNI.XmlContainer_addIndex__SWIG_0(this.swigCPtr, this, uri, name, index, XmlUpdateContext.getCPtr(uc));
    }

    public void addIndex(String uri, String name, int indexType, int syntaxType, XmlUpdateContext uc) throws XmlException {
        dbxml_javaJNI.XmlContainer_addIndex__SWIG_1(this.swigCPtr, this, uri, name, indexType, syntaxType, XmlUpdateContext.getCPtr(uc));
    }

    public void deleteIndex(String uri, String name, String index, XmlUpdateContext uc) throws XmlException {
        dbxml_javaJNI.XmlContainer_deleteIndex__SWIG_0(this.swigCPtr, this, uri, name, index, XmlUpdateContext.getCPtr(uc));
    }

    public void replaceIndex(String uri, String name, String index, XmlUpdateContext uc) throws XmlException {
        dbxml_javaJNI.XmlContainer_replaceIndex__SWIG_0(this.swigCPtr, this, uri, name, index, XmlUpdateContext.getCPtr(uc));
    }

    public void addDefaultIndex(String index, XmlUpdateContext uc) throws XmlException {
        dbxml_javaJNI.XmlContainer_addDefaultIndex__SWIG_0(this.swigCPtr, this, index, XmlUpdateContext.getCPtr(uc));
    }

    public void deleteDefaultIndex(String index, XmlUpdateContext uc) throws XmlException {
        dbxml_javaJNI.XmlContainer_deleteDefaultIndex__SWIG_0(this.swigCPtr, this, index, XmlUpdateContext.getCPtr(uc));
    }

    public void replaceDefaultIndex(String index, XmlUpdateContext uc) throws XmlException {
        dbxml_javaJNI.XmlContainer_replaceDefaultIndex__SWIG_0(this.swigCPtr, this, index, XmlUpdateContext.getCPtr(uc));
    }

    public void setIndexSpecification(XmlTransaction txn, XmlIndexSpecification index, XmlUpdateContext uc) throws XmlException {
        dbxml_javaJNI.XmlContainer_setIndexSpecification__SWIG_1(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, XmlIndexSpecification.getCPtr(index), index, XmlUpdateContext.getCPtr(uc));
    }

    public void addIndex(XmlTransaction txn, String uri, String name, String index, XmlUpdateContext uc) throws XmlException {
        dbxml_javaJNI.XmlContainer_addIndex__SWIG_2(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, uri, name, index, XmlUpdateContext.getCPtr(uc));
    }

    public void addIndex(XmlTransaction txn, String uri, String name, int indexType, int syntaxType, XmlUpdateContext uc) throws XmlException {
        dbxml_javaJNI.XmlContainer_addIndex__SWIG_3(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, uri, name, indexType, syntaxType, XmlUpdateContext.getCPtr(uc));
    }

    public void deleteIndex(XmlTransaction txn, String uri, String name, String index, XmlUpdateContext uc) throws XmlException {
        dbxml_javaJNI.XmlContainer_deleteIndex__SWIG_1(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, uri, name, index, XmlUpdateContext.getCPtr(uc));
    }

    public void replaceIndex(XmlTransaction txn, String uri, String name, String index, XmlUpdateContext uc) throws XmlException {
        dbxml_javaJNI.XmlContainer_replaceIndex__SWIG_1(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, uri, name, index, XmlUpdateContext.getCPtr(uc));
    }

    public void addDefaultIndex(XmlTransaction txn, String index, XmlUpdateContext uc) throws XmlException {
        dbxml_javaJNI.XmlContainer_addDefaultIndex__SWIG_1(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, index, XmlUpdateContext.getCPtr(uc));
    }

    public void deleteDefaultIndex(XmlTransaction txn, String index, XmlUpdateContext uc) throws XmlException {
        dbxml_javaJNI.XmlContainer_deleteDefaultIndex__SWIG_1(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, index, XmlUpdateContext.getCPtr(uc));
    }

    public void replaceDefaultIndex(XmlTransaction txn, String index, XmlUpdateContext uc) throws XmlException {
        dbxml_javaJNI.XmlContainer_replaceDefaultIndex__SWIG_1(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, index, XmlUpdateContext.getCPtr(uc));
    }

    protected String putDocument(String name, String contents, XmlUpdateContext context, int flags) throws XmlException {
        return dbxml_javaJNI.XmlContainer_putDocument__SWIG_0(this.swigCPtr, this, name, contents, XmlUpdateContext.getCPtr(context), flags);
    }

    public String putDocument(String name, String contents, XmlUpdateContext context) throws XmlException {
        return dbxml_javaJNI.XmlContainer_putDocument__SWIG_1(this.swigCPtr, this, name, contents, XmlUpdateContext.getCPtr(context));
    }

    protected String putDocument(String name, XmlEventReader reader, XmlUpdateContext context, int flags) throws XmlException {
        return dbxml_javaJNI.XmlContainer_putDocument__SWIG_2(this.swigCPtr, this, name, XmlEventReader.getCPtr(reader), reader, XmlUpdateContext.getCPtr(context), flags);
    }

    public void deleteDocument(String name, XmlUpdateContext context) throws XmlException {
        dbxml_javaJNI.XmlContainer_deleteDocument__SWIG_0(this.swigCPtr, this, name, XmlUpdateContext.getCPtr(context));
    }

    protected String putDocument(XmlTransaction txn, String name, String contents, XmlUpdateContext context, int flags) throws XmlException {
        return dbxml_javaJNI.XmlContainer_putDocument__SWIG_3(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, name, contents, XmlUpdateContext.getCPtr(context), flags);
    }

    public String putDocument(XmlTransaction txn, String name, String contents, XmlUpdateContext context) throws XmlException {
        return dbxml_javaJNI.XmlContainer_putDocument__SWIG_4(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, name, contents, XmlUpdateContext.getCPtr(context));
    }

    protected String putDocument(XmlTransaction txn, String name, XmlEventReader reader, XmlUpdateContext context, int flags) throws XmlException {
        return dbxml_javaJNI.XmlContainer_putDocument__SWIG_5(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, name, XmlEventReader.getCPtr(reader), reader, XmlUpdateContext.getCPtr(context), flags);
    }

    public void deleteDocument(XmlTransaction txn, String name, XmlUpdateContext context) throws XmlException {
        dbxml_javaJNI.XmlContainer_deleteDocument__SWIG_1(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, name, XmlUpdateContext.getCPtr(context));
    }

    public int getNumDocuments() throws XmlException {
        return dbxml_javaJNI.XmlContainer_getNumDocuments__SWIG_0(this.swigCPtr, this);
    }

    public int getNumDocuments(XmlTransaction txn) throws XmlException {
        return dbxml_javaJNI.XmlContainer_getNumDocuments__SWIG_1(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn);
    }

    public XmlIndexSpecification getIndexSpecification() throws XmlException {
        long cPtr = dbxml_javaJNI.XmlContainer_getIndexSpecification__SWIG_0(this.swigCPtr, this);
        return cPtr == 0L ? null : new XmlIndexSpecification(cPtr, true);
    }

    public XmlIndexSpecification getIndexSpecification(XmlTransaction txn) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlContainer_getIndexSpecification__SWIG_1(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn);
        return cPtr == 0L ? null : new XmlIndexSpecification(cPtr, true);
    }

    protected XmlIndexSpecification getIndexSpecification(XmlTransaction txn, int flags) {
        long cPtr = dbxml_javaJNI.XmlContainer_getIndexSpecification__SWIG_2(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, flags);
        return cPtr == 0L ? null : new XmlIndexSpecification(cPtr, true);
    }

    protected XmlResults getAllDocuments(int flags) {
        long cPtr = dbxml_javaJNI.XmlContainer_getAllDocuments__SWIG_0(this.swigCPtr, this, flags);
        return cPtr == 0L ? null : new XmlResults(cPtr, true);
    }

    protected XmlResults getAllDocuments(XmlTransaction txn, int flags) {
        long cPtr = dbxml_javaJNI.XmlContainer_getAllDocuments__SWIG_1(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, flags);
        return cPtr == 0L ? null : new XmlResults(cPtr, true);
    }

    protected XmlResults lookupIndex(XmlQueryContext context, String uri, String name, String index, XmlValue value, int flags) {
        long cPtr = dbxml_javaJNI.XmlContainer_lookupIndex__SWIG_0(this.swigCPtr, this, context, uri, name, index, value, flags);
        return cPtr == 0L ? null : new XmlResults(cPtr, true);
    }

    public XmlResults lookupIndex(XmlQueryContext context, String uri, String name, String index, XmlValue value) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlContainer_lookupIndex__SWIG_1(this.swigCPtr, this, context, uri, name, index, value);
        return cPtr == 0L ? null : new XmlResults(cPtr, true);
    }

    public XmlResults lookupIndex(XmlQueryContext context, String uri, String name, String index) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlContainer_lookupIndex__SWIG_2(this.swigCPtr, this, context, uri, name, index);
        return cPtr == 0L ? null : new XmlResults(cPtr, true);
    }

    protected XmlResults lookupIndex(XmlQueryContext context, String uri, String name, String parent_uri, String parent_name, String index, XmlValue value, int flags) {
        long cPtr = dbxml_javaJNI.XmlContainer_lookupIndex__SWIG_3(this.swigCPtr, this, context, uri, name, parent_uri, parent_name, index, value, flags);
        return cPtr == 0L ? null : new XmlResults(cPtr, true);
    }

    public XmlResults lookupIndex(XmlQueryContext context, String uri, String name, String parent_uri, String parent_name, String index, XmlValue value) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlContainer_lookupIndex__SWIG_4(this.swigCPtr, this, context, uri, name, parent_uri, parent_name, index, value);
        return cPtr == 0L ? null : new XmlResults(cPtr, true);
    }

    public XmlResults lookupIndex(XmlQueryContext context, String uri, String name, String parent_uri, String parent_name, String index) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlContainer_lookupIndex__SWIG_5(this.swigCPtr, this, context, uri, name, parent_uri, parent_name, index);
        return cPtr == 0L ? null : new XmlResults(cPtr, true);
    }

    protected XmlResults lookupIndex(XmlTransaction txn, XmlQueryContext context, String uri, String name, String index, XmlValue value, int flags) {
        long cPtr = dbxml_javaJNI.XmlContainer_lookupIndex__SWIG_6(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, context, uri, name, index, value, flags);
        return cPtr == 0L ? null : new XmlResults(cPtr, true);
    }

    public XmlResults lookupIndex(XmlTransaction txn, XmlQueryContext context, String uri, String name, String index, XmlValue value) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlContainer_lookupIndex__SWIG_7(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, context, uri, name, index, value);
        return cPtr == 0L ? null : new XmlResults(cPtr, true);
    }

    public XmlResults lookupIndex(XmlTransaction txn, XmlQueryContext context, String uri, String name, String index) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlContainer_lookupIndex__SWIG_8(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, context, uri, name, index);
        return cPtr == 0L ? null : new XmlResults(cPtr, true);
    }

    protected XmlResults lookupIndex(XmlTransaction txn, XmlQueryContext context, String uri, String name, String parent_uri, String parent_name, String index, XmlValue value, int flags) {
        long cPtr = dbxml_javaJNI.XmlContainer_lookupIndex__SWIG_9(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, context, uri, name, parent_uri, parent_name, index, value, flags);
        return cPtr == 0L ? null : new XmlResults(cPtr, true);
    }

    public XmlResults lookupIndex(XmlTransaction txn, XmlQueryContext context, String uri, String name, String parent_uri, String parent_name, String index, XmlValue value) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlContainer_lookupIndex__SWIG_10(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, context, uri, name, parent_uri, parent_name, index, value);
        return cPtr == 0L ? null : new XmlResults(cPtr, true);
    }

    public XmlResults lookupIndex(XmlTransaction txn, XmlQueryContext context, String uri, String name, String parent_uri, String parent_name, String index) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlContainer_lookupIndex__SWIG_11(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, context, uri, name, parent_uri, parent_name, index);
        return cPtr == 0L ? null : new XmlResults(cPtr, true);
    }

    public XmlStatistics lookupStatistics(String uri, String name, String index, XmlValue value) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlContainer_lookupStatistics__SWIG_0(this.swigCPtr, this, uri, name, index, value);
        return cPtr == 0L ? null : new XmlStatistics(cPtr, true);
    }

    public XmlStatistics lookupStatistics(String uri, String name, String index) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlContainer_lookupStatistics__SWIG_1(this.swigCPtr, this, uri, name, index);
        return cPtr == 0L ? null : new XmlStatistics(cPtr, true);
    }

    public XmlStatistics lookupStatistics(String uri, String name, String parent_uri, String parent_name, String index, XmlValue value) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlContainer_lookupStatistics__SWIG_2(this.swigCPtr, this, uri, name, parent_uri, parent_name, index, value);
        return cPtr == 0L ? null : new XmlStatistics(cPtr, true);
    }

    public XmlStatistics lookupStatistics(String uri, String name, String parent_uri, String parent_name, String index) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlContainer_lookupStatistics__SWIG_3(this.swigCPtr, this, uri, name, parent_uri, parent_name, index);
        return cPtr == 0L ? null : new XmlStatistics(cPtr, true);
    }

    public XmlStatistics lookupStatistics(XmlTransaction txn, String uri, String name, String index, XmlValue value) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlContainer_lookupStatistics__SWIG_4(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, uri, name, index, value);
        return cPtr == 0L ? null : new XmlStatistics(cPtr, true);
    }

    public XmlStatistics lookupStatistics(XmlTransaction txn, String uri, String name, String index) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlContainer_lookupStatistics__SWIG_5(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, uri, name, index);
        return cPtr == 0L ? null : new XmlStatistics(cPtr, true);
    }

    public XmlStatistics lookupStatistics(XmlTransaction txn, String uri, String name, String parent_uri, String parent_name, String index, XmlValue value) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlContainer_lookupStatistics__SWIG_6(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, uri, name, parent_uri, parent_name, index, value);
        return cPtr == 0L ? null : new XmlStatistics(cPtr, true);
    }

    public XmlStatistics lookupStatistics(XmlTransaction txn, String uri, String name, String parent_uri, String parent_name, String index) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlContainer_lookupStatistics__SWIG_7(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, uri, name, parent_uri, parent_name, index);
        return cPtr == 0L ? null : new XmlStatistics(cPtr, true);
    }

    protected XmlDocument getDocumentInternal(String name, int flags) {
        return dbxml_javaJNI.XmlContainer_getDocumentInternal__SWIG_0(this.swigCPtr, this, name, flags);
    }

    protected XmlDocument getDocumentInternal(XmlTransaction txn, String name, int flags) {
        return dbxml_javaJNI.XmlContainer_getDocumentInternal__SWIG_1(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, name, flags);
    }

    protected XmlDocument putDocumentInternal(XmlDocument document, int flags) {
        return dbxml_javaJNI.XmlContainer_putDocumentInternal__SWIG_0(this.swigCPtr, this, document, flags);
    }

    public XmlDocument putDocumentInternal(XmlDocument document) throws XmlException {
        return dbxml_javaJNI.XmlContainer_putDocumentInternal__SWIG_1(this.swigCPtr, this, document);
    }

    protected XmlDocument putDocumentInternal(XmlTransaction txn, XmlDocument document, int flags) {
        return dbxml_javaJNI.XmlContainer_putDocumentInternal__SWIG_2(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, document, flags);
    }

    public XmlDocument putDocumentInternal(XmlTransaction txn, XmlDocument document) throws XmlException {
        return dbxml_javaJNI.XmlContainer_putDocumentInternal__SWIG_3(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, document);
    }

    protected Object putDocumentAsEventWriter(XmlDocument document, int flags) {
        return dbxml_javaJNI.XmlContainer_putDocumentAsEventWriter__SWIG_0(this.swigCPtr, this, document, flags);
    }

    protected Object putDocumentAsEventWriter(XmlTransaction txn, XmlDocument document, int flags) {
        return dbxml_javaJNI.XmlContainer_putDocumentAsEventWriter__SWIG_1(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, document, flags);
    }

    protected XmlDocument deleteDocumentInternal(XmlDocument document) {
        return dbxml_javaJNI.XmlContainer_deleteDocumentInternal__SWIG_0(this.swigCPtr, this, document);
    }

    protected XmlDocument deleteDocumentInternal(XmlTransaction txn, XmlDocument document) {
        return dbxml_javaJNI.XmlContainer_deleteDocumentInternal__SWIG_1(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, document);
    }

    protected XmlDocument updateDocumentInternal(XmlDocument document) {
        return dbxml_javaJNI.XmlContainer_updateDocumentInternal__SWIG_0(this.swigCPtr, this, document);
    }

    protected XmlDocument updateDocumentInternal(XmlTransaction txn, XmlDocument document) {
        return dbxml_javaJNI.XmlContainer_updateDocumentInternal__SWIG_1(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, document);
    }

    public XmlResults getNode(String name) throws XmlException {
        return new XmlResults(dbxml_javaJNI.XmlContainer_getNode__SWIG_0(this.swigCPtr, this, name), true);
    }

    protected XmlResults getNode(XmlTransaction txn, String name, int flags) {
        return new XmlResults(dbxml_javaJNI.XmlContainer_getNode__SWIG_1(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, name, flags), true);
    }

    protected String putDocument(String name, XmlInputStream input, int flags) throws XmlException {
        return dbxml_javaJNI.XmlContainer_putDocument__SWIG_6(this.swigCPtr, this, name, XmlInputStream.getCPtr(input), input, flags);
    }

    protected String putDocument(XmlTransaction txn, String name, XmlInputStream input, int flags) throws XmlException {
        return dbxml_javaJNI.XmlContainer_putDocument__SWIG_7(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, name, XmlInputStream.getCPtr(input), input, flags);
    }
}

