/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.dbxml;

import com.sleepycat.dbxml.HelperFunctions;
import com.sleepycat.dbxml.XmlDocument;
import com.sleepycat.dbxml.XmlEventReader;
import com.sleepycat.dbxml.XmlException;
import com.sleepycat.dbxml.XmlManager;
import com.sleepycat.dbxml.XmlResults;
import com.sleepycat.dbxml.XmlTransaction;
import java.util.Arrays;

public class XmlValue {
    protected Value value;
    protected int valueType;
    public static final int ELEMENT_NODE = 1;
    public static final int ATTRIBUTE_NODE = 2;
    public static final int TEXT_NODE = 3;
    public static final int CDATA_SECTION_NODE = 4;
    public static final int ENTITY_REFERENCE_NODE = 5;
    public static final int ENTITY_NODE = 6;
    public static final int PROCESSING_INSTRUCTION_NODE = 7;
    public static final int COMMENT_NODE = 8;
    public static final int DOCUMENT_NODE = 9;
    public static final int DOCUMENT_TYPE_NODE = 10;
    public static final int DOCUMENT_FRAGMENT_NODE = 11;
    public static final int NOTATION_NODE = 12;
    public static final int NONE = 0;
    public static final int NODE = 3;
    public static final int ANY_SIMPLE_TYPE = 10;
    public static final int ANY_URI = 11;
    public static final int BASE_64_BINARY = 12;
    public static final int BOOLEAN = 13;
    public static final int DATE = 14;
    public static final int DATE_TIME = 15;
    public static final int DAY_TIME_DURATION = 16;
    public static final int DECIMAL = 17;
    public static final int DOUBLE = 18;
    public static final int DURATION = 19;
    public static final int FLOAT = 20;
    public static final int G_DAY = 21;
    public static final int G_MONTH = 22;
    public static final int G_MONTH_DAY = 23;
    public static final int G_YEAR = 24;
    public static final int G_YEAR_MONTH = 25;
    public static final int HEX_BINARY = 26;
    public static final int NOTATION = 27;
    public static final int QNAME = 28;
    public static final int STRING = 29;
    public static final int TIME = 30;
    public static final int YEAR_MONTH_DURATION = 31;
    public static final int UNTYPED_ATOMIC = 32;
    public static final int BINARY = 40;

    public XmlValue() {
        this.valueType = 0;
        this.value = new Value();
    }

    public XmlValue(XmlValue other) throws XmlException {
        this.valueType = other.getType();
        Class<?> valueClass = other.value.getClass();
        String simpleName = valueClass.getSimpleName();
        if (simpleName.matches("Value")) {
            this.value = new Value();
        } else if (simpleName.matches("StringValue")) {
            this.value = new StringValue((StringValue)other.value);
        } else if (simpleName.matches("NodeValue")) {
            this.value = new NodeValue((NodeValue)other.value);
        } else if (simpleName.matches("BinaryValue")) {
            this.value = new BinaryValue((BinaryValue)other.value);
        } else {
            throw new XmlException(14, "Invalid XmlValue object.");
        }
    }

    public XmlValue(String v) throws XmlException {
        this.valueType = 29;
        this.value = new StringValue(v);
    }

    public XmlValue(double v) throws XmlException {
        String doubleString;
        this.valueType = 18;
        try {
            doubleString = Double.toString(v);
        }
        catch (Exception e) {
            doubleString = Double.toString(Double.NaN);
        }
        this.value = new StringValue(doubleString);
    }

    public XmlValue(boolean v) throws XmlException {
        String boolString;
        this.valueType = 13;
        try {
            boolString = Boolean.toString(v);
        }
        catch (Exception e) {
            boolString = Boolean.toString(false);
        }
        this.value = new StringValue(boolString);
    }

    public XmlValue(XmlDocument document) throws XmlException {
        XmlValue xmlvalue = HelperFunctions.createDocumentValue(document);
        this.valueType = xmlvalue.getType();
        this.value = new NodeValue((NodeValue)xmlvalue.value);
        ((NodeValue)this.value).setDocument(document);
        ((NodeValue)this.value).setResult(document.results);
        ((NodeValue)this.value).setManager(document.manager);
        ((NodeValue)this.value).setTransaction(document.txn);
    }

    public XmlValue(int type, String v) throws XmlException {
        if (type <= 10) {
            this.valueType = 0;
            this.value = new Value();
        } else {
            HelperFunctions.validateString(type, v);
            this.valueType = type;
            this.value = new StringValue(v);
        }
    }

    public XmlValue(int type, byte[] dbt) throws XmlException {
        if (type <= 10) {
            this.valueType = 0;
            this.value = new Value();
        } else {
            this.valueType = type;
            if (this.valueType != 40) {
                String strValue = new String(dbt);
                HelperFunctions.validateString(this.valueType, strValue);
                this.value = new StringValue(strValue);
            } else {
                this.value = new BinaryValue(dbt);
            }
        }
    }

    public void delete() {
    }

    public int getType() throws XmlException {
        return this.valueType;
    }

    public String getTypeURI() throws XmlException {
        return this.value.getTypeURI();
    }

    public String getTypeName() throws XmlException {
        return this.value.getTypeName();
    }

    public boolean isNull() throws XmlException {
        return this.valueType == 0;
    }

    public boolean isType(int type) throws XmlException {
        return this.valueType == type;
    }

    public boolean isNumber() throws XmlException {
        return this.isType(17) || this.isType(18) || this.isType(20);
    }

    public boolean isString() throws XmlException {
        return this.isType(29);
    }

    public boolean isBoolean() throws XmlException {
        return this.isType(13);
    }

    public boolean isBinary() throws XmlException {
        return this.isType(40);
    }

    public boolean isNode() throws XmlException {
        return this.isType(3);
    }

    public double asNumber() throws XmlException {
        return this.value.asNumber();
    }

    public String asString() throws XmlException {
        return this.value.asString();
    }

    public boolean asBoolean() throws XmlException {
        return this.value.asBoolean();
    }

    public byte[] asBinary() throws XmlException {
        return this.value.asBinary();
    }

    public boolean equals(XmlValue value) throws XmlException {
        return this.valueType == value.getType() && this.value.equals(value.value);
    }

    public static void setValue(XmlValue to, XmlValue from) throws XmlException {
        to.setValue(from);
    }

    public XmlDocument asDocument() throws XmlException {
        return this.value.asDocument();
    }

    public XmlEventReader asEventReader() throws XmlException {
        return this.value.asEventReader();
    }

    public String getNodeHandle() throws XmlException {
        return this.value.getNodeHandle();
    }

    public String getNodeName() throws XmlException {
        return this.value.getNodeName();
    }

    public String getNodeValue() throws XmlException {
        return this.value.getNodeValue();
    }

    public String getNamespaceURI() throws XmlException {
        return this.value.getNamespaceURI();
    }

    public String getPrefix() throws XmlException {
        return this.value.getPrefix();
    }

    public String getLocalName() throws XmlException {
        return this.value.getLocalName();
    }

    public short getNodeType() throws XmlException {
        return this.value.getNodeType();
    }

    public XmlValue getParentNode() throws XmlException {
        return this.value.getParentNode();
    }

    public XmlValue getFirstChild() throws XmlException {
        return this.value.getFirstChild();
    }

    public XmlValue getLastChild() throws XmlException {
        return this.value.getLastChild();
    }

    public XmlValue getPreviousSibling() throws XmlException {
        return this.value.getPreviousSibling();
    }

    public XmlValue getNextSibling() throws XmlException {
        return this.value.getNextSibling();
    }

    public XmlResults getAttributes() throws XmlException {
        return this.value.getAttributes();
    }

    public XmlValue getOwnerElement() throws XmlException {
        return this.value.getOwnerElement();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected XmlValue(XmlValue other, boolean own) throws XmlException {
        this.valueType = other.getType();
        if (own) {
            this.valueType = other.getType();
            Class<?> valueClass = other.value.getClass();
            String simpleName = valueClass.getSimpleName();
            if (simpleName.matches("Value")) {
                this.value = new Value();
                return;
            } else if (simpleName.matches("StringValue")) {
                this.value = new StringValue((StringValue)other.value);
                return;
            } else if (simpleName.matches("NodeValue")) {
                this.value = new NodeValue((NodeValue)other.value);
                return;
            } else {
                if (!simpleName.matches("BinaryValue")) throw new XmlException(14, "Invalid XmlValue object.");
                this.value = new BinaryValue((BinaryValue)other.value);
            }
            return;
        } else {
            this.value = other.value;
        }
    }

    protected XmlValue(int type, short nodeType, byte[] ID) {
        this.valueType = type;
        this.value = new NodeValue(nodeType, ID);
    }

    protected XmlValue(int type, String v, boolean validate) throws XmlException {
        if (validate) {
            HelperFunctions.validateString(type, v);
        }
        this.valueType = type;
        this.value = new StringValue(v);
    }

    protected void setResult(XmlResults result) {
        if (this.valueType == 3) {
            ((NodeValue)this.value).setResult(result);
        }
    }

    protected void setResultFromPtr(long ptr) {
        if (this.valueType == 3) {
            ((NodeValue)this.value).setResultFromPtr(ptr);
        }
    }

    protected long getReturnResultPtr() {
        if (this.valueType == 3) {
            return ((NodeValue)this.value).getReturnResultPtr();
        }
        return 0L;
    }

    protected XmlResults getResult() throws XmlException {
        if (this.valueType == 3) {
            return ((NodeValue)this.value).getResult();
        }
        return null;
    }

    protected long getResultPtr() throws XmlException {
        if (this.valueType == 3) {
            return ((NodeValue)this.value).getResultPtr();
        }
        return 0L;
    }

    protected long getManagerPtr() {
        if (this.valueType == 3) {
            return ((NodeValue)this.value).getManagerPtr();
        }
        return 0L;
    }

    protected long getTransactionPtr() {
        if (this.valueType == 3) {
            return ((NodeValue)this.value).getTransactionPtr();
        }
        return 0L;
    }

    protected XmlDocument getDocument() {
        if (this.valueType == 3) {
            return ((NodeValue)this.value).document;
        }
        return null;
    }

    protected void setManager(XmlManager mgr) {
        if (this.valueType == 3) {
            ((NodeValue)this.value).setManager(mgr);
        }
    }

    protected void setTransaction(XmlTransaction txn) {
        if (this.valueType == 3) {
            ((NodeValue)this.value).setTransaction(txn);
        }
    }

    protected void setDocument(XmlDocument doc) {
        if (this.valueType == 3) {
            ((NodeValue)this.value).setDocument(doc);
        }
    }

    protected byte[] getID() {
        if (this.valueType == 3) {
            return ((NodeValue)this.value).ID;
        }
        return null;
    }

    private void setValue(XmlValue from) throws XmlException {
        this.valueType = from.getType();
        Class<?> valueClass = from.value.getClass();
        String simpleName = valueClass.getSimpleName();
        if (simpleName.matches("Value")) {
            this.value = new Value();
        } else if (simpleName.matches("StringValue")) {
            this.value = new StringValue((StringValue)from.value);
        } else if (simpleName.matches("NodeValue")) {
            this.value = new NodeValue((NodeValue)from.value);
        } else if (simpleName.matches("BinaryValue")) {
            this.value = new BinaryValue((BinaryValue)from.value);
        } else {
            throw new XmlException(14, "Invalid XmlValue object.");
        }
    }

    class NodeValue
    extends Value {
        protected short nodeType;
        protected byte[] ID;
        protected XmlResults results;
        protected XmlDocument document;
        protected XmlManager manager;
        protected XmlTransaction transaction;
        protected long resultsPtr;
        protected XmlResults tempResults;

        public NodeValue(short nodeType, byte[] ID) {
            this.nodeType = nodeType;
            this.ID = ID;
        }

        public NodeValue(NodeValue other) {
            this.nodeType = other.nodeType;
            this.ID = other.ID;
            this.results = other.results;
            this.document = other.document;
            this.manager = other.manager;
            this.transaction = other.transaction;
        }

        protected void setResult(XmlResults result) {
            this.results = result;
            if (this.document != null) {
                this.document.setResults(result);
            }
        }

        protected XmlResults getResult() throws XmlException {
            if (this.results != null) {
                if (XmlResults.getCPtr(this.results) == 0L) {
                    throw new XmlException(14, "The results set for this value has been closed, cannot access value.");
                }
            } else {
                if (this.manager != null) {
                    if (XmlManager.getCPtr(this.manager) == 0L) {
                        throw new XmlException(14, "The manager has been closed, cannot access value.");
                    }
                    this.tempResults = this.transaction != null ? HelperFunctions.createResults(this.transaction, this.manager) : this.manager.createResults();
                    return this.tempResults;
                }
                throw new XmlException(0, "The XmlValue does not have an XmlResult or XmlManager.");
            }
            return this.results;
        }

        protected long getResultPtr() throws XmlException {
            return XmlResults.getCPtr(this.results);
        }

        protected long getReturnResultPtr() {
            return this.resultsPtr;
        }

        protected long getManagerPtr() {
            return XmlManager.getCPtr(this.manager);
        }

        protected long getTransactionPtr() {
            return XmlTransaction.getCPtr(this.transaction);
        }

        protected void setResultFromPtr(long ptr) {
            this.resultsPtr = ptr;
        }

        protected void setDocument(XmlDocument doc) {
            this.document = doc;
        }

        protected void setManager(XmlManager mgr) {
            this.manager = mgr;
            if (this.document != null) {
                this.document.setManager(mgr);
            }
        }

        protected void setTransaction(XmlTransaction txn) {
            this.transaction = txn;
            if (this.document != null) {
                this.document.setTransaction(txn);
            }
        }

        private void setInternals(NodeValue node) {
            node.results = this.results;
            node.manager = this.manager;
            node.document = this.document;
            node.transaction = this.transaction;
        }

        private void checkConstructedDocument() throws XmlException {
            if (this.document != null && this.document.results == null && this.document.docID == 0L) {
                throw new XmlException(14, "Navigation functions are not valid for XmlValues created from constructed documents.");
            }
        }

        public String getTypeURI() throws XmlException {
            String string = HelperFunctions.getTypeURI(this.ID, this.getResult());
            if (this.tempResults != null) {
                this.tempResults.delete();
            }
            return string;
        }

        public String getTypeName() throws XmlException {
            String string = HelperFunctions.getTypeName(this.ID, this.getResult());
            if (this.tempResults != null) {
                this.tempResults.delete();
            }
            return string;
        }

        public double asNumber() throws XmlException {
            if (this.document != null) {
                XmlValue string = new XmlValue(this.document.getContentAsString());
                return string.asNumber();
            }
            XmlValue string = new XmlValue(HelperFunctions.asString(this.ID, this.getResult()));
            if (this.tempResults != null) {
                this.tempResults.delete();
            }
            return string.asNumber();
        }

        public String asString() throws XmlException {
            if (this.document != null) {
                return this.document.getContentAsString();
            }
            String string = HelperFunctions.asString(this.ID, this.getResult());
            if (this.tempResults != null) {
                this.tempResults.delete();
            }
            return string;
        }

        public boolean asBoolean() throws XmlException {
            if (this.document != null) {
                XmlValue string = new XmlValue(this.document.getContentAsString());
                return string.asBoolean();
            }
            XmlValue string = new XmlValue(HelperFunctions.asString(this.ID, this.getResult()));
            if (this.tempResults != null) {
                this.tempResults.delete();
            }
            return string.asBoolean();
        }

        public XmlDocument asDocument() throws XmlException {
            if (this.document != null) {
                return this.document;
            }
            XmlDocument doc = HelperFunctions.asDocument(this.ID, this.getResult());
            if (this.tempResults != null) {
                this.tempResults.delete();
            }
            doc.setResults(this.results);
            doc.setManager(this.manager);
            doc.setTransaction(this.transaction);
            return doc;
        }

        public XmlEventReader asEventReader() throws XmlException {
            if (this.document != null) {
                return this.document.getContentAsEventReader();
            }
            XmlEventReader event = HelperFunctions.asEventReader(this.ID, this.getResult());
            if (this.tempResults != null) {
                this.tempResults.delete();
            }
            return event;
        }

        public String getNodeHandle() throws XmlException {
            String handle = HelperFunctions.getNodeHandle(this.ID, this.getResult());
            if (this.tempResults != null) {
                this.tempResults.delete();
            }
            return handle;
        }

        public boolean equals(XmlValue value) throws XmlException {
            NodeValue node = (NodeValue)value.value;
            if (this.nodeType == node.nodeType && this.ID.length == node.ID.length) {
                for (int i = 0; i < this.ID.length; ++i) {
                    if (this.ID[i] == node.ID[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public String getNodeName() throws XmlException {
            String name = HelperFunctions.getNodeName(this.ID, this.getResult());
            if (this.tempResults != null) {
                this.tempResults.delete();
            }
            return name;
        }

        public String getNodeValue() throws XmlException {
            if (this.document != null) {
                return this.document.getContentAsString();
            }
            String value = HelperFunctions.getNodeValue(this.ID, this.getResult());
            if (this.tempResults != null) {
                this.tempResults.delete();
            }
            return value;
        }

        public String getNamespaceURI() throws XmlException {
            String string = HelperFunctions.getNamespaceURI(this.ID, this.getResult());
            if (this.tempResults != null) {
                this.tempResults.delete();
            }
            return string;
        }

        public String getPrefix() throws XmlException {
            String string = HelperFunctions.getPrefix(this.ID, this.getResult());
            if (this.tempResults != null) {
                this.tempResults.delete();
            }
            return string;
        }

        public String getLocalName() throws XmlException {
            String string = HelperFunctions.getLocalName(this.ID, this.getResult());
            if (this.tempResults != null) {
                this.tempResults.delete();
            }
            return string;
        }

        public short getNodeType() throws XmlException {
            return this.nodeType;
        }

        public XmlValue getParentNode() throws XmlException {
            this.checkConstructedDocument();
            XmlValue node = HelperFunctions.getParentNode(this.ID, this.getResult());
            if (this.tempResults != null) {
                this.tempResults.delete();
            }
            if (node.isNode()) {
                this.setInternals((NodeValue)node.value);
            }
            return node;
        }

        public XmlValue getFirstChild() throws XmlException {
            this.checkConstructedDocument();
            XmlValue node = HelperFunctions.getFirstChild(this.ID, this.getResult());
            if (this.tempResults != null) {
                this.tempResults.delete();
            }
            if (node.isNode()) {
                this.setInternals((NodeValue)node.value);
            }
            return node;
        }

        public XmlValue getLastChild() throws XmlException {
            this.checkConstructedDocument();
            XmlValue node = HelperFunctions.getLastChild(this.ID, this.getResult());
            if (this.tempResults != null) {
                this.tempResults.delete();
            }
            if (node.isNode()) {
                this.setInternals((NodeValue)node.value);
            }
            return node;
        }

        public XmlValue getPreviousSibling() throws XmlException {
            this.checkConstructedDocument();
            XmlValue node = HelperFunctions.getPreviousSibling(this.ID, this.getResult());
            if (this.tempResults != null) {
                this.tempResults.delete();
            }
            if (node.isNode()) {
                this.setInternals((NodeValue)node.value);
            }
            return node;
        }

        public XmlValue getNextSibling() throws XmlException {
            this.checkConstructedDocument();
            XmlValue node = HelperFunctions.getNextSibling(this.ID, this.getResult());
            if (this.tempResults != null) {
                this.tempResults.delete();
            }
            if (node.isNode()) {
                this.setInternals((NodeValue)node.value);
            }
            return node;
        }

        public XmlResults getAttributes() throws XmlException {
            this.checkConstructedDocument();
            XmlResults xmlresults = HelperFunctions.getAttributes(this.ID, this.getResult());
            if (this.tempResults != null) {
                this.tempResults.delete();
            }
            XmlResults origResults = this.getResult();
            xmlresults.resultsMapPut(new Long(XmlResults.getCPtr(origResults)), origResults);
            return xmlresults;
        }

        public XmlValue getOwnerElement() throws XmlException {
            this.checkConstructedDocument();
            XmlValue node = HelperFunctions.getOwnerElement(this.ID, this.getResult());
            if (this.tempResults != null) {
                this.tempResults.delete();
            }
            if (node.isNode()) {
                this.setInternals((NodeValue)node.value);
            }
            return node;
        }
    }

    class BinaryValue
    extends Value {
        private byte[] dbt;

        public BinaryValue(byte[] newDBT) {
            this.dbt = newDBT;
        }

        public BinaryValue(BinaryValue other) throws XmlException {
            this.dbt = other.asBinary();
        }

        public byte[] asBinary() throws XmlException {
            return this.dbt;
        }

        public boolean equals(Value value) throws XmlException {
            byte[] otherDBT = value.asBinary();
            return Arrays.equals(this.dbt, otherDBT);
        }
    }

    class StringValue
    extends Value {
        private String value;

        public StringValue() {
        }

        public StringValue(StringValue other) throws XmlException {
            this.value = other.asString();
        }

        public boolean equals(Value value) throws XmlException {
            return this.value.equals(value.asString());
        }

        public StringValue(String v) {
            this.value = v;
        }

        public String asString() throws XmlException {
            return this.value;
        }

        public boolean asBoolean() throws XmlException {
            try {
                if (XmlValue.this.valueType == 18 || XmlValue.this.valueType == 17 || XmlValue.this.valueType == 20) {
                    double d = Double.parseDouble(this.value);
                    return d != 0.0;
                }
                if (XmlValue.this.valueType == 29) {
                    return this.value.length() != 0 && this.value.compareToIgnoreCase("false") != 0;
                }
                if (XmlValue.this.valueType == 13) {
                    return Boolean.parseBoolean(this.value);
                }
                throw new XmlException(14, "The requested type cannot be converted into a boolean.");
            }
            catch (Exception e) {
                throw new XmlException(14, "The requested type cannot be converted into a boolean.");
            }
        }

        public double asNumber() throws XmlException {
            try {
                if (XmlValue.this.valueType == 13) {
                    if (Boolean.parseBoolean(this.value)) {
                        return 1.0;
                    }
                    return 0.0;
                }
                if (XmlValue.this.valueType == 29 || XmlValue.this.valueType == 32) {
                    try {
                        return Double.parseDouble(this.value);
                    }
                    catch (Exception e) {
                        return Double.NaN;
                    }
                }
                if (XmlValue.this.valueType == 20 || XmlValue.this.valueType == 18 || XmlValue.this.valueType == 17) {
                    return Double.parseDouble(this.value);
                }
                throw new XmlException(14, "The requested type cannot be converted into a number.");
            }
            catch (Exception e) {
                throw new XmlException(14, "The requested type cannot be converted into a number.");
            }
        }

        public String getTypeURI() throws XmlException {
            return HelperFunctions.getAtomicTypeURI(XmlValue.this.valueType, this.value);
        }

        public String getTypeName() throws XmlException {
            return HelperFunctions.getAtomicTypeName(XmlValue.this.valueType, this.value);
        }
    }

    class Value {
        public boolean equals(Value value) throws XmlException {
            return true;
        }

        public String getTypeURI() throws XmlException {
            return "";
        }

        public String getTypeName() throws XmlException {
            return "";
        }

        public double asNumber() throws XmlException {
            throw new XmlException(14, "Can't convert XmlValue to Number");
        }

        public String asString() throws XmlException {
            throw new XmlException(14, "Can't convert XmlValue to String");
        }

        public boolean asBoolean() throws XmlException {
            throw new XmlException(14, "Can't convert XmlValue to Boolean");
        }

        public byte[] asBinary() throws XmlException {
            throw new XmlException(14, "Can't convert XmlValue to Binary");
        }

        public XmlDocument asDocument() throws XmlException {
            throw new XmlException(14, "Can't convert XmlValue to Document");
        }

        public XmlEventReader asEventReader() throws XmlException {
            throw new XmlException(14, "Can't convert XmlValue to XmlEventReader");
        }

        public String getNodeHandle() throws XmlException {
            throw new XmlException(14, "Cannot convert XmlValue to Node");
        }

        public String getNodeName() throws XmlException {
            throw new XmlException(14, "Cannot convert XmlValue to Node");
        }

        public String getNodeValue() throws XmlException {
            throw new XmlException(14, "Cannot convert XmlValue to Node");
        }

        public String getNamespaceURI() throws XmlException {
            throw new XmlException(14, "Cannot convert XmlValue to Node");
        }

        public String getPrefix() throws XmlException {
            throw new XmlException(14, "Cannot convert XmlValue to Node");
        }

        public String getLocalName() throws XmlException {
            throw new XmlException(14, "Cannot convert XmlValue to Node");
        }

        public short getNodeType() throws XmlException {
            throw new XmlException(14, "Cannot convert XmlValue to Node");
        }

        public XmlValue getParentNode() throws XmlException {
            throw new XmlException(14, "Cannot convert XmlValue to Node");
        }

        public XmlValue getFirstChild() throws XmlException {
            throw new XmlException(14, "Cannot convert XmlValue to Node");
        }

        public XmlValue getLastChild() throws XmlException {
            throw new XmlException(14, "Cannot convert XmlValue to Node");
        }

        public XmlValue getPreviousSibling() throws XmlException {
            throw new XmlException(14, "Cannot convert XmlValue to Node");
        }

        public XmlValue getNextSibling() throws XmlException {
            throw new XmlException(14, "Cannot convert XmlValue to Node");
        }

        public XmlResults getAttributes() throws XmlException {
            throw new XmlException(14, "Cannot convert XmlValue to Node");
        }

        public XmlValue getOwnerElement() throws XmlException {
            throw new XmlException(14, "Cannot convert XmlValue to Node");
        }
    }
}

