/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.dbxml;

import com.sleepycat.dbxml.XmlDocument;
import com.sleepycat.dbxml.XmlException;
import com.sleepycat.dbxml.XmlValue;
import com.sleepycat.dbxml.dbxml_javaJNI;
import java.util.HashMap;

public class XmlResults {
    private long swigCPtr;
    protected boolean swigCMemOwn;
    protected HashMap resultsMap = null;

    protected XmlResults(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(XmlResults obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            dbxml_javaJNI.delete_XmlResults(this.swigCPtr);
        }
        this.swigCPtr = 0L;
    }

    public XmlResults(XmlResults results) throws XmlException {
        this(dbxml_javaJNI.XmlResults_copy(XmlResults.getCPtr(results), results), true);
        if (results.resultsMap != null) {
            this.resultsMap = new HashMap(results.resultsMap);
        }
    }

    public XmlValue next() throws XmlException {
        XmlValue value = this.nextInternal();
        if (value == null || value.isNull()) {
            return null;
        }
        if (value.getReturnResultPtr() != 0L) {
            value.setResult(this.resultsMapGet(new Long(value.getReturnResultPtr())));
        } else if (value.isNode()) {
            value.setResult(this);
        }
        return value;
    }

    public XmlValue previous() throws XmlException {
        XmlValue value = this.previousInternal();
        if (value == null || value.isNull()) {
            return null;
        }
        if (value.getReturnResultPtr() != 0L) {
            value.setResult(this.resultsMapGet(new Long(value.getReturnResultPtr())));
        } else if (value.isNode()) {
            value.setResult(this);
        }
        return value;
    }

    public XmlValue peek() throws XmlException {
        XmlValue value = this.peekInternal();
        if (value == null || value.isNull()) {
            return null;
        }
        if (value.getReturnResultPtr() != 0L) {
            value.setResult(this.resultsMapGet(new Long(value.getReturnResultPtr())));
        } else if (value.isNode()) {
            value.setResult(this);
        }
        return value;
    }

    public void add(XmlValue value) throws XmlException {
        if (value == null || value.isNull()) {
            throw new XmlException(14, "A null XmlValue object cannot be added to the result set.");
        }
        if (value.getResultPtr() != 0L) {
            this.resultsMapPut(new Long(value.getResultPtr()), value.getResult());
        }
        this.addInternal(value);
    }

    public void reset() throws XmlException {
        this.resetInternal();
    }

    public boolean next(XmlDocument document) throws XmlException {
        XmlDocument doc = this.nextDocumentInternal();
        if (doc == null) {
            return false;
        }
        document.copy(doc);
        document.setResults(this);
        return true;
    }

    public boolean previous(XmlDocument document) throws XmlException {
        XmlDocument doc = this.previousDocumentInternal();
        if (doc == null) {
            return false;
        }
        document.copy(doc);
        document.setResults(this);
        return true;
    }

    public boolean peek(XmlDocument document) throws XmlException {
        XmlDocument doc = this.peekDocumentInternal();
        if (doc == null) {
            return false;
        }
        document.copy(doc);
        document.setResults(this);
        return true;
    }

    protected XmlResults resultsMapGet(Long key) {
        if (this.resultsMap == null) {
            return null;
        }
        return (XmlResults)this.resultsMap.get(key);
    }

    protected void resultsMapPut(Long key, XmlResults value) {
        if (this.resultsMap == null) {
            this.resultsMap = new HashMap();
        }
        this.resultsMap.put(key, value);
    }

    public boolean hasNext() throws XmlException {
        return dbxml_javaJNI.XmlResults_hasNext(this.swigCPtr, this);
    }

    public boolean hasPrevious() throws XmlException {
        return dbxml_javaJNI.XmlResults_hasPrevious(this.swigCPtr, this);
    }

    public boolean isNull() throws XmlException {
        return dbxml_javaJNI.XmlResults_isNull(this.swigCPtr, this);
    }

    public int getEvaluationType() throws XmlException {
        return dbxml_javaJNI.XmlResults_getEvaluationType(this.swigCPtr, this);
    }

    public int size() throws XmlException {
        return dbxml_javaJNI.XmlResults_size(this.swigCPtr, this);
    }

    public void resetInternal() throws XmlException {
        dbxml_javaJNI.XmlResults_resetInternal(this.swigCPtr, this);
    }

    protected static XmlResults copy(XmlResults results) {
        long cPtr = dbxml_javaJNI.XmlResults_copy(XmlResults.getCPtr(results), results);
        return cPtr == 0L ? null : new XmlResults(cPtr, false);
    }

    protected XmlValue nextInternal() {
        return dbxml_javaJNI.XmlResults_nextInternal(this.swigCPtr, this);
    }

    protected XmlValue previousInternal() {
        return dbxml_javaJNI.XmlResults_previousInternal(this.swigCPtr, this);
    }

    protected XmlValue peekInternal() {
        return dbxml_javaJNI.XmlResults_peekInternal(this.swigCPtr, this);
    }

    protected void addInternal(XmlValue value) {
        dbxml_javaJNI.XmlResults_addInternal(this.swigCPtr, this, value);
    }

    protected XmlDocument nextDocumentInternal() {
        return dbxml_javaJNI.XmlResults_nextDocumentInternal(this.swigCPtr, this);
    }

    protected XmlDocument previousDocumentInternal() {
        return dbxml_javaJNI.XmlResults_previousDocumentInternal(this.swigCPtr, this);
    }

    protected XmlDocument peekDocumentInternal() {
        return dbxml_javaJNI.XmlResults_peekDocumentInternal(this.swigCPtr, this);
    }
}

