/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.dbxml;

import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.Transaction;
import com.sleepycat.dbxml.XmlException;
import com.sleepycat.dbxml.dbxml_javaJNI;

public class XmlTransaction {
    private long swigCPtr;
    protected boolean swigCMemOwn;
    Transaction txn;

    protected XmlTransaction(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(XmlTransaction obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            dbxml_javaJNI.delete_XmlTransaction(this.swigCPtr);
        }
        this.swigCPtr = 0L;
    }

    public void setTransaction(Transaction txn) throws XmlException {
        this.txn = txn;
    }

    public Transaction getTransaction() throws XmlException {
        return this.txn;
    }

    public void abort() throws XmlException {
        try {
            this.txn.abort();
        }
        catch (DatabaseException de) {
            throw new XmlException(5, de.toString(), de, de.getErrno(), 0, 0);
        }
        this.delete();
    }

    public void commit() throws XmlException {
        try {
            this.txn.commit();
        }
        catch (DatabaseException de) {
            throw new XmlException(5, de.toString(), de, de.getErrno(), 0, 0);
        }
        this.delete();
    }

    public void commitSync() throws XmlException {
        try {
            this.txn.commitSync();
        }
        catch (DatabaseException de) {
            throw new XmlException(5, de.toString(), de, de.getErrno(), 0, 0);
        }
        this.delete();
    }

    public void commitNoSync() throws XmlException {
        try {
            this.txn.commitNoSync();
        }
        catch (DatabaseException de) {
            throw new XmlException(5, de.toString(), de, de.getErrno(), 0, 0);
        }
        this.delete();
    }
}

