/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.xml;

import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.framework.dialog.DialogManager;
import com.japisoft.framework.preferences.Preferences;
import com.japisoft.framework.ui.toolkit.BrowserCaller;
import com.japisoft.framework.xml.refactor.Refactor;
import com.japisoft.framework.xml.refactor.RefactorManager;
import com.japisoft.framework.xml.refactor.elements.RefactorObj;
import com.japisoft.framework.xml.refactor.ui.RefactorUI;
import com.japisoft.p.Manager;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.action.ActionModel;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractAction;

public class RefactorAction
extends AbstractAction {
    public void actionPerformed(ActionEvent actionEvent) {
        if (Manager.isFree()) {
            EditixFactory.buildAndShowInformationDialog("This action is not available inside the Free Edition.\nPlease look at http://www.editix.com");
            BrowserCaller.displayURL("http://www.editix.com");
        } else {
            RefactorUI refactorUI;
            XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedContainer();
            if (xMLContainer == null) {
                return;
            }
            if (EditixFactory.mustSaveDialog(xMLContainer)) {
                return;
            }
            boolean bl = ActionModel.activeActionByName(ActionModel.SAVE_ACTION, xMLContainer, xMLContainer.getEditor());
            if (!bl) {
                return;
            }
            ArrayList arrayList = (ArrayList)xMLContainer.getDocumentInfo().getProperty("refactor");
            RefactorManager.removeNonDefaultRefactors();
            if (arrayList != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    RefactorManager.addRefactorAt((RefactorObj)arrayList.get(i), i);
                }
            }
            if (DialogManager.showDialog(EditixFrame.ACCESSOR, "Refactor", "XML refactoring", "Choose a refactor element and click on the Action column\nYou can set several refactor elements\nATTR is for ATTRIBUTE", null, refactorUI = new RefactorUI(xMLContainer.getCurrentElementNode())) == DialogManager.OK_ID) {
                refactorUI.dispose();
                try {
                    Refactor refactor = new Refactor();
                    Boolean bl2 = (Boolean)xMLContainer.getProperty("prefAPosEntity");
                    if (bl2 != null) {
                        refactor.setReplaceAPos(bl2);
                    }
                    refactor.setReplaceAmp(Preferences.getPreference("xmlconfig", "format-replaceAmp", true));
                    refactor.setReplaceGt(Preferences.getPreference("xmlconfig", "format-replaceGt", true));
                    refactor.setReplaceLt(Preferences.getPreference("xmlconfig", "format-replaceLt", true));
                    refactor.setReplaceAPos(Preferences.getPreference("xmlconfig", "format-replaceAPos", true));
                    refactor.setReplaceQuote(Preferences.getPreference("xmlconfig", "format-replaceQuote", true));
                    Refactor.INDENT_SIZE_PROPERTY = Preferences.getPreference("xmlconfig", "format-space", 1);
                    String string = null;
                    if (refactorUI.getModel().isRelativeRefactoring() && (string = xMLContainer.getCurrentElementNode().getXPathLocation()) != null) {
                        refactor.setContext(string);
                    }
                    String string2 = refactor.refactor(new File(xMLContainer.getCurrentDocumentLocation()), refactorUI.getModel().getRefactorObjs());
                    if (string == null) {
                        xMLContainer.setText(string2);
                    } else {
                        int n = xMLContainer.getCurrentElementNode().getStartingOffset();
                        int n2 = xMLContainer.getCurrentElementNode().getStoppingOffset();
                        xMLContainer.getEditor().select(n, n2);
                        xMLContainer.getEditor().replaceSelection(string2);
                        xMLContainer.getEditor().select(xMLContainer.getCaretPosition(), xMLContainer.getCaretPosition());
                    }
                }
                catch (Exception exception) {
                    EditixFactory.buildAndShowErrorDialog("Cannot refactor " + exception.getMessage());
                }
            }
        }
    }
}

