/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.document;

import com.japisoft.editix.Main;
import com.japisoft.editix.document.DocumentModel;
import com.japisoft.editix.document.TemplateInfo;
import com.japisoft.fastparser.Parser;
import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.framework.xml.XMLToolkit;
import com.japisoft.xmlpad.XMLDocumentInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;

public class TemplateModel {
    private static ArrayList model = null;

    public static void loadModel() {
        model = null;
        InputStream inputStream = ClassLoader.getSystemResourceAsStream("templates.xml");
        if (inputStream == null) {
            System.err.println("Can't find templates.xml");
            System.exit(1);
        }
        TemplateModel.loadModel(inputStream);
        File file = Main.getRegisteredPath();
        File file2 = new File(file, "templates.xml");
        if (file2.exists()) {
            try {
                TemplateModel.loadModel(new FileInputStream(file2));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeModel() {
        Object object;
        File file = Main.getRegisteredPath();
        File file2 = new File(file, "template");
        file2.mkdir();
        SimpleNode simpleNode = new SimpleNode("templates");
        for (int i = 0; i < TemplateModel.getTemplateCount(); ++i) {
            object = TemplateModel.getTemplate(i);
            if (((TemplateInfo)object).system) continue;
            SimpleNode simpleNode2 = new SimpleNode("template");
            String string = ((TemplateInfo)object).label;
            string = string.replaceAll("<", "&lt;");
            string = string.replaceAll(">", "&gt;");
            simpleNode2.setAttribute("label", string);
            simpleNode2.setAttribute("type", ((TemplateInfo)object).type);
            if (((TemplateInfo)object).location != null) {
                simpleNode2.setAttribute("location", ((TemplateInfo)object).location);
            } else if (((TemplateInfo)object).content != null) {
                for (int j = 1; j < 200; ++j) {
                    File file3 = new File(file2, "template" + j + ".tpl");
                    if (file3.exists()) continue;
                    try {
                        String string2 = XMLToolkit.getXMLEncoding(((TemplateInfo)object).content);
                        OutputStreamWriter outputStreamWriter = null;
                        outputStreamWriter = string2 == null ? new FileWriter(file3) : new OutputStreamWriter((OutputStream)new FileOutputStream(file3), string2);
                        outputStreamWriter.write(((TemplateInfo)object).content);
                        ((Writer)outputStreamWriter).close();
                        ((TemplateInfo)object).location = file3.toString();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    ((TemplateInfo)object).content = null;
                    break;
                }
            }
            if (((TemplateInfo)object).location == null) continue;
            simpleNode2.setAttribute("location", ((TemplateInfo)object).location);
            simpleNode.addChildNode(simpleNode2);
        }
        File file4 = new File(file, "templates.xml");
        try {
            object = new FileWriter(file4);
            try {
                ((Writer)object).write(simpleNode.getRawXML());
            }
            finally {
                ((OutputStreamWriter)object).close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void loadModel(InputStream inputStream) {
        Parser parser = new Parser();
        parser.setInputStream(inputStream);
        try {
            parser.parse();
            SimpleNode simpleNode = (SimpleNode)parser.getDocument().getRoot();
            if (model == null) {
                model = new ArrayList();
            }
            for (int i = 0; i < simpleNode.childCount(); ++i) {
                TemplateInfo templateInfo = TemplateModel.buildTemplate(simpleNode.childAt(i));
                model.add(templateInfo);
            }
        }
        catch (Exception exception) {
            System.err.println("Can't parse templates.xml : " + exception.getMessage() + " !");
        }
    }

    static TemplateInfo buildTemplate(SimpleNode simpleNode) {
        TemplateInfo templateInfo = new TemplateInfo();
        templateInfo.label = simpleNode.getAttribute("label");
        templateInfo.location = simpleNode.getAttribute("location");
        templateInfo.type = simpleNode.getAttribute("type");
        templateInfo.system = "true".equals(simpleNode.getAttribute("system"));
        templateInfo.encoding = simpleNode.getAttribute("encoding");
        templateInfo.defDTDLocation = simpleNode.getAttribute("defDTDLocation");
        templateInfo.defDTDRoot = simpleNode.getAttribute("defDTDRoot");
        XMLDocumentInfo xMLDocumentInfo = DocumentModel.getDocumentForType(templateInfo.type);
        if (xMLDocumentInfo != null) {
            templateInfo.icon = xMLDocumentInfo.getDocumentIcon();
        }
        return templateInfo;
    }

    public static int getTemplateCount() {
        if (model == null) {
            return 0;
        }
        return model.size();
    }

    public static TemplateInfo getTemplate(int n) {
        if (model == null) {
            return null;
        }
        return (TemplateInfo)model.get(n);
    }

    public static void moveTemplateUp(TemplateInfo templateInfo) {
        int n = model.indexOf(templateInfo);
        model.remove(n);
        model.set(n - 1, templateInfo);
    }

    public static void moveTemplateDown(TemplateInfo templateInfo) {
        int n = model.indexOf(templateInfo);
        model.remove(n);
        model.set(n + 1, templateInfo);
    }

    public static void removeTemplate(TemplateInfo templateInfo) {
        model.remove(templateInfo);
    }

    public static void addTemplate(TemplateInfo templateInfo) {
        model.add(templateInfo);
    }

    static {
        TemplateModel.loadModel();
    }
}

